/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.utility.item.custom;

import com.benbenlaw.utility.item.UtilityDataComponents;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class DeathStoneItem
extends Item {
    public DeathStoneItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult use(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide() && stack.has((DataComponentType)UtilityDataComponents.GLOBAL_POS.get())) {
            GlobalPos globalPos = (GlobalPos)stack.get((DataComponentType)UtilityDataComponents.GLOBAL_POS.get());
            assert (globalPos != null);
            player.teleportTo(Objects.requireNonNull(Objects.requireNonNull(player.level().getServer()).getLevel(globalPos.dimension())), (double)globalPos.pos().getX() + 0.5, (double)globalPos.pos().getY() + 0.5, (double)globalPos.pos().getZ() + 0.5, EnumSet.noneOf(Relative.class), player.getYRot(), player.getXRot(), false);
            stack.shrink(1);
            player.playNotifySound(SoundEvents.PORTAL_TRAVEL, SoundSource.PLAYERS, 0.2f, 1.0f);
            player.displayClientMessage((Component)Component.translatable((String)"tooltip.death_stone.returning").withStyle(ChatFormatting.GREEN), false);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull TooltipDisplay display, @NotNull Consumer<Component> consumer, TooltipFlag flag) {
        if (Minecraft.getInstance().hasShiftDown()) {
            consumer.accept((Component)Component.translatable((String)"tooltip.death_stone.info").withStyle(ChatFormatting.BLUE));
        } else {
            consumer.accept((Component)Component.translatable((String)"tooltip.bblcore.shift").withStyle(ChatFormatting.YELLOW));
        }
    }
}

