/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.utility.item.custom;

import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class FloaterItem
extends Item {
    public FloaterItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult use(Level level, Player player, @NotNull InteractionHand hand) {
        Item item;
        ItemStack offHand = player.getOffhandItem();
        ItemStack mainHand = player.getMainHandItem();
        if (!level.isClientSide() && offHand.is((Item)this) && (item = mainHand.getItem()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Vec3 lookVec = player.getLookAngle().normalize().scale(3.0);
            BlockPos blockPos = player.blockPosition().offset((int)Math.round(lookVec.x), (int)Math.round(lookVec.y) + 1, (int)Math.round(lookVec.z));
            if (level.getBlockState(blockPos).isAir() || level.getBlockState(blockPos).is(Blocks.WATER)) {
                level.setBlockAndUpdate(blockPos, blockItem.getBlock().defaultBlockState());
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull TooltipDisplay display, @NotNull Consumer<Component> consumer, TooltipFlag flag) {
        if (Minecraft.getInstance().hasShiftDown()) {
            consumer.accept((Component)Component.translatable((String)"tooltip.floater.info").withStyle(ChatFormatting.BLUE));
        } else {
            consumer.accept((Component)Component.translatable((String)"tooltip.bblcore.shift").withStyle(ChatFormatting.YELLOW));
        }
    }
}

