/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.utility.item.custom;

import com.benbenlaw.utility.config.UtilityStartUpConfig;
import com.benbenlaw.utility.util.UtilityTags;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class SaplingGrowerItem
extends Item {
    public int TOTAL_GROWTH_ATTEMPTS = (Integer)UtilityStartUpConfig.totalGrowthAttempts.get();

    public SaplingGrowerItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(pos);
        ItemStack stack = context.getItemInHand();
        Player player = context.getPlayer();
        if (!level.isClientSide() && state.is(UtilityTags.Blocks.VALID_FOR_SAPLING_GROWER)) {
            this.tryToGrow(level, pos);
            if (((Boolean)UtilityStartUpConfig.saplingGrowerTakesDamage.get()).booleanValue()) {
                assert (player != null);
                stack.hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(stack));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void tryToGrow(Level level, BlockPos pos) {
        for (int i = 0; i < this.TOTAL_GROWTH_ATTEMPTS; ++i) {
            this.doGrow(level, pos);
        }
    }

    public void doGrow(Level level, BlockPos pos) {
        Block block;
        BlockState blockState = level.getBlockState(pos);
        if (!level.isClientSide() && (block = blockState.getBlock()) instanceof BonemealableBlock) {
            BonemealableBlock bonemealableBlock = (BonemealableBlock)block;
            bonemealableBlock.performBonemeal((ServerLevel)level, level.random, pos, blockState);
        }
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull TooltipDisplay display, @NotNull Consumer<Component> consumer, TooltipFlag flag) {
        if (Minecraft.getInstance().hasShiftDown()) {
            consumer.accept((Component)Component.translatable((String)"tooltip.sapling_grower.info").withStyle(ChatFormatting.BLUE));
        } else {
            consumer.accept((Component)Component.translatable((String)"tooltip.bblcore.shift").withStyle(ChatFormatting.YELLOW));
        }
    }
}

