/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.utility.recipe.custom;

import com.benbenlaw.utility.recipe.DryingTableRecipeInput;
import com.benbenlaw.utility.recipe.DryingTableRecipeType;
import com.benbenlaw.utility.recipe.DryingTableRecipeTypeCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategories;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.NotNull;

public record DryingTableRecipe(SizedIngredient input, ItemStack output, DryingTableRecipeType recipeType) implements Recipe<DryingTableRecipeInput>
{
    public boolean matches(@NotNull DryingTableRecipeInput recipeInput, Level level) {
        if (level.isClientSide()) {
            return false;
        }
        ItemStack stack = recipeInput.getItem(0);
        if (stack.isEmpty()) {
            return false;
        }
        if (this.recipeType == DryingTableRecipeType.DRYING && !recipeInput.isWaterlogged()) {
            return this.input.test(stack);
        }
        if (this.recipeType == DryingTableRecipeType.SOAKING && recipeInput.isWaterlogged()) {
            return this.input.test(stack);
        }
        return false;
    }

    @NotNull
    public ItemStack assemble(@NotNull DryingTableRecipeInput recipeInput, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return this.output.copy();
    }

    @NotNull
    public RecipeSerializer<? extends Recipe<DryingTableRecipeInput>> getSerializer() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<? extends Recipe<DryingTableRecipeInput>> getType() {
        return Type.INSTANCE;
    }

    @NotNull
    public PlacementInfo placementInfo() {
        return PlacementInfo.NOT_PLACEABLE;
    }

    @NotNull
    public RecipeBookCategory recipeBookCategory() {
        return RecipeBookCategories.CRAFTING_MISC;
    }

    public boolean isSpecial() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<DryingTableRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public final MapCodec<DryingTableRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SizedIngredient.NESTED_CODEC.fieldOf("input").forGetter(DryingTableRecipe::input), (App)ItemStack.CODEC.fieldOf("output").forGetter(DryingTableRecipe::output), (App)DryingTableRecipeTypeCodec.CODEC.fieldOf("recipe_type").forGetter(DryingTableRecipe::recipeType)).apply((Applicative)instance, DryingTableRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, DryingTableRecipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        @NotNull
        public MapCodec<DryingTableRecipe> codec() {
            return this.CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, DryingTableRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static DryingTableRecipe read(RegistryFriendlyByteBuf buffer) {
            SizedIngredient input = (SizedIngredient)SizedIngredient.STREAM_CODEC.decode((Object)buffer);
            ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            DryingTableRecipeType type = DryingTableRecipeTypeCodec.readFromBuffer(buffer);
            return new DryingTableRecipe(input, output, type);
        }

        private static void write(RegistryFriendlyByteBuf buffer, DryingTableRecipe recipe) {
            SizedIngredient.STREAM_CODEC.encode((Object)buffer, (Object)recipe.input);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.output);
            DryingTableRecipeTypeCodec.writeToBuffer(buffer, recipe.recipeType);
        }
    }

    public static class Type
    implements RecipeType<DryingTableRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }
}

