/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.utility.recipe.custom;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategories;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.fluid.FluidUtil;
import org.jetbrains.annotations.NotNull;

public record FluidGeneratorRecipe(String input, FluidStack output) implements Recipe<RecipeInput>
{
    public boolean matches(@NotNull RecipeInput recipeInput, Level level) {
        if (level.isClientSide()) {
            return false;
        }
        ItemStack stack = recipeInput.getItem(0);
        if (stack.isEmpty()) {
            return false;
        }
        FluidStack fluidInStack = FluidUtil.getFirstStackContained((ItemStack)stack);
        Optional fluidInTank = BuiltInRegistries.FLUID.getOptional(ResourceLocation.parse((String)this.input));
        return fluidInTank.filter(fluid -> fluidInStack.getFluid() == fluid).isPresent();
    }

    @NotNull
    public ItemStack assemble(@NotNull RecipeInput recipeInput, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    @NotNull
    public RecipeSerializer<? extends Recipe<RecipeInput>> getSerializer() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<? extends Recipe<RecipeInput>> getType() {
        return Type.INSTANCE;
    }

    @NotNull
    public PlacementInfo placementInfo() {
        return PlacementInfo.NOT_PLACEABLE;
    }

    @NotNull
    public RecipeBookCategory recipeBookCategory() {
        return RecipeBookCategories.CRAFTING_MISC;
    }

    public boolean isSpecial() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<FluidGeneratorRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public final MapCodec<FluidGeneratorRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("input").forGetter(FluidGeneratorRecipe::input), (App)FluidStack.CODEC.fieldOf("output").forGetter(FluidGeneratorRecipe::output)).apply((Applicative)instance, FluidGeneratorRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, FluidGeneratorRecipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        @NotNull
        public MapCodec<FluidGeneratorRecipe> codec() {
            return this.CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, FluidGeneratorRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static FluidGeneratorRecipe read(RegistryFriendlyByteBuf buffer) {
            String input = (String)ByteBufCodecs.STRING_UTF8.decode((Object)buffer);
            FluidStack output = (FluidStack)FluidStack.STREAM_CODEC.decode((Object)buffer);
            return new FluidGeneratorRecipe(input, output);
        }

        private static void write(RegistryFriendlyByteBuf buffer, FluidGeneratorRecipe recipe) {
            ByteBufCodecs.STRING_UTF8.encode((Object)buffer, (Object)recipe.input);
            FluidStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.output);
        }
    }

    public static class Type
    implements RecipeType<FluidGeneratorRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }
}

