/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.utility.recipe.custom;

import com.benbenlaw.utility.recipe.ResourceGeneratorRecipeInput;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategories;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public record ResourceGeneratorRecipe(ItemStack input, ItemStack output, FluidStack leftFluid, FluidStack rightFluid, boolean consumeLeft, boolean consumeRight) implements Recipe<ResourceGeneratorRecipeInput>
{
    public boolean matches(@NotNull ResourceGeneratorRecipeInput recipeInput, Level level) {
        if (level.isClientSide()) {
            return false;
        }
        boolean inputMatches = this.input().is(recipeInput.getItem(0).getItem());
        boolean leftFluidMatches = this.leftFluid.is(recipeInput.getLeftFluid().getFluid()) && this.leftFluid.getAmount() <= recipeInput.getLeftFluid().getAmount();
        boolean rightFluidMatches = this.rightFluid.is(recipeInput.getRightFluid().getFluid()) && this.rightFluid.getAmount() <= recipeInput.getRightFluid().getAmount();
        return inputMatches && leftFluidMatches && rightFluidMatches;
    }

    @NotNull
    public ItemStack assemble(@NotNull ResourceGeneratorRecipeInput recipeInput, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return this.output.copy();
    }

    @NotNull
    public RecipeSerializer<? extends Recipe<ResourceGeneratorRecipeInput>> getSerializer() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<? extends Recipe<ResourceGeneratorRecipeInput>> getType() {
        return Type.INSTANCE;
    }

    @NotNull
    public PlacementInfo placementInfo() {
        return PlacementInfo.NOT_PLACEABLE;
    }

    @NotNull
    public RecipeBookCategory recipeBookCategory() {
        return RecipeBookCategories.CRAFTING_MISC;
    }

    public boolean isSpecial() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<ResourceGeneratorRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public final MapCodec<ResourceGeneratorRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.CODEC.fieldOf("input").forGetter(ResourceGeneratorRecipe::input), (App)ItemStack.CODEC.fieldOf("output").forGetter(ResourceGeneratorRecipe::output), (App)FluidStack.CODEC.fieldOf("left_fluid").forGetter(ResourceGeneratorRecipe::leftFluid), (App)FluidStack.CODEC.fieldOf("right_fluid").forGetter(ResourceGeneratorRecipe::rightFluid), (App)Codec.BOOL.fieldOf("consume_left").forGetter(ResourceGeneratorRecipe::consumeLeft), (App)Codec.BOOL.fieldOf("consume_right").forGetter(ResourceGeneratorRecipe::consumeRight)).apply((Applicative)instance, ResourceGeneratorRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, ResourceGeneratorRecipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        @NotNull
        public MapCodec<ResourceGeneratorRecipe> codec() {
            return this.CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, ResourceGeneratorRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static ResourceGeneratorRecipe read(RegistryFriendlyByteBuf buffer) {
            ItemStack input = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            FluidStack leftFluid = (FluidStack)FluidStack.STREAM_CODEC.decode((Object)buffer);
            FluidStack rightFluid = (FluidStack)FluidStack.STREAM_CODEC.decode((Object)buffer);
            boolean consumeLeft = buffer.readBoolean();
            boolean consumeRight = buffer.readBoolean();
            return new ResourceGeneratorRecipe(input, output, leftFluid, rightFluid, consumeLeft, consumeRight);
        }

        private static void write(RegistryFriendlyByteBuf buffer, ResourceGeneratorRecipe recipe) {
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.input);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.output);
            FluidStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.leftFluid);
            FluidStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.rightFluid);
            buffer.writeBoolean(recipe.consumeLeft);
            buffer.writeBoolean(recipe.consumeRight);
        }
    }

    public static class Type
    implements RecipeType<ResourceGeneratorRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }
}

