/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.utility.screen.breaker;

import com.benbenlaw.core.block.entity.handler.item.FilterItemHandler;
import com.benbenlaw.core.block.entity.handler.item.InputItemHandler;
import com.benbenlaw.core.screen.SimpleAbstractContainerMenu;
import com.benbenlaw.core.screen.util.slot.FilterSlot;
import com.benbenlaw.core.screen.util.slot.InputSlot;
import com.benbenlaw.utility.block.entity.BlockBreakerBlockEntity;
import com.benbenlaw.utility.screen.UtilityMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.transfer.ResourceHandler;

public class BlockBreakerMenu
extends SimpleAbstractContainerMenu {
    protected BlockBreakerBlockEntity blockEntity;
    protected Level level;
    protected ContainerData data;
    protected Player player;
    protected BlockPos blockPos;

    public BlockBreakerMenu(int containerID, Inventory inventory, FriendlyByteBuf extraData) {
        this(containerID, inventory, extraData.readBlockPos(), (ContainerData)new SimpleContainerData(2));
    }

    public BlockBreakerMenu(int containerID, Inventory inventory, BlockPos pos, ContainerData data) {
        super((MenuType)UtilityMenuTypes.BLOCK_BREAKER_MENU.get(), containerID, inventory, pos, 1);
        this.player = inventory.player;
        this.level = inventory.player.level();
        this.data = data;
        this.blockPos = pos;
        this.blockEntity = (BlockBreakerBlockEntity)this.level.getBlockEntity(pos);
        assert (this.blockEntity != null);
        this.addSlot((Slot)new InputSlot((ResourceHandler)this.blockEntity.getInputHandler(), (arg_0, arg_1, arg_2) -> ((InputItemHandler)this.blockEntity.getInputHandler()).set(arg_0, arg_1, arg_2), 0, 60, 23));
        for (int i = 0; i < 8; ++i) {
            this.addSlot((Slot)new FilterSlot((ResourceHandler)this.blockEntity.getFilterHandler(), (arg_0, arg_1, arg_2) -> ((FilterItemHandler)this.blockEntity.getFilterHandler()).set(arg_0, arg_1, arg_2), i, 8 + i * 18, 53));
        }
        this.addDataSlots(data);
    }

    public void clicked(int slotId, int button, ClickType clickType, Player player) {
        Object object;
        if (slotId >= 0 && slotId < this.slots.size() && (object = this.slots.get(slotId)) instanceof FilterSlot) {
            FilterSlot filterSlot = (FilterSlot)object;
            ItemStack carried = this.getCarried();
            if (!carried.isEmpty()) {
                filterSlot.set(carried.copyWithCount(1));
            } else {
                filterSlot.set(ItemStack.EMPTY);
            }
            return;
        }
        super.clicked(slotId, button, clickType, player);
    }

    public boolean isCrafting() {
        return this.data.get(0) > 0;
    }

    public int getScaledProgress() {
        int progress = this.data.get(0);
        int maxProgress = this.data.get(1);
        int progressArrowSize = 24;
        return maxProgress != 0 && progress != 0 ? progress * progressArrowSize / maxProgress : 0;
    }
}

