/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.utility.screen.clock;

import com.benbenlaw.utility.Utility;
import com.benbenlaw.utility.network.packets.SyncRedstoneClockPacket;
import com.benbenlaw.utility.screen.clock.RedstoneClockMenu;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import org.jetbrains.annotations.NotNull;

public class RedstoneClockScreen
extends AbstractContainerScreen<RedstoneClockMenu> {
    private static final ResourceLocation TEXTURE = Utility.rl("textures/gui/redstone_clock_gui.png");
    private static final ResourceLocation PROGRESS_ARROW = Utility.rl("progress_arrow");
    private EditBox maxProgressBox;
    private EditBox onTime;
    private EditBox signalStrength;

    public RedstoneClockScreen(RedstoneClockMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
    }

    protected void init() {
        super.init();
        this.clearWidgets();
        this.maxProgressBox = new EditBox(this.font, this.leftPos + 10, this.topPos + 53, 38, 12, (Component)Component.literal((String)"Max Progress"));
        this.maxProgressBox.setMaxLength(5);
        this.maxProgressBox.setValue(String.valueOf(((RedstoneClockMenu)this.menu).blockEntity.getMaxProgress()));
        this.onTime = new EditBox(this.font, this.leftPos + 128, this.topPos + 53, 38, 12, (Component)Component.literal((String)"On Time"));
        this.onTime.setMaxLength(5);
        this.onTime.setValue(String.valueOf(((RedstoneClockMenu)this.menu).blockEntity.getOnTime()));
        this.signalStrength = new EditBox(this.font, this.leftPos + 76, this.topPos + 53, 20, 12, (Component)Component.literal((String)"Signal Strength"));
        this.signalStrength.setMaxLength(2);
        this.signalStrength.setValue(String.valueOf(((RedstoneClockMenu)this.menu).blockEntity.getSignalStrength()));
        this.maxProgressBox.setResponder(this::onSearchChanged);
        this.onTime.setResponder(this::onSearchChanged);
        this.signalStrength.setResponder(this::onSearchChanged);
    }

    private void onSearchChanged(String text) {
        int maxValue = this.parseSafe(this.maxProgressBox);
        int onTimeValue = this.parseSafe(this.onTime);
        int signalStrengthValue = this.parseSafe(this.signalStrength);
        signalStrengthValue = Math.max(1, Math.min(15, signalStrengthValue));
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new SyncRedstoneClockPacket(((RedstoneClockMenu)this.menu).blockPos, maxValue, onTimeValue, signalStrengthValue), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    protected void renderBg(GuiGraphics guiGraphics, float v, int i, int i1) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, x, y, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        if (((RedstoneClockMenu)this.menu).isCrafting()) {
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, PROGRESS_ARROW, 24, 16, 0, 0, x + 76, y + 34, ((RedstoneClockMenu)this.menu).getScaledProgress() + 1, 16);
        }
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        if (this.maxProgressBox != null) {
            this.maxProgressBox.render(guiGraphics, mouseX, mouseY, partialTick);
        }
        if (this.onTime != null) {
            this.onTime.render(guiGraphics, mouseX, mouseY, partialTick);
        }
        if (this.signalStrength != null) {
            this.signalStrength.render(guiGraphics, mouseX, mouseY, partialTick);
        }
        if (this.maxProgressBox != null && this.maxProgressBox.isMouseOver((double)mouseX, (double)mouseY)) {
            this.renderTooltip(guiGraphics, "tooltip.redstone_clock.max_progress", mouseX, mouseY);
        } else if (this.onTime != null && this.onTime.isMouseOver((double)mouseX, (double)mouseY)) {
            this.renderTooltip(guiGraphics, "tooltip.redstone_clock.on_time", mouseX, mouseY);
        } else if (this.signalStrength != null && this.signalStrength.isMouseOver((double)mouseX, (double)mouseY)) {
            this.renderTooltip(guiGraphics, "tooltip.redstone_clock.signal_strength", mouseX, mouseY);
        }
    }

    private void renderTooltip(GuiGraphics guiGraphics, String text, int mouseX, int mouseY) {
        List<ClientTooltipComponent> components = Collections.singletonList(ClientTooltipComponent.create((FormattedCharSequence)Component.translatable((String)text).getVisualOrderText()));
        guiGraphics.renderTooltip(Minecraft.getInstance().font, components, mouseX, mouseY, DefaultTooltipPositioner.INSTANCE, null);
    }

    public boolean charTyped(CharacterEvent event) {
        if (this.maxProgressBox.charTyped(event)) {
            return true;
        }
        if (this.onTime.charTyped(event)) {
            return true;
        }
        if (this.signalStrength.charTyped(event)) {
            return true;
        }
        return super.charTyped(event);
    }

    public boolean keyPressed(KeyEvent event) {
        if (this.maxProgressBox.keyPressed(event)) {
            return true;
        }
        if (this.onTime.keyPressed(event)) {
            return true;
        }
        if (this.signalStrength.keyPressed(event)) {
            return true;
        }
        return super.keyPressed(event);
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        if (this.maxProgressBox.mouseClicked(event, doubleClick)) {
            this.setFocused((GuiEventListener)this.maxProgressBox);
            return true;
        }
        if (this.onTime.mouseClicked(event, doubleClick)) {
            this.setFocused((GuiEventListener)this.onTime);
            return true;
        }
        if (this.signalStrength.mouseClicked(event, doubleClick)) {
            this.setFocused((GuiEventListener)this.signalStrength);
            return true;
        }
        return super.mouseClicked(event, doubleClick);
    }

    private int parseSafe(EditBox box) {
        String value = box.getValue();
        if (value == null || value.isEmpty()) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

