/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.utility.screen.collector;

import com.benbenlaw.core.screen.SimpleAbstractContainerMenu;
import com.benbenlaw.core.screen.util.slot.FilterFluidSlot;
import com.benbenlaw.utility.block.entity.FluidCollectorBlockEntity;
import com.benbenlaw.utility.screen.UtilityMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.fluid.FluidUtil;

public class FluidCollectorMenu
extends SimpleAbstractContainerMenu {
    protected FluidCollectorBlockEntity blockEntity;
    protected Level level;
    protected ContainerData data;
    protected Player player;
    protected BlockPos blockPos;

    public FluidCollectorMenu(int containerID, Inventory inventory, FriendlyByteBuf extraData) {
        this(containerID, inventory, extraData.readBlockPos(), (ContainerData)new SimpleContainerData(2));
    }

    public FluidCollectorMenu(int containerID, Inventory inventory, BlockPos pos, ContainerData data) {
        super((MenuType)UtilityMenuTypes.FLUID_COLLECTOR_MENU.get(), containerID, inventory, pos, 0);
        this.player = inventory.player;
        this.level = inventory.player.level();
        this.data = data;
        this.blockPos = pos;
        this.blockEntity = (FluidCollectorBlockEntity)this.level.getBlockEntity(pos);
        assert (this.blockEntity != null);
        this.addSlot((Slot)new FilterFluidSlot(this.blockEntity.getFilterFluidHandler(), 0, 134, 53));
        this.addDataSlots(data);
    }

    public void clicked(int slotId, int button, ClickType clickType, Player player) {
        if (slotId >= 0 && slotId < this.slots.size()) {
            Object object = this.slots.get(slotId);
            if (object instanceof FilterFluidSlot) {
                FilterFluidSlot filterSlot = (FilterFluidSlot)object;
                if (this.getCarried().isEmpty()) {
                    filterSlot.setEmpty(0);
                } else {
                    ItemStack carried = this.getCarried();
                    FluidStack fluidInStack = FluidUtil.getFirstStackContained((ItemStack)carried);
                    if (!fluidInStack.isEmpty()) {
                        filterSlot.set(fluidInStack, 0);
                    }
                }
                return;
            }
            super.clicked(slotId, button, clickType, player);
        }
    }

    public boolean isCrafting() {
        return this.data.get(0) > 0;
    }

    public int getScaledProgress() {
        int progress = this.data.get(0);
        int maxProgress = this.data.get(1);
        int progressArrowSize = 24;
        return maxProgress != 0 && progress != 0 ? progress * progressArrowSize / maxProgress : 0;
    }
}

