/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.utility.screen.collector;

import com.benbenlaw.core.screen.util.FluidRenderingUtils;
import com.benbenlaw.core.screen.util.button.WhitelistButton;
import com.benbenlaw.utility.Utility;
import com.benbenlaw.utility.screen.collector.FluidCollectorMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidStacksResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidUtil;

public class FluidCollectorScreen
extends AbstractContainerScreen<FluidCollectorMenu> {
    private static final ResourceLocation TEXTURE = Utility.rl("textures/gui/fluid_collector_gui.png");
    private static final ResourceLocation PROGRESS_ARROW = Utility.rl("progress_arrow");

    public FluidCollectorScreen(FluidCollectorMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
    }

    protected void init() {
        super.init();
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.addRenderableWidget((GuiEventListener)WhitelistButton.create((int)(x + 151), (int)(y + 52), (int)20, (int)20, (BlockEntity)((FluidCollectorMenu)this.menu).blockEntity));
    }

    protected void renderBg(GuiGraphics guiGraphics, float v, int i, int i1) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, x, y, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        if (((FluidCollectorMenu)this.menu).isCrafting()) {
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, PROGRESS_ARROW, 24, 16, 0, 0, x + 92, y + 34, ((FluidCollectorMenu)this.menu).getScaledProgress() + 1, 16);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        FluidStack fluidStack = FluidUtil.getStack((ResourceHandler)((FluidCollectorMenu)this.menu).blockEntity.getFilterFluidHandler(), (int)0);
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        FluidRenderingUtils.renderFluidStack((GuiGraphics)guiGraphics, (FluidStack)fluidStack, (int)(x + 134), (int)(y + 53), (int)16, (int)16, (int)mouseX, (int)mouseY);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTanks(guiGraphics, x, y, mouseX, mouseY);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        FluidRenderingUtils.renderFluidStackTooltip((GuiGraphics)guiGraphics, (FluidStack)fluidStack, (int)(x + 134), (int)(y + 53), (int)16, (int)16, (int)mouseX, (int)mouseY);
    }

    private void renderTanks(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        FluidRenderingUtils.renderFluid((GuiGraphics)guiGraphics, (FluidStacksResourceHandler)((FluidCollectorMenu)this.menu).blockEntity.getFluidOutputHandler(), (int)0, (int)x, (int)y, (int)60, (int)20, (int)47, (int)16, (int)mouseX, (int)mouseY);
    }
}

