/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.utility.screen.generator;

import com.benbenlaw.core.block.entity.handler.item.InputItemHandler;
import com.benbenlaw.core.block.entity.handler.item.OutputItemHandler;
import com.benbenlaw.core.screen.SimpleAbstractContainerMenu;
import com.benbenlaw.core.screen.util.slot.InputSlot;
import com.benbenlaw.core.screen.util.slot.ResultSlot;
import com.benbenlaw.utility.block.entity.ResourceGeneratorBlockEntity;
import com.benbenlaw.utility.screen.UtilityMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.transfer.ResourceHandler;

public class ResourceGeneratorMenu
extends SimpleAbstractContainerMenu {
    protected ResourceGeneratorBlockEntity blockEntity;
    protected Level level;
    protected ContainerData data;
    protected Player player;
    protected BlockPos blockPos;

    public ResourceGeneratorMenu(int containerID, Inventory inventory, FriendlyByteBuf extraData) {
        this(containerID, inventory, extraData.readBlockPos(), (ContainerData)new SimpleContainerData(2));
    }

    public ResourceGeneratorMenu(int containerID, Inventory inventory, BlockPos pos, ContainerData data) {
        super((MenuType)UtilityMenuTypes.RESOURCE_GENERATOR_MENU.get(), containerID, inventory, pos, 2);
        this.player = inventory.player;
        this.level = inventory.player.level();
        this.data = data;
        this.blockPos = pos;
        this.blockEntity = (ResourceGeneratorBlockEntity)this.level.getBlockEntity(pos);
        assert (this.blockEntity != null);
        this.addSlot((Slot)new InputSlot((ResourceHandler)this.blockEntity.getInputHandler(), (arg_0, arg_1, arg_2) -> ((InputItemHandler)this.blockEntity.getInputHandler()).set(arg_0, arg_1, arg_2), 0, 44, 35).size(1));
        this.addSlot((Slot)new ResultSlot((ResourceHandler)this.blockEntity.getOutputHandler(), (arg_0, arg_1, arg_2) -> ((OutputItemHandler)this.blockEntity.getOutputHandler()).set(arg_0, arg_1, arg_2), 0, 116, 35));
        this.addDataSlots(data);
    }

    public boolean isCrafting() {
        return this.data.get(0) > 0;
    }

    public int getScaledProgress() {
        int progress = this.data.get(0);
        int maxProgress = this.data.get(1);
        int progressArrowSize = 24;
        return maxProgress != 0 && progress != 0 ? progress * progressArrowSize / maxProgress : 0;
    }
}

