/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.utility.screen.generator;

import com.benbenlaw.core.screen.util.FluidRenderingUtils;
import com.benbenlaw.utility.Utility;
import com.benbenlaw.utility.screen.generator.ResourceGeneratorMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.transfer.fluid.FluidStacksResourceHandler;

public class ResourceGeneratorScreen
extends AbstractContainerScreen<ResourceGeneratorMenu> {
    private static final ResourceLocation TEXTURE = Utility.rl("textures/gui/resource_generator_gui.png");
    private static final ResourceLocation PROGRESS_ARROW = Utility.rl("progress_arrow");

    public ResourceGeneratorScreen(ResourceGeneratorMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
    }

    protected void renderBg(GuiGraphics guiGraphics, float v, int i, int i1) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, x, y, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        if (((ResourceGeneratorMenu)this.menu).isCrafting()) {
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, PROGRESS_ARROW, 24, 16, 0, 0, x + 76, y + 34, ((ResourceGeneratorMenu)this.menu).getScaledProgress() + 1, 16);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTanks(guiGraphics, x, y, mouseX, mouseY);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    private void renderTanks(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        FluidRenderingUtils.renderFluid((GuiGraphics)guiGraphics, (FluidStacksResourceHandler)((ResourceGeneratorMenu)this.menu).blockEntity.getInputFluidHandlerLeft(), (int)0, (int)x, (int)y, (int)8, (int)20, (int)47, (int)16, (int)mouseX, (int)mouseY);
        FluidRenderingUtils.renderFluid((GuiGraphics)guiGraphics, (FluidStacksResourceHandler)((ResourceGeneratorMenu)this.menu).blockEntity.getInputFluidHandlerRight(), (int)0, (int)x, (int)y, (int)152, (int)20, (int)47, (int)16, (int)mouseX, (int)mouseY);
    }
}

