/*
 * Decompiled with CFR 0.152.
 */
package xen42.peacefulitems;

import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.class_1928;
import net.minecraft.class_2248;
import net.minecraft.class_3195;
import net.minecraft.class_3611;
import net.minecraft.class_3852;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7045;
import net.minecraft.class_7225;
import xen42.peacefulitems.PeacefulMod;
import xen42.peacefulitems.PeacefulModBlocks;
import xen42.peacefulitems.PeacefulModFluids;
import xen42.peacefulitems.PeacefulModItems;
import xen42.peacefulitems.PeacefulModTags;
import xen42.peacefulitems.PeacefulModVillagers;

@Environment(value=EnvType.CLIENT)
public abstract class PeacefulModLanguageProvider
extends FabricLanguageProvider {
    public PeacefulModLanguageProvider(FabricDataOutput output, String languageCode, CompletableFuture<class_7225.class_7874> registryLookup) {
        super(output, languageCode, registryLookup);
    }

    public void generateTranslations(class_7225.class_7874 registryLookup, FabricLanguageProvider.TranslationBuilder translationBuilder) {
        this.generate(registryLookup, new ModTranslationBuilder(translationBuilder));
    }

    public String processValue(String value) {
        return value;
    }

    public abstract void generate(class_7225.class_7874 var1, ModTranslationBuilder var2);

    @Environment(value=EnvType.CLIENT)
    public class ModTranslationBuilder
    implements FabricLanguageProvider.TranslationBuilder {
        private final FabricLanguageProvider.TranslationBuilder original;

        public ModTranslationBuilder(FabricLanguageProvider.TranslationBuilder original) {
            this.original = original;
        }

        public void add(String key, String value) {
            this.original.add(key, PeacefulModLanguageProvider.this.processValue(value));
        }

        public void add(class_6862<?> key, String value) {
            this.add(key.getTranslationKey(), value);
        }

        public void addTags(String value, class_6862<?> ... keys) {
            for (class_6862<?> key : keys) {
                this.add(key, value);
            }
        }

        public void add(class_1928.class_4313<?> key, String value) {
            this.add(key.method_27334(), value);
        }

        public void add(class_1928.class_4313<?> key, String title, String description) {
            this.add(key.method_27334(), title);
            this.add(key.method_27334() + ".description", description);
        }

        public void add(class_3611 fluid, String value) {
            class_5321 key = fluid.method_40178().method_40237();
            this.add("block." + key.method_29177().method_12836() + "." + key.method_29177().method_12832(), value);
        }

        public void addVillagerProfession(class_5321<class_3852> key, String value) {
            this.add("entity." + key.method_29177().method_12836() + ".villager." + key.method_29177().method_12832(), value);
        }

        public void addFilledMap(class_6862<class_3195> structure, String value) {
            this.add("filled_map." + structure.comp_327().method_12836() + "." + structure.comp_327().method_12832(), value);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class ChineseSimplified
    extends PeacefulModLanguageProvider {
        public ChineseSimplified(FabricDataOutput output, String languageCode, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(output, languageCode, registryLookup);
        }

        public ChineseSimplified(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registryLookup) {
            this(output, "zh_cn", registryLookup);
        }

        @Override
        public void generate(class_7225.class_7874 registryLookup, ModTranslationBuilder translationBuilder) {
            translationBuilder.add(PeacefulModItems.BAT_WING, "\u8759\u8760\u7fc5\u8180");
            translationBuilder.add(PeacefulModItems.GUANO, "\u7caa\u4fbf");
            translationBuilder.add(PeacefulModItems.ECTOPLASM, "\u7075\u8d28");
            translationBuilder.add(PeacefulModItems.SULPHUR, "\u786b\u78fa");
            translationBuilder.add(PeacefulModItems.FLAX, "\u4e9a\u9ebb\u79cd\u5b50");
            translationBuilder.add(PeacefulModBlocks.SULPHUR_BLOCK, "\u786b\u78fa\u5757");
            translationBuilder.add(PeacefulModBlocks.SULPHUR_STAIRS, "\u786b\u78fa\u697c\u68af");
            translationBuilder.add(PeacefulModBlocks.SULPHUR_SLAB, "\u786b\u78fa\u53f0\u9636");
            translationBuilder.add(PeacefulModBlocks.SULPHUR_WALL, "\u786b\u78fa\u56f4\u5899");
            translationBuilder.add(PeacefulModBlocks.CHISELED_SULPHUR_BLOCK, "\u96d5\u7eb9\u786b\u78fa\u5757");
            translationBuilder.add(PeacefulModBlocks.SULPHUR_ORE, "\u786b\u78fa\u77ff\u77f3");
            translationBuilder.add(PeacefulModBlocks.FOSSIL_ORE, "\u5316\u77f3\u77ff\u77f3");
            translationBuilder.add(PeacefulModBlocks.DEEPSLATE_FOSSIL_ORE, "\u6df1\u5c42\u5316\u77f3\u77ff\u77f3");
            translationBuilder.add(PeacefulModBlocks.SOUL_SOIL_FOSSIL_ORE, "\u4e0b\u754c\u5316\u77f3\u77ff\u77f3");
            translationBuilder.add(PeacefulModBlocks.EFFIGY_ALTAR, "\u5851\u50cf\u796d\u575b");
            translationBuilder.add(PeacefulModItems.CLAM, "\u86e4");
            translationBuilder.add(PeacefulModItems.COOKED_CLAM, "\u719f\u86e4");
            translationBuilder.add((class_2248)PeacefulModBlocks.BLAZE_PICKLE, "\u70c8\u7130\u73ca\u745a");
            translationBuilder.add((class_2248)PeacefulModBlocks.BREEZE_CORAL, "\u65cb\u98ce\u73ca\u745a");
            translationBuilder.add(PeacefulModItems.GHASTLING_SPAWN_EGG, "\u5c0f\u7cbe\u7075\u5237\u602a\u86cb");
            translationBuilder.add(PeacefulModItems.END_CLAM_SPAWN_EGG, "\u672b\u5f71\u86e4\u5237\u602a\u86cb");
            translationBuilder.addVillagerProfession(PeacefulModVillagers.DJ_VILLAGER_KEY, "\u97f3\u4e50\u5bb6");
            translationBuilder.add(PeacefulMod.GHASTLING_ENTITY, "\u5c0f\u7cbe\u7075");
            translationBuilder.add(PeacefulMod.END_CLAM_ENTITY, "\u672b\u5f71\u86e4");
            translationBuilder.add(PeacefulModItems.CAPE, "\u62ab\u98ce");
            translationBuilder.add(PeacefulModItems.WITHER_EFFIGY, "\u51cb\u7075\u5851\u50cf");
            translationBuilder.add(PeacefulModItems.DRAGON_EFFIGY, "\u9f99\u5851\u50cf");
            translationBuilder.add(PeacefulModItems.GUARDIAN_EFFIGY, "\u8fdc\u53e4\u5851\u50cf");
            translationBuilder.add(PeacefulModItems.RAID_EFFIGY, "\u88ad\u51fb\u5851\u50cf");
            translationBuilder.add((class_3611)PeacefulModFluids.DRAGON_BREATH, "\u9f99\u606f");
            translationBuilder.add((class_2248)PeacefulModBlocks.DRAGON_BREATH_CAULDRON, "\u88c5\u6709\u9f99\u606f\u7684\u70bc\u836f\u9505");
            translationBuilder.addFilledMap(PeacefulModTags.StructureTags.EFFIGY_ALTAR_DUNGEON, "\u5851\u50cf\u796d\u575b\u5730\u56fe");
            translationBuilder.addFilledMap(PeacefulModTags.StructureTags.TRAIL_RUINS, "\u53e4\u8ff9\u5e9f\u589f\u5730\u56fe");
            translationBuilder.addFilledMap((class_6862<class_3195>)class_7045.field_37049, "\u6d77\u5e95\u5e9f\u589f\u5730\u56fe");
            translationBuilder.add(PeacefulMod.ENABLE_STARVING_PEACEFUL, "\u542f\u7528\u548c\u5e73\u4e2d\u7684\u997f\u6b7b");
            translationBuilder.add(PeacefulMod.ENABLE_SUPER_HEALING_PEACEFUL, "\u542f\u7528\u548c\u5e73\u4e2d\u7684\u8d85\u7ea7\u751f\u547d\u6062\u590d");
            translationBuilder.add(PeacefulMod.ENABLE_ENDER_DRAGON_FIGHT_PEACEFUL, "\u542f\u7528\u548c\u5e73\u4e2d\u7684\u672b\u5f71\u9f99");
            translationBuilder.add(PeacefulModTags.ItemTags.EFFIGIES, "\u5851\u50cf");
            translationBuilder.add(PeacefulModTags.StructureTags.EFFIGY_ALTAR_DUNGEON, "\u5851\u50cf\u796d\u575b");
            translationBuilder.add(PeacefulModTags.StructureTags.TRAIL_RUINS, "\u53e4\u8ff9\u5e9f\u589f");
            translationBuilder.add(class_7045.field_37049, "\u6d77\u5e95\u5e9f\u589f");
            translationBuilder.addTags("\u7075\u9b42\u571f\u542b\u77ff\u77f3\u5730", PeacefulModTags.ItemTags.ORE_BEARING_GROUND_SOUL_SOIL, PeacefulModTags.BlockTags.ORE_BEARING_GROUND_SOUL_SOIL);
            translationBuilder.addTags("\u5730\u4e0b\u7075\u9b42\u571f\u77ff\u77f3", PeacefulModTags.ItemTags.ORES_IN_GROUND_SOUL_SOIL, PeacefulModTags.BlockTags.ORES_IN_GROUND_SOUL_SOIL);
            translationBuilder.addTags("\u5316\u77f3\u77ff\u77f3", PeacefulModTags.ItemTags.FOSSIL_ORES, PeacefulModTags.ItemTags.FOSSIL_ORES_C, PeacefulModTags.BlockTags.FOSSIL_ORES, PeacefulModTags.BlockTags.FOSSIL_ORES_C);
            translationBuilder.addTags("\u786b\u78fa\u77ff\u77f3", PeacefulModTags.ItemTags.SULPHUR_ORES, PeacefulModTags.ItemTags.SULPHUR_ORES_C, PeacefulModTags.ItemTags.SULFUR_ORES, PeacefulModTags.BlockTags.SULPHUR_ORES, PeacefulModTags.BlockTags.SULPHUR_ORES_C, PeacefulModTags.BlockTags.SULFUR_ORES);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class EnglishUpsideDown
    extends English {
        private static final String NORMAL_CHARS = " abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_,;.?!/\\'\"";
        private static final String UPSIDE_DOWN_CHARS = " \u0250q\u0254p\u01dd\u025f\u1d77\u0265\u1d09\u027e\u029e\ua781\u026fuodb\u0279s\u0287n\u028c\u028dx\u028ez\u2c6f\u15fa\u0186\u15e1\u018e\u2132\u2141HI\u0550\ua7b0\ua780WNO\u0500\u1f49\u1d1aS\u27d8\u2229\u039bMX\u028eZ0\u295d\u1614\u0190\u07c8\u03db9\u312586\u203e'\u2e35\u02d9\u00bf\u00a1\\/,\u201e";

        public EnglishUpsideDown(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(output, "en_ud", registryLookup);
        }

        @Override
        public String processValue(String value) {
            return EnglishUpsideDown.toUpsideDown(value);
        }

        private static String toUpsideDown(String name) {
            StringBuilder builder = new StringBuilder();
            for (int i = name.length() - 1; i >= 0; --i) {
                if (i > 2 && name.substring(i - 3, i + 1).equals("%1$s")) {
                    builder.append(name, i - 3, i + 1);
                    i -= 4;
                    continue;
                }
                if (i < 0) continue;
                char normalChar = name.charAt(i);
                int normalIndex = NORMAL_CHARS.indexOf(normalChar);
                if (normalIndex < 0) {
                    builder.append(normalChar);
                    continue;
                }
                char upsideDown = UPSIDE_DOWN_CHARS.charAt(normalIndex);
                builder.append(upsideDown);
            }
            return builder.toString();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class English
    extends PeacefulModLanguageProvider {
        public English(FabricDataOutput output, String languageCode, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(output, languageCode, registryLookup);
        }

        public English(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registryLookup) {
            this(output, "en_us", registryLookup);
        }

        @Override
        public void generate(class_7225.class_7874 registryLookup, ModTranslationBuilder translationBuilder) {
            translationBuilder.add(PeacefulModItems.BAT_WING, "Bat Wing");
            translationBuilder.add(PeacefulModItems.GUANO, "Guano");
            translationBuilder.add(PeacefulModItems.ECTOPLASM, "Ectoplasm");
            translationBuilder.add(PeacefulModItems.SULPHUR, "Brimstone");
            translationBuilder.add(PeacefulModItems.FLAX, "Flax Seeds");
            translationBuilder.add(PeacefulModBlocks.SULPHUR_BLOCK, "Block of Brimstone");
            translationBuilder.add(PeacefulModBlocks.SULPHUR_STAIRS, "Brimstone Stairs");
            translationBuilder.add(PeacefulModBlocks.SULPHUR_SLAB, "Brimstone Slab");
            translationBuilder.add(PeacefulModBlocks.SULPHUR_WALL, "Brimstone Wall");
            translationBuilder.add(PeacefulModBlocks.CHISELED_SULPHUR_BLOCK, "Chiseled Brimstone Block");
            translationBuilder.add(PeacefulModBlocks.SULPHUR_ORE, "Brimstone Ore");
            translationBuilder.add(PeacefulModBlocks.FOSSIL_ORE, "Fossil Ore");
            translationBuilder.add(PeacefulModBlocks.DEEPSLATE_FOSSIL_ORE, "Deepslate Fossil Ore");
            translationBuilder.add(PeacefulModBlocks.SOUL_SOIL_FOSSIL_ORE, "Nether Fossil Ore");
            translationBuilder.add(PeacefulModBlocks.EFFIGY_ALTAR, "Effigy Altar");
            translationBuilder.add(PeacefulModItems.CLAM, "Clam");
            translationBuilder.add(PeacefulModItems.COOKED_CLAM, "Cooked Clam");
            translationBuilder.add((class_2248)PeacefulModBlocks.BLAZE_PICKLE, "Blaze Coral");
            translationBuilder.add((class_2248)PeacefulModBlocks.BREEZE_CORAL, "Breeze Coral");
            translationBuilder.add(PeacefulModItems.GHASTLING_SPAWN_EGG, "Wisp Spawn Egg");
            translationBuilder.add(PeacefulModItems.END_CLAM_SPAWN_EGG, "Enderclam Spawn Egg");
            translationBuilder.addVillagerProfession(PeacefulModVillagers.DJ_VILLAGER_KEY, "Musician");
            translationBuilder.add(PeacefulMod.GHASTLING_ENTITY, "Wisp");
            translationBuilder.add(PeacefulMod.END_CLAM_ENTITY, "Enderclam");
            translationBuilder.add(PeacefulModItems.CAPE, "Cape");
            translationBuilder.add(PeacefulModItems.WITHER_EFFIGY, "Wither Effigy");
            translationBuilder.add(PeacefulModItems.DRAGON_EFFIGY, "Dragon Effigy");
            translationBuilder.add(PeacefulModItems.GUARDIAN_EFFIGY, "Elder Effigy");
            translationBuilder.add(PeacefulModItems.RAID_EFFIGY, "Raid Effigy");
            translationBuilder.add((class_3611)PeacefulModFluids.DRAGON_BREATH, "Dragon's Breath");
            translationBuilder.add((class_2248)PeacefulModBlocks.DRAGON_BREATH_CAULDRON, "Dragon's Breath Cauldron");
            translationBuilder.addFilledMap(PeacefulModTags.StructureTags.EFFIGY_ALTAR_DUNGEON, "Effigy Altar Dungeon Map");
            translationBuilder.addFilledMap(PeacefulModTags.StructureTags.TRAIL_RUINS, "Trail Ruins Map");
            translationBuilder.addFilledMap((class_6862<class_3195>)class_7045.field_37049, "Ocean Ruin Map");
            translationBuilder.add(PeacefulMod.ENABLE_STARVING_PEACEFUL, "Enable starving in peaceful");
            translationBuilder.add(PeacefulMod.ENABLE_SUPER_HEALING_PEACEFUL, "Enable super healing in peaceful");
            translationBuilder.add(PeacefulMod.ENABLE_ENDER_DRAGON_FIGHT_PEACEFUL, "Enable Ender Dragon fight in peaceful");
            translationBuilder.add(PeacefulModTags.ItemTags.EFFIGIES, "Effigies");
            translationBuilder.add(PeacefulModTags.StructureTags.EFFIGY_ALTAR_DUNGEON, "Effigy Altar Dungeon");
            translationBuilder.add(PeacefulModTags.StructureTags.TRAIL_RUINS, "Trail Ruins");
            translationBuilder.add(class_7045.field_37049, "Ocean Ruin");
            translationBuilder.addTags("Soul Soil Ore Bearing Ground", PeacefulModTags.ItemTags.ORE_BEARING_GROUND_SOUL_SOIL, PeacefulModTags.BlockTags.ORE_BEARING_GROUND_SOUL_SOIL);
            translationBuilder.addTags("Soul Soil Ores In Ground", PeacefulModTags.ItemTags.ORES_IN_GROUND_SOUL_SOIL, PeacefulModTags.BlockTags.ORES_IN_GROUND_SOUL_SOIL);
            translationBuilder.addTags("Fossil Ores", PeacefulModTags.ItemTags.FOSSIL_ORES, PeacefulModTags.ItemTags.FOSSIL_ORES_C, PeacefulModTags.BlockTags.FOSSIL_ORES, PeacefulModTags.BlockTags.FOSSIL_ORES_C);
            translationBuilder.addTags("Brimstone Ores", PeacefulModTags.ItemTags.SULPHUR_ORES, PeacefulModTags.ItemTags.SULPHUR_ORES_C, PeacefulModTags.ItemTags.SULFUR_ORES, PeacefulModTags.BlockTags.SULPHUR_ORES, PeacefulModTags.BlockTags.SULPHUR_ORES_C, PeacefulModTags.BlockTags.SULFUR_ORES);
        }
    }
}

