/*
 * Decompiled with CFR 0.152.
 */
package xen42.peacefulitems.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.chars.CharArraySet;
import it.unimi.dsi.fastutil.chars.CharSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import net.minecraft.class_10295;
import net.minecraft.class_10302;
import net.minecraft.class_10355;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_3956;
import net.minecraft.class_5699;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9887;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import xen42.peacefulitems.PeacefulMod;
import xen42.peacefulitems.PeacefulModBlocks;
import xen42.peacefulitems.PeacefulModItems;
import xen42.peacefulitems.recipe.EffigyAltarRecipeDisplay;
import xen42.peacefulitems.recipe.EffigyAltarRecipeInput;

public class EffigyAltarRecipe
implements class_1860<EffigyAltarRecipeInput> {
    final RawRecipe raw;
    public final class_1799 result;
    final OptionalInt cost;
    final String group;
    @Nullable
    private class_9887 ingredientPlacement;

    public EffigyAltarRecipe(String group, RawRecipe raw, class_1799 result) {
        this(group, raw, result, OptionalInt.empty());
    }

    public EffigyAltarRecipe(String group, RawRecipe raw, class_1799 result, Optional<Integer> cost) {
        this(group, raw, result, cost.stream().mapToInt(i -> i).findFirst());
    }

    public EffigyAltarRecipe(String group, RawRecipe raw, class_1799 result, OptionalInt cost) {
        this.group = group;
        this.raw = raw;
        this.result = result;
        this.cost = cost;
    }

    public class_3956<EffigyAltarRecipe> method_17716() {
        return PeacefulMod.EFFIGY_ALTAR_RECIPE_TYPE;
    }

    public class_1865<? extends EffigyAltarRecipe> method_8119() {
        return PeacefulMod.EFFIGY_ALTAR_RECIPE_SERIALIZER;
    }

    public class_10355 method_64668() {
        return PeacefulMod.EFFIGY_ALTAR_RECIPE_BOOK_CATEGORY;
    }

    public String method_8112() {
        return this.group;
    }

    public boolean method_8118() {
        return false;
    }

    public boolean method_49188() {
        return true;
    }

    public class_2371<class_1799> getRecipeRemainders(EffigyAltarRecipeInput input) {
        return EffigyAltarRecipe.collectRecipeRemainders(input);
    }

    public static class_2371<class_1799> collectRecipeRemainders(EffigyAltarRecipeInput input) {
        class_2371 defaultedList = class_2371.method_10213((int)input.method_59983(), (Object)class_1799.field_8037);
        for (int i = 0; i < defaultedList.size(); ++i) {
            class_1792 item = input.method_59984(i).method_7909();
            defaultedList.set(i, (Object)item.method_7858());
        }
        return defaultedList;
    }

    @VisibleForTesting
    public List<Optional<class_1856>> getIngredients() {
        return this.raw.getIngredients();
    }

    public class_9887 method_61671() {
        if (this.ingredientPlacement == null) {
            this.ingredientPlacement = class_9887.method_61683(this.getIngredients());
        }
        return this.ingredientPlacement;
    }

    public boolean matches(EffigyAltarRecipeInput input, class_1937 world) {
        return this.raw.matches(input);
    }

    public class_1799 craft(EffigyAltarRecipeInput input, class_7225.class_7874 wrapperLookup) {
        return this.result.method_7972();
    }

    public class_1799 result() {
        return this.result;
    }

    public OptionalInt getCost() {
        return this.cost;
    }

    public int getCostOrDefault() {
        return this.getCost().orElse(5);
    }

    public Optional<Integer> getBoxedCost() {
        return this.cost.stream().boxed().findFirst();
    }

    public List<class_10295> method_64664() {
        return List.of(new EffigyAltarRecipeDisplay(this.raw.getIngredients().stream().map(ingredient -> ingredient.map(class_1856::method_64673).orElse((class_10302)class_10302.class_10305.field_54681)).toList(), EffigyAltarRecipeDisplay.BrimstoneSlotDisplay.INSTANCE, new class_10302.class_10307(this.result), this.getCostOrDefault(), new class_10302.class_10306(PeacefulModBlocks.EFFIGY_ALTAR.method_8389())));
    }

    public static class_1856 getBrimstone() {
        return class_1856.method_8101((class_1935)PeacefulModItems.SULPHUR);
    }

    public static Optional<class_1856> getBrimstoneOptional() {
        return Optional.of(EffigyAltarRecipe.getBrimstone());
    }

    public static final class RawRecipe {
        private static final int MAX_WIDTH_AND_HEIGHT = 3;
        private static final int MAX_WIDTH_END = 1;
        public static final char SPACE = ' ';
        public static final MapCodec<RawRecipe> CODEC = Data.CODEC.flatXmap(RawRecipe::fromData, recipe -> recipe.data.map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Cannot encode unpacked recipe")));
        public static final class_9139<class_9129, RawRecipe> PACKET_CODEC = class_9139.method_56434((class_9139)class_1856.field_52595.method_56433(class_9135.method_56363()), recipe -> recipe.ingredients, RawRecipe::create);
        private final List<Optional<class_1856>> ingredients;
        private final Optional<Data> data;
        private final int ingredientCount;
        private final Optional<class_1856> brimstone;

        public RawRecipe(List<Optional<class_1856>> ingredients, Optional<Data> data) {
            this.ingredients = ingredients;
            this.brimstone = EffigyAltarRecipe.getBrimstoneOptional();
            ingredients.add(this.brimstone);
            this.data = data;
            this.ingredientCount = (int)ingredients.stream().flatMap(Optional::stream).count();
        }

        private static RawRecipe create(List<Optional<class_1856>> ingredients) {
            return new RawRecipe(ingredients, Optional.empty());
        }

        public static RawRecipe create(Map<Character, class_1856> key, String ... pattern) {
            return RawRecipe.create(key, List.of(pattern));
        }

        public static RawRecipe create(Map<Character, class_1856> key, List<String> pattern) {
            Data data = new Data(key, pattern);
            return (RawRecipe)RawRecipe.fromData(data).getOrThrow();
        }

        private static DataResult<RawRecipe> fromData(Data data) {
            String[] strings = RawRecipe.removePadding(data.pattern);
            int i = strings[0].length();
            int j = strings.length;
            ArrayList<Optional<class_1856>> list = new ArrayList<Optional<class_1856>>(i * j);
            CharArraySet charSet = new CharArraySet(data.key.keySet());
            for (String string : strings) {
                for (int k = 0; k < string.length(); ++k) {
                    Optional<Object> optional;
                    char c = string.charAt(k);
                    if (c == ' ') {
                        optional = Optional.empty();
                    } else {
                        class_1856 ingredient = data.key.get(Character.valueOf(c));
                        if (ingredient == null) {
                            return DataResult.error(() -> "Pattern references symbol '" + c + "' but it's not defined in the key");
                        }
                        optional = Optional.of(ingredient);
                    }
                    charSet.remove(c);
                    list.add(optional);
                }
            }
            return !charSet.isEmpty() ? DataResult.error(() -> RawRecipe.lambda$fromData$5((CharSet)charSet)) : DataResult.success((Object)new RawRecipe(list, Optional.of(data)));
        }

        @VisibleForTesting
        static String[] removePadding(List<String> pattern) {
            int end;
            int start;
            List<String> trimmedLines = pattern.stream().map(String::trim).toList();
            for (start = 0; start < trimmedLines.size() && trimmedLines.get(start).isEmpty(); ++start) {
            }
            for (end = trimmedLines.size(); end > start && trimmedLines.get(end - 1).isEmpty(); --end) {
            }
            return trimmedLines.subList(start, end).toArray(new String[0]);
        }

        public boolean matches(EffigyAltarRecipeInput input) {
            if (input.getStackCount() != this.ingredientCount) {
                return false;
            }
            for (int i = 0; i < 3; ++i) {
                int fi = i + 1;
                if (fi == 3) {
                    class_1799 itemStack;
                    Optional<class_1856> optional = this.ingredients.get(i * 3);
                    if (!class_1856.method_61676(optional, (class_1799)(itemStack = input.getStackInSlot(0, i)))) {
                        return false;
                    }
                    if (class_1856.method_61676(this.brimstone, (class_1799)input.getStackInSlot(1, i))) continue;
                    return false;
                }
                for (int j = 0; j < 3; ++j) {
                    class_1799 itemStack;
                    Optional<class_1856> optional = this.ingredients.get(j + i * 3);
                    if (class_1856.method_61676(optional, (class_1799)(itemStack = input.getStackInSlot(j, i)))) continue;
                    return false;
                }
            }
            return true;
        }

        public List<Optional<class_1856>> getIngredients() {
            return this.ingredients;
        }

        private static /* synthetic */ String lambda$fromData$5(CharSet charSet) {
            return "Key defines symbols that aren't used in pattern: " + String.valueOf(charSet);
        }

        public record Data(Map<Character, class_1856> key, List<String> pattern) {
            private static final Codec<List<String>> PATTERN_CODEC = Codec.STRING.listOf().comapFlatMap(pattern -> {
                if (pattern.size() > 3) {
                    return DataResult.error(() -> "Invalid pattern: too many rows, 3 is maximum");
                }
                if (pattern.isEmpty()) {
                    return DataResult.error(() -> "Invalid pattern: empty pattern not allowed");
                }
                for (int i = 0; i < pattern.size(); ++i) {
                    int fi = i + 1;
                    String string = (String)pattern.get(i);
                    int length = string.length();
                    if (fi == 3) {
                        if (length > 1) {
                            return DataResult.error(() -> "Invalid pattern: too many columns for row #" + fi + ", 1 is maximum and minimum");
                        }
                        if (length >= 1) continue;
                        return DataResult.error(() -> "Invalid pattern: too little columns for row #" + fi + ", 1 is maximum and minimum");
                    }
                    if (length > 3) {
                        return DataResult.error(() -> "Invalid pattern: too many columns for row #" + fi + ", 3 is maximum and minimum");
                    }
                    if (length >= 3) continue;
                    return DataResult.error(() -> "Invalid pattern: too little columns for row #" + fi + ", 3 is maximum and minimum");
                }
                return DataResult.success((Object)pattern);
            }, Function.identity());
            private static final Codec<Character> KEY_ENTRY_CODEC = Codec.STRING.comapFlatMap(keyEntry -> {
                if (keyEntry.length() != 1) {
                    return DataResult.error(() -> "Invalid key entry: '" + keyEntry + "' is an invalid symbol (must be 1 character only).");
                }
                return " ".equals(keyEntry) ? DataResult.error(() -> "Invalid key entry: ' ' is a reserved symbol.") : DataResult.success((Object)Character.valueOf(keyEntry.charAt(0)));
            }, String::valueOf);
            public static final MapCodec<Data> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_5699.method_53703(KEY_ENTRY_CODEC, (Codec)class_1856.field_46095).fieldOf("key").forGetter(data -> data.key), (App)PATTERN_CODEC.fieldOf("pattern").forGetter(data -> data.pattern)).apply((Applicative)instance, Data::new));
        }
    }

    public static class Serializer
    implements class_1865<EffigyAltarRecipe> {
        public static final MapCodec<EffigyAltarRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)RawRecipe.CODEC.forGetter(recipe -> recipe.raw), (App)class_1799.field_51397.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.INT.optionalFieldOf("cost").forGetter(EffigyAltarRecipe::getBoxedCost)).apply((Applicative)instance, EffigyAltarRecipe::new));
        public static final class_9139<class_9129, EffigyAltarRecipe> PACKET_CODEC = class_9139.method_56437(Serializer::write, Serializer::read);

        public MapCodec<EffigyAltarRecipe> method_53736() {
            return CODEC;
        }

        @Deprecated
        public class_9139<class_9129, EffigyAltarRecipe> method_56104() {
            return PACKET_CODEC;
        }

        private static EffigyAltarRecipe read(class_9129 buf) {
            String string = buf.method_19772();
            RawRecipe rawRecipe = (RawRecipe)RawRecipe.PACKET_CODEC.decode((Object)buf);
            class_1799 result = (class_1799)class_1799.field_48349.decode((Object)buf);
            OptionalInt cost = (OptionalInt)class_9135.field_54890.decode((Object)buf);
            return new EffigyAltarRecipe(string, rawRecipe, result, cost);
        }

        private static void write(class_9129 buf, EffigyAltarRecipe recipe) {
            buf.method_10814(recipe.group);
            RawRecipe.PACKET_CODEC.encode((Object)buf, (Object)recipe.raw);
            class_1799.field_48349.encode((Object)buf, (Object)recipe.result);
            class_9135.field_54890.encode((Object)buf, (Object)recipe.cost);
        }
    }
}

