/*
 * Decompiled with CFR 0.152.
 */
package xen42.peacefulitems.rei;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.display.SimpleGridMenuDisplay;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.InputIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_10295;
import net.minecraft.class_10302;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_8786;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;
import xen42.peacefulitems.recipe.EffigyAltarRecipe;
import xen42.peacefulitems.recipe.EffigyAltarRecipeDisplay;
import xen42.peacefulitems.rei.EffigyAltarServerPlugin;

public class EffigyAltarREIDisplay
extends BasicDisplay
implements SimpleGridMenuDisplay {
    public static final DisplaySerializer<EffigyAltarREIDisplay> SERIALIZER = DisplaySerializer.of((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)EntryIngredient.codec().listOf().fieldOf("inputs").forGetter(EffigyAltarREIDisplay::getInputEntries), (App)EntryIngredient.codec().listOf().fieldOf("outputs").forGetter(EffigyAltarREIDisplay::getOutputEntries), (App)Codec.INT.fieldOf("cost").forGetter(EffigyAltarREIDisplay::getCost)).apply((Applicative)instance, EffigyAltarREIDisplay::new)), (class_9139)class_9139.method_56436((class_9139)EntryIngredient.streamCodec().method_56433(class_9135.method_56363()), EffigyAltarREIDisplay::getInputEntries, (class_9139)EntryIngredient.streamCodec().method_56433(class_9135.method_56363()), EffigyAltarREIDisplay::getOutputEntries, (class_9139)class_9135.field_49675, EffigyAltarREIDisplay::getCost, EffigyAltarREIDisplay::new), (boolean)false);
    private final int cost;

    public EffigyAltarREIDisplay(EffigyAltarRecipeDisplay recipe) {
        this(EntryIngredients.ofSlotDisplays(recipe.ingredients()), List.of(EntryIngredients.ofSlotDisplay((class_10302)recipe.result())), recipe.cost());
    }

    static List<EntryIngredient> ingredientsFromRecipe(EffigyAltarRecipe recipe) {
        ArrayList<EntryIngredient> ingredients = new ArrayList<EntryIngredient>();
        for (Optional<class_1856> optionalIngredient : recipe.getIngredients()) {
            if (!optionalIngredient.isPresent()) continue;
            ingredients.add(EntryIngredients.ofIngredient((class_1856)optionalIngredient.get()));
        }
        return ingredients;
    }

    public EffigyAltarREIDisplay(class_8786<EffigyAltarRecipe> recipe) {
        this((EffigyAltarRecipe)recipe.comp_1933());
    }

    public EffigyAltarREIDisplay(EffigyAltarRecipe recipe) {
        this(EffigyAltarREIDisplay.ingredientsFromRecipe(recipe), List.of(EntryIngredients.of((class_1799)recipe.result())), recipe.getCostOrDefault());
    }

    public EffigyAltarREIDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, int cost) {
        super(inputs, outputs);
        this.cost = cost;
    }

    public List<EntryIngredient> getInputEntries() {
        return this.inputs;
    }

    public List<EntryIngredient> getOutputEntries() {
        return this.outputs;
    }

    public int getCost() {
        return this.cost;
    }

    public DisplaySerializer<? extends Display> getSerializer() {
        return SERIALIZER;
    }

    public int getWidth() {
        return 3;
    }

    public int getHeight() {
        return 3;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return EffigyAltarServerPlugin.EFFIGY_ALTAR_CATEGORY;
    }

    static int getSlotWithSize(int recipeWidth, int index, int craftingGridWidth) {
        int x = index % recipeWidth;
        int y = (index - x) / recipeWidth;
        return craftingGridWidth * y + x;
    }

    public int getSlotWithSize(int index, int craftingGridWidth) {
        return EffigyAltarREIDisplay.getSlotWithSize(this.getInputWidth(craftingGridWidth, 3), index, craftingGridWidth);
    }

    public List<EntryIngredient> getOrganisedInputEntries(int menuWidth, int menuHeight) {
        int i;
        ArrayList<EntryIngredient> list = new ArrayList<EntryIngredient>(menuWidth * menuHeight);
        for (i = 0; i < menuWidth * menuHeight; ++i) {
            list.add(EntryIngredient.empty());
        }
        for (i = 0; i < this.getInputEntries().size(); ++i) {
            list.set(this.getSlotWithSize(i, menuWidth), this.getInputEntries().get(i));
        }
        return list;
    }

    public List<InputIngredient<EntryStack<?>>> getInputIngredients(@Nullable class_1703 menu, @Nullable class_1657 player) {
        return this.getInputIngredients(3, 3);
    }

    public List<InputIngredient<EntryStack<?>>> getInputIngredients(int craftingWidth, int craftingHeight) {
        int inputWidth = this.getInputWidth(craftingWidth, craftingHeight);
        int inputHeight = this.getInputHeight(craftingWidth, craftingHeight);
        HashMap<IntIntImmutablePair, InputIngredient> grid = new HashMap<IntIntImmutablePair, InputIngredient>();
        List<EntryIngredient> inputEntries = this.getInputEntries();
        for (int i = 0; i < inputEntries.size(); ++i) {
            EntryIngredient stacks = inputEntries.get(i);
            if (stacks.isEmpty()) continue;
            int index = EffigyAltarREIDisplay.getSlotWithSize(inputWidth, i, craftingWidth);
            int x = i % inputWidth;
            int y = i / inputHeight;
            grid.put(new IntIntImmutablePair(x, y), InputIngredient.of((int)index, (int)(3 * y + x), (List)stacks));
        }
        ArrayList list = new ArrayList(craftingHeight * craftingWidth - 1);
        int n = craftingWidth * craftingHeight - 1;
        for (int i = 0; i < n; ++i) {
            list.add(InputIngredient.empty((int)i));
        }
        for (int y = 0; y < craftingHeight; ++y) {
            for (int x = 0; x < (y == 2 ? craftingWidth - 1 : craftingWidth); ++x) {
                InputIngredient ingredient = (InputIngredient)grid.get(new IntIntImmutablePair(x, y));
                if (ingredient == null) continue;
                int index = craftingWidth * y + x;
                list.set(index, ingredient);
            }
        }
        return list;
    }

    @Nullable
    public static EffigyAltarREIDisplay of(class_8786<? extends EffigyAltarRecipe> holder) {
        EffigyAltarRecipe recipe = (EffigyAltarRecipe)holder.comp_1933();
        if (recipe instanceof EffigyAltarRecipe) {
            return new EffigyAltarREIDisplay(recipe);
        }
        if (!recipe.method_8118()) {
            for (class_10295 d : recipe.method_64664()) {
                if (!(d instanceof EffigyAltarRecipeDisplay)) continue;
                EffigyAltarRecipeDisplay display = (EffigyAltarRecipeDisplay)d;
                return new EffigyAltarREIDisplay(display);
            }
        }
        return null;
    }
}

