/*
 * Decompiled with CFR 0.152.
 */
package xen42.peacefulitems.screen;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1729;
import net.minecraft.class_1731;
import net.minecraft.class_1732;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_2596;
import net.minecraft.class_2653;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_5421;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_8566;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import net.minecraft.class_9875;
import org.jetbrains.annotations.Nullable;
import xen42.peacefulitems.PeacefulMod;
import xen42.peacefulitems.PeacefulModBlocks;
import xen42.peacefulitems.PeacefulModItems;
import xen42.peacefulitems.recipe.EffigyAltarRecipe;
import xen42.peacefulitems.recipe.EffigyAltarRecipeInput;

public class EffigyAltarScreenHandler
extends class_1729 {
    public static final int OUTPUT_SLOT = 0;
    public static final int INPUT_SLOTS_START = 1;
    public static final int INPUT_SLOTS_END = 7;
    public static final int BRIMSTONE_SLOT = 8;
    public static final int MAX_WIDTH_AND_HEIGHT = 3;
    public static final int MAX_WIDTH_END = 1;
    public static final int INVENTORY_SLOTS_START = 9;
    public static final int INVENTORY_SLOTS_END = 35;
    public static final int HOTBAR_SLOTS_START = 36;
    public static final int HOTBAR_SLOTS_END = 45;
    public final class_8566 inventory;
    private final class_1731 resultInventory;
    private final class_3915 levelCost = class_3915.method_17403();
    public class_3914 context;
    private final class_1657 player;
    private class_1735[] _slots;
    private class_1735 _outputSlot;
    private class_1735 _brimstoneSlot;
    private boolean filling;

    public boolean canTake(int xpCost) {
        return (this.player.method_56992() || this.player.field_7520 >= xpCost) && xpCost > 0;
    }

    public boolean canTake() {
        return this.canTake(this.getOutputXPCost());
    }

    public boolean hasOutput() {
        return this._outputSlot.method_7681();
    }

    public static int getXPCost(class_3218 serverWorld, List<class_1799> input) {
        EffigyAltarRecipeInput recipeInput = EffigyAltarRecipeInput.create(input);
        Optional optional = serverWorld.method_64577().method_8132(PeacefulMod.EFFIGY_ALTAR_RECIPE_TYPE, (class_9695)recipeInput, (class_1937)serverWorld);
        if (optional.isPresent()) {
            class_8786 recipeEntry = (class_8786)optional.get();
            EffigyAltarRecipe altarRecipe = (EffigyAltarRecipe)recipeEntry.comp_1933();
            return altarRecipe.getCostOrDefault();
        }
        return 0;
    }

    public int getOutputXPCost() {
        return this.levelCost.method_17407();
    }

    public EffigyAltarScreenHandler(int syncId, class_1661 playerInventory) {
        this(syncId, playerInventory, class_3914.field_17304);
    }

    public EffigyAltarScreenHandler(int syncId, class_1661 playerInventory, class_3914 context) {
        super(PeacefulMod.EFFIGY_ALTAR_SCREEN_HANDLER, syncId);
        this.inventory = new EffigySimpleInventory(this, this, 8);
        this.resultInventory = new EffigyCraftingResultInventory(this, this);
        this.method_17362(this.levelCost);
        this.context = context;
        this.player = playerInventory.field_7546;
        this._outputSlot = this.method_7621(new OutputSlot(this, this.player, this.inventory, (class_1263)this.resultInventory, 0, 132, 21));
        this._slots = new class_1735[]{this.method_7621(new CustomSlot(this, this, (class_1263)this.inventory, 0, 22, 17)), this.method_7621(new CustomSlot(this, this, (class_1263)this.inventory, 1, 40, 17)), this.method_7621(new CustomSlot(this, this, (class_1263)this.inventory, 2, 58, 17)), this.method_7621(new CustomSlot(this, this, (class_1263)this.inventory, 3, 22, 35)), this.method_7621(new CustomSlot(this, this, (class_1263)this.inventory, 4, 40, 35)), this.method_7621(new CustomSlot(this, this, (class_1263)this.inventory, 5, 58, 35)), this.method_7621(new CustomSlot(this, this, (class_1263)this.inventory, 6, 40, 53))};
        this._brimstoneSlot = this.method_7621(new BrimstoneSlot(this, this, (class_1263)this.inventory, 7, 89, 45));
        this.method_61624((class_1263)playerInventory, 8, 84);
    }

    public static boolean isBrimstone(class_1799 stack) {
        return stack.method_31574(PeacefulModItems.SULPHUR);
    }

    public static boolean isAir(class_1799 stack) {
        return stack.method_31574(class_1802.field_8162);
    }

    public void updateResult(class_3218 world, @Nullable class_8786<EffigyAltarRecipe> recipe) {
        Optional optional;
        EffigyAltarRecipeInput recipeInput = EffigyAltarRecipeInput.create(this.inventory.method_51305());
        class_3222 serverPlayerEntity = (class_3222)this.player;
        class_1799 resultStack = class_1799.field_8037;
        int cost = 0;
        if (EffigyAltarScreenHandler.isBrimstone(this._brimstoneSlot.method_7677()) && (optional = world.method_8503().method_3772().method_59993(PeacefulMod.EFFIGY_ALTAR_RECIPE_TYPE, (class_9695)recipeInput, (class_1937)world, recipe)).isPresent()) {
            class_1799 craftedStack;
            boolean isItemEnabled;
            class_8786 recipeEntry = (class_8786)optional.get();
            EffigyAltarRecipe altarRecipe = (EffigyAltarRecipe)recipeEntry.comp_1933();
            boolean shouldCraftRecipe = this.resultInventory.method_7665(serverPlayerEntity, recipeEntry);
            if (shouldCraftRecipe && (isItemEnabled = (craftedStack = altarRecipe.craft(recipeInput, (class_7225.class_7874)world.method_30349())).method_45435(world.method_45162()))) {
                resultStack = craftedStack;
                cost = altarRecipe.getCostOrDefault();
            }
        }
        this.levelCost.method_17404(cost);
        this.resultInventory.method_5447(0, resultStack);
        this.method_34245(0, resultStack);
        serverPlayerEntity.field_13987.method_14364((class_2596)new class_2653(this.field_7763, this.method_37422(), 0, resultStack));
    }

    public void method_7609(class_1263 inventory) {
        if (!this.filling) {
            this.context.method_17393((world, pos) -> {
                if (world instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)world;
                    this.updateResult(serverWorld, null);
                }
            });
        }
    }

    public class_1799 method_7601(class_1657 player, int slot) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 slotAtIndex = (class_1735)this.field_7761.get(slot);
        if (slotAtIndex != null && slotAtIndex.method_7681() && slotAtIndex.method_7674(player)) {
            class_1799 itemStackAtIndex = slotAtIndex.method_7677();
            itemStack = itemStackAtIndex.method_7972();
            if (slot == 0) {
                itemStackAtIndex.method_7909().method_54465(itemStackAtIndex, player);
                if (!this.method_7616(itemStackAtIndex, 9, 45, true)) {
                    return class_1799.field_8037;
                }
                slotAtIndex.method_7670(itemStackAtIndex, itemStack);
            } else if (slot >= 9 && slot < 45 ? !this.method_7616(itemStackAtIndex, 1, 9, false) && (slot < 36 ? !this.method_7616(itemStackAtIndex, 36, 45, false) : !this.method_7616(itemStackAtIndex, 9, 36, false)) : !this.method_7616(itemStackAtIndex, 9, 45, false)) {
                return class_1799.field_8037;
            }
            if (itemStackAtIndex.method_7960()) {
                slotAtIndex.method_53512(class_1799.field_8037);
            } else {
                slotAtIndex.method_7668();
            }
            if (itemStackAtIndex.method_7947() == itemStack.method_7947()) {
                return class_1799.field_8037;
            }
            slotAtIndex.method_7667(player, itemStackAtIndex);
            if (slot == 0) {
                player.method_7328(itemStackAtIndex, false);
            }
        }
        return itemStack;
    }

    public boolean method_7597(class_1657 player) {
        return EffigyAltarScreenHandler.method_17695((class_3914)this.context, (class_1657)player, (class_2248)PeacefulModBlocks.EFFIGY_ALTAR);
    }

    public boolean method_7613(class_1799 stack, class_1735 slot) {
        return slot.field_7871 != this.resultInventory && super.method_7613(stack, slot);
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.context.method_17393((world, pos) -> this.method_7607(player, (class_1263)this.inventory));
    }

    public class_1729.class_9885 method_17697(boolean craftAll, boolean creative, class_8786<?> recipe, class_3218 world, class_1661 inventory) {
        class_8786<?> recipeEntry = recipe;
        this.onInputSlotFillStart();
        class_1735 brimstoneSlot = this.getBrimstoneSlot();
        List<class_1735> inputSlots = this.getInputSlots();
        class_1729.class_9885 postFillAction = new EffigyAltarInputSlotFiller(brimstoneSlot, inputSlots, inventory, recipeEntry, craftAll, creative).fill();
        this.onInputSlotFillFinish(world, recipeEntry);
        return postFillAction;
    }

    public void method_7654(class_9875 finder) {
        this.inventory.method_7683(finder);
    }

    public class_5421 method_30264() {
        return class_5421.field_25763;
    }

    public void onInputSlotFillStart() {
        this.filling = true;
    }

    public void onInputSlotFillFinish(class_3218 world, class_8786<EffigyAltarRecipe> recipe) {
        this.filling = false;
        this.updateResult(world, recipe);
    }

    public class_1735 getBrimstoneSlot() {
        return this._brimstoneSlot;
    }

    public class_1735 getOutputSlot() {
        return this._outputSlot;
    }

    public List<class_1735> getInputSlots() {
        return this.field_7761.subList(1, 8);
    }

    public class_1657 getPlayer() {
        return this.player;
    }

    private class EffigySimpleInventory
    extends class_1277
    implements class_8566 {
        private class_1703 _screen;

        EffigySimpleInventory(EffigyAltarScreenHandler effigyAltarScreenHandler, EffigyAltarScreenHandler screen, int size) {
            super(size);
            this._screen = screen;
        }

        public void method_5431() {
            this._screen.method_7609((class_1263)this);
            super.method_5431();
        }

        public int method_17398() {
            return 3;
        }

        public int method_17397() {
            return 3;
        }
    }

    private class EffigyCraftingResultInventory
    extends class_1731 {
        private class_1703 _screen;

        EffigyCraftingResultInventory(EffigyAltarScreenHandler effigyAltarScreenHandler, EffigyAltarScreenHandler screen) {
            this._screen = screen;
        }

        public void method_5431() {
            this._screen.method_7609((class_1263)this);
            super.method_5431();
        }
    }

    private class OutputSlot
    extends class_1735 {
        private final class_8566 input;
        private final class_1657 player;
        private final EffigyAltarScreenHandler handler;
        private int amount;

        public OutputSlot(EffigyAltarScreenHandler handler, class_1657 player, class_8566 input, class_1263 inventory, int index, int x, int y) {
            super(inventory, index, x, y);
            this.player = player;
            this.input = input;
            this.handler = handler;
        }

        public boolean method_7680(class_1799 stack) {
            return false;
        }

        public boolean method_7674(class_1657 player) {
            return this.handler.canTake();
        }

        public class_1799 method_7671(int amount) {
            if (this.method_7681()) {
                this.amount += Math.min(amount, this.method_7677().method_7947());
            }
            return super.method_7671(amount);
        }

        protected void method_7678(class_1799 stack, int amount) {
            this.amount += amount;
            this.method_7669(stack);
        }

        protected void method_7672(int amount) {
            this.amount += amount;
        }

        protected void method_7669(class_1799 stack) {
            class_1263 class_12632;
            if (this.amount > 0) {
                stack.method_7982(this.player, this.amount);
            }
            if ((class_12632 = this.field_7871) instanceof class_1732) {
                class_1732 recipeUnlocker = (class_1732)class_12632;
                recipeUnlocker.method_7664(this.player, this.input.method_51305());
            }
            this.amount = 0;
        }

        private static class_2371<class_1799> copyInput(EffigyAltarRecipeInput input) {
            class_2371 defaultedList = class_2371.method_10213((int)input.method_59983(), (Object)class_1799.field_8037);
            for (int i = 0; i < defaultedList.size(); ++i) {
                defaultedList.set(i, (Object)input.method_59984(i));
            }
            return defaultedList;
        }

        private class_2371<class_1799> getRecipeRemainders(EffigyAltarRecipeInput input, class_1937 world) {
            class_2371 class_23712;
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                class_23712 = serverWorld.method_64577().method_8132(PeacefulMod.EFFIGY_ALTAR_RECIPE_TYPE, (class_9695)input, (class_1937)serverWorld).map(recipe -> ((EffigyAltarRecipe)recipe.comp_1933()).getRecipeRemainders(input)).orElseGet(() -> OutputSlot.copyInput(input));
            } else {
                class_23712 = EffigyAltarRecipe.collectRecipeRemainders(input);
            }
            return class_23712;
        }

        public void method_7667(class_1657 player, class_1799 stack) {
            this.method_7669(stack);
            EffigyAltarRecipeInput recipeInput = EffigyAltarRecipeInput.create(this.input.method_51305());
            class_2371<class_1799> defaultedList = this.getRecipeRemainders(recipeInput, player.method_37908());
            this.handler.context.method_17393((world, pos) -> {
                if (!player.method_56992()) {
                    player.method_7316(-EffigyAltarScreenHandler.this.getOutputXPCost());
                }
                world.method_8396((class_1297)null, pos, class_3417.field_15119, class_3419.field_15245, 1.0f, world.field_9229.method_43057() * 0.1f + 0.9f);
            });
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < (y == 2 ? 2 : 3); ++x) {
                    int z = x + y * 3;
                    class_1799 itemStack = this.input.method_5438(z);
                    class_1799 defaultStack = (class_1799)defaultedList.get(z);
                    if (!itemStack.method_7960()) {
                        this.input.method_5434(z, 1);
                        itemStack = this.input.method_5438(z);
                    }
                    if (defaultStack.method_7960()) continue;
                    if (itemStack.method_7960()) {
                        this.input.method_5447(z, defaultStack);
                        continue;
                    }
                    if (class_1799.method_31577((class_1799)itemStack, (class_1799)defaultStack)) {
                        defaultStack.method_7933(itemStack.method_7947());
                        this.input.method_5447(z, defaultStack);
                        continue;
                    }
                    if (this.player.method_31548().method_7394(defaultStack)) continue;
                    this.player.method_7328(defaultStack, false);
                }
            }
        }

        public boolean method_55059() {
            return true;
        }
    }

    private class CustomSlot
    extends class_1735 {
        private EffigyAltarScreenHandler _altar;

        public CustomSlot(EffigyAltarScreenHandler effigyAltarScreenHandler, EffigyAltarScreenHandler altar, class_1263 inventory, int index, int x, int y) {
            super(inventory, index, x, y);
            this._altar = altar;
        }

        public void method_7668() {
            super.method_7668();
            this._altar.method_7609((class_1263)this._altar.inventory);
        }

        public boolean method_7680(class_1799 stack) {
            return !EffigyAltarScreenHandler.isBrimstone(stack);
        }
    }

    private class BrimstoneSlot
    extends CustomSlot {
        public BrimstoneSlot(EffigyAltarScreenHandler effigyAltarScreenHandler, EffigyAltarScreenHandler altar, class_1263 inventory, int index, int x, int y) {
            super(effigyAltarScreenHandler, altar, inventory, index, x, y);
        }

        @Override
        public boolean method_7680(class_1799 stack) {
            return EffigyAltarScreenHandler.isAir(stack) || EffigyAltarScreenHandler.isBrimstone(stack);
        }
    }

    private class EffigyAltarInputSlotFiller {
        private final class_1735 brimstoneSlot;
        private final List<class_1735> inputSlots;
        private final List<class_1735> slotsToReturn;
        private final class_1661 inventory;
        private final class_8786<EffigyAltarRecipe> recipe;
        private final boolean craftAll;
        private final boolean creative;

        public EffigyAltarInputSlotFiller(class_1735 brimstoneSlot, List<class_1735> inputSlots, class_1661 inventory, class_8786<EffigyAltarRecipe> recipe, boolean craftAll, boolean creative) {
            this(brimstoneSlot, inputSlots, inputSlots, inventory, recipe, craftAll, creative);
        }

        public EffigyAltarInputSlotFiller(class_1735 brimstoneSlot, List<class_1735> inputSlots, List<class_1735> slotsToReturn, class_1661 inventory, class_8786<EffigyAltarRecipe> recipe, boolean craftAll, boolean creative) {
            this.brimstoneSlot = brimstoneSlot;
            this.inputSlots = inputSlots;
            this.slotsToReturn = slotsToReturn;
            this.inventory = inventory;
            this.recipe = recipe;
            this.craftAll = craftAll;
            this.creative = creative;
        }

        public class_1729.class_9885 fill() {
            if (!this.creative && !this.canReturnInputs()) {
                return class_1729.class_9885.field_52572;
            }
            class_9875 recipeFinder = new class_9875();
            this.inventory.method_7387(recipeFinder);
            EffigyAltarScreenHandler.this.method_7654(recipeFinder);
            return this.tryFill(this.recipe, recipeFinder);
        }

        public void clear() {
            EffigyAltarScreenHandler.this.resultInventory.method_5448();
            EffigyAltarScreenHandler.this.inventory.method_5448();
        }

        public boolean matches(class_8786<EffigyAltarRecipe> entry) {
            return ((EffigyAltarRecipe)entry.comp_1933()).matches(EffigyAltarRecipeInput.create(EffigyAltarScreenHandler.this.inventory.method_51305()), EffigyAltarScreenHandler.this.getPlayer().method_37908());
        }

        private class_1729.class_9885 tryFill(class_8786<EffigyAltarRecipe> recipe, class_9875 finder) {
            if (finder.method_61538(recipe.comp_1933(), null)) {
                this.fill(recipe, finder);
                this.inventory.method_5431();
                return class_1729.class_9885.field_52572;
            }
            this.returnInputs();
            this.inventory.method_5431();
            return class_1729.class_9885.field_52573;
        }

        private void returnInputs() {
            for (class_1735 slot : this.slotsToReturn) {
                class_1799 itemStack = slot.method_7677().method_7972();
                this.inventory.method_32338(itemStack, false);
                slot.method_7673(itemStack);
            }
            class_1799 brimstoneStack = this.brimstoneSlot.method_7677().method_7972();
            this.inventory.method_32338(brimstoneStack, false);
            this.brimstoneSlot.method_7673(brimstoneStack);
            this.clear();
        }

        private void fill(class_8786<EffigyAltarRecipe> recipe, class_9875 finder) {
            boolean match = this.matches(recipe);
            int i = finder.method_61543(recipe.comp_1933(), null);
            if (match) {
                class_1799 brimstoneItemStack = this.brimstoneSlot.method_7677();
                if (!brimstoneItemStack.method_7960() && Math.min(i, brimstoneItemStack.method_7914()) < brimstoneItemStack.method_7947() + 1) {
                    return;
                }
                for (class_1735 slot : this.inputSlots) {
                    class_1799 itemStack = slot.method_7677();
                    if (itemStack.method_7960() || Math.min(i, itemStack.method_7914()) >= itemStack.method_7947() + 1) continue;
                    return;
                }
            }
            int j = this.calculateCraftAmount(i, match);
            ArrayList<class_6880<class_1792>> entries = new ArrayList<class_6880<class_1792>>();
            boolean isCraftable = finder.method_61537(recipe.comp_1933(), j, entries::add);
            if (isCraftable) {
                int k = EffigyAltarInputSlotFiller.clampToMaxCount(j, entries);
                if (k != j) {
                    entries.clear();
                    if (!finder.method_61537(recipe.comp_1933(), k, entries::add)) {
                        return;
                    }
                }
                this.returnInputs();
                EffigyAltarRecipe recipeValue = (EffigyAltarRecipe)recipe.comp_1933();
                IntList placementSlots = recipeValue.method_61671().method_65800();
                class_6880 brimstoneRegistryEntry = (class_6880)entries.get(placementSlots.getInt(this.inputSlots.size()));
                int jk = k;
                while (jk > 0) {
                    if ((jk = this.fillInputSlot(this.brimstoneSlot, (class_6880<class_1792>)brimstoneRegistryEntry, jk)) != -1) continue;
                    return;
                }
                for (int index = 0; index < this.inputSlots.size(); ++index) {
                    class_1735 slot = this.inputSlots.get(index);
                    int placementSlot = placementSlots.getInt(index);
                    class_6880 registryEntry = (class_6880)entries.get(placementSlot);
                    int jx = k;
                    while (jx > 0) {
                        if ((jx = this.fillInputSlot(slot, (class_6880<class_1792>)registryEntry, jx)) != -1) continue;
                        return;
                    }
                }
            }
        }

        private static int clampToMaxCount(int count, List<class_6880<class_1792>> entries) {
            for (class_6880<class_1792> registryEntry : entries) {
                count = Math.min(count, ((class_1792)registryEntry.comp_349()).method_7882());
            }
            return count;
        }

        private int calculateCraftAmount(int forCraftAll, boolean match) {
            if (this.craftAll) {
                return forCraftAll;
            }
            if (match) {
                int i = Integer.MAX_VALUE;
                for (class_1735 slot : this.inputSlots) {
                    class_1799 itemStack = slot.method_7677();
                    if (itemStack.method_7960() || i <= itemStack.method_7947()) continue;
                    i = itemStack.method_7947();
                }
                if (i != Integer.MAX_VALUE) {
                    ++i;
                }
                return i;
            }
            return 1;
        }

        private int fillInputSlot(class_1735 slot, class_6880<class_1792> item, int count) {
            class_1799 itemStack = slot.method_7677();
            int i = this.inventory.method_61494(item, itemStack);
            if (i == -1) {
                return -1;
            }
            class_1799 itemStackAtIndex = this.inventory.method_5438(i);
            class_1799 itemStack3 = count < itemStackAtIndex.method_7947() ? this.inventory.method_5434(i, count) : this.inventory.method_5441(i);
            int j = itemStack3.method_7947();
            if (itemStack.method_7960()) {
                slot.method_7673(itemStack3);
            } else {
                itemStack.method_7933(j);
            }
            return count - j;
        }

        private boolean canReturnInputs() {
            ArrayList list = Lists.newArrayList();
            int i = this.getFreeInventorySlots();
            for (class_1735 slot : this.inputSlots) {
                class_1799 itemStack = slot.method_7677().method_7972();
                if (itemStack.method_7960()) continue;
                int j = this.inventory.method_7390(itemStack);
                if (j == -1 && list.size() <= i) {
                    for (class_1799 itemStack2 : list) {
                        if (!class_1799.method_7984((class_1799)itemStack2, (class_1799)itemStack) || itemStack2.method_7947() == itemStack2.method_7914() || itemStack2.method_7947() + itemStack.method_7947() > itemStack2.method_7914()) continue;
                        itemStack2.method_7933(itemStack.method_7947());
                        itemStack.method_7939(0);
                        break;
                    }
                    if (itemStack.method_7960()) continue;
                    if (list.size() >= i) {
                        return false;
                    }
                    list.add(itemStack);
                    continue;
                }
                if (j != -1) continue;
                return false;
            }
            return true;
        }

        private int getFreeInventorySlots() {
            int i = 0;
            for (class_1799 itemStack : this.inventory.method_67533()) {
                if (!itemStack.method_7960()) continue;
                ++i;
            }
            return i;
        }
    }
}

