package xen42.peacefulitems;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.fabricmc.fabric.api.client.render.fluid.v1.SimpleFluidRenderHandler;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.minecraft.class_1770;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2960;
import net.minecraft.class_3929;
import net.minecraft.class_5272;
import net.minecraft.class_5601;
import net.minecraft.class_5616;
import net.minecraft.class_8189;
import xen42.peacefulitems.entity.EndClamEntityModel;
import xen42.peacefulitems.entity.EndClamEntityRenderer;
import xen42.peacefulitems.entity.GhastlingEntityModel;
import xen42.peacefulitems.entity.GhastlingEntityRenderer;
import xen42.peacefulitems.payloads.EffigyParticlePayload;
import xen42.peacefulitems.screen.EffigyAltarHandledScreen;

public class PeacefulModClient implements ClientModInitializer {
	public static final class_5601 MODEL_GHASTLING_LAYER = new class_5601(class_2960.method_43902(PeacefulMod.MOD_ID, "ghastling"), "main");
	public static final class_5601 MODEL_END_CLAM_LAYER = new class_5601(class_2960.method_43902(PeacefulMod.MOD_ID, "end_clam"), "main");

	@Override
	public void onInitializeClient() {
		BlockRenderLayerMap.INSTANCE.putBlock(PeacefulModBlocks.SULPHUR_CLUSTER, class_1921.method_23581());
		BlockRenderLayerMap.INSTANCE.putBlock(PeacefulModBlocks.FLAX_CROP, class_1921.method_23581());
		
		class_5616.method_32144(PeacefulModBlocks.FOSSIL_ORE_ENTITY, class_8189::new);
		
		class_2960 dragonBreathTexture = class_2960.method_43902(PeacefulMod.MOD_ID, "dragon_breath").method_45138("block/");
		FluidRenderHandlerRegistry.INSTANCE.register(PeacefulModFluids.DRAGON_BREATH, new SimpleFluidRenderHandler(dragonBreathTexture, dragonBreathTexture));
		
		class_5272.method_27879(PeacefulModItems.CAPE, class_2960.method_43902("minecraft","broken"), (stack, world, entity, seed) -> class_1770.method_7804(stack) ? 0.0F : 1.0F);
		
		EntityRendererRegistry.register(PeacefulMod.GHASTLING_ENTITY, context -> new GhastlingEntityRenderer(context)); 
		EntityModelLayerRegistry.registerModelLayer(MODEL_GHASTLING_LAYER, GhastlingEntityModel::getTexturedModelData);

		EntityRendererRegistry.register(PeacefulMod.END_CLAM_ENTITY, context -> new EndClamEntityRenderer(context));
		EntityModelLayerRegistry.registerModelLayer(MODEL_END_CLAM_LAYER, EndClamEntityModel::getTexturedModelData);

		class_3929.method_17542(PeacefulMod.EFFIGY_ALTAR_SCREEN_HANDLER, EffigyAltarHandledScreen::new);

		ClientPlayNetworking.registerGlobalReceiver(EffigyParticlePayload.ID, (payload, context) -> {
			context.client().execute(() -> {
				context.client().field_1713.method_3051(context.player(), (class_2394)class_2398.field_11220, 30);
				switch (payload.particleID()) {
					case "wither_effigy":
						context.client().field_1773.method_3189(new class_1799(PeacefulModItems.WITHER_EFFIGY));
						break;
					case "dragon_effigy":
						context.client().field_1773.method_3189(new class_1799(PeacefulModItems.DRAGON_EFFIGY));
						break;
					case "guardian_effigy":
						context.client().field_1773.method_3189(new class_1799(PeacefulModItems.GUARDIAN_EFFIGY));
						break;
					case "raid_effigy":
						context.client().field_1773.method_3189(new class_1799(PeacefulModItems.RAID_EFFIGY));
						break;
				}
			});
		});
	}
}