package xen42.peacefulitems;

import java.util.Map;
import java.util.Optional;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;

import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2741;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_5556;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;

public class PeacefulModModelGenerator extends FabricModelProvider {

    public PeacefulModModelGenerator(FabricDataOutput output) {
        super(output);
    }

    @Override
    public void generateBlockStateModels(class_4910 blockStateModelGenerator) {
    	blockStateModelGenerator.method_25623(PeacefulModBlocks.EFFIGY_ALTAR, class_4941.method_25842(PeacefulModBlocks.EFFIGY_ALTAR));
        registerSpawnEgg(blockStateModelGenerator, PeacefulModItems.GHASTLING_SPAWN_EGG);
        registerSpawnEgg(blockStateModelGenerator, PeacefulModItems.END_CLAM_SPAWN_EGG);

        blockStateModelGenerator.method_25650(PeacefulModBlocks.SULPHUR_BLOCK).method_33522(PeacefulModBlocks.SULPHUR);
        blockStateModelGenerator.method_25641(PeacefulModBlocks.FOSSIL_ORE);
        blockStateModelGenerator.method_25641(PeacefulModBlocks.DEEPSLATE_FOSSIL_ORE);
        blockStateModelGenerator.method_25641(PeacefulModBlocks.SOUL_SOIL_FOSSIL_ORE);
        blockStateModelGenerator.method_25641(PeacefulModBlocks.SULPHUR_ORE);
        blockStateModelGenerator.method_32229(PeacefulModBlocks.SULPHUR_CLUSTER);
        registerSeaPickle(blockStateModelGenerator, PeacefulModBlocks.BLAZE_PICKLE.method_8389(), PeacefulModBlocks.BLAZE_PICKLE);
        registerSeaPickle(blockStateModelGenerator, PeacefulModBlocks.BREEZE_CORAL.method_8389(), PeacefulModBlocks.BREEZE_CORAL);

        blockStateModelGenerator.method_25547(PeacefulModBlocks.FLAX_CROP, class_2741.field_12550, 0, 1, 2, 3, 4, 4, 5, 6);
        
        registerCauldron(blockStateModelGenerator, PeacefulModBlocks.DRAGON_BREATH_CAULDRON, class_2960.method_43902(PeacefulMod.MOD_ID, "dragon_breath").method_45138("block/"));
    }

    @Override
    public void generateItemModels(class_4915 itemModelGenerator) {
        itemModelGenerator.method_25733(PeacefulModItems.BAT_WING, class_4943.field_22938);
        registerWithBrokenCondition(itemModelGenerator, PeacefulModItems.CAPE);
        itemModelGenerator.method_25733(PeacefulModItems.GUANO, class_4943.field_22938);
        itemModelGenerator.method_25733(PeacefulModItems.ECTOPLASM, class_4943.field_22938);
        itemModelGenerator.method_25733(PeacefulModItems.SULPHUR, class_4943.field_22938);
        
        itemModelGenerator.method_25733(PeacefulModItems.WITHER_EFFIGY, class_4943.field_22938);
        itemModelGenerator.method_25733(PeacefulModItems.GUARDIAN_EFFIGY, class_4943.field_22938);
        itemModelGenerator.method_25733(PeacefulModItems.DRAGON_EFFIGY, class_4943.field_22938);
        itemModelGenerator.method_25733(PeacefulModItems.RAID_EFFIGY, class_4943.field_22938);

        itemModelGenerator.method_25733(PeacefulModItems.CLAM, class_4943.field_22938);
        itemModelGenerator.method_25733(PeacefulModItems.COOKED_CLAM, class_4943.field_22938);
    }

    @Override
    public String method_10321() {
        return "PeacefulModModelGenerator";
    }

    private class_4942 GetModel(String parent) {
        return new class_4942(Optional.of(class_2960.method_43902("minecraft","block/" + parent)), Optional.empty(), class_4945.field_23010, class_4945.field_23012);
    }
    
    public void registerWithBrokenCondition(class_4915 itemModelGenerator, class_1792 item) {
    	class_2960 model = class_4941.method_25840(item);
    	class_2960 brokenModel = model.method_48331("_broken");
    	class_2960 texture = class_4944.method_25876(item);
    	class_2960 brokenTexture = texture.method_48331("_broken");
		class_4943.field_22938.method_48525(model, class_4944.method_25895(texture), itemModelGenerator.field_22844, (identifier, textures) -> createBrokenConditionJson(model, brokenModel, textures));
		class_4943.field_22938.method_25852(brokenModel, class_4944.method_25895(brokenTexture), itemModelGenerator.field_22844);
    }

	public final JsonObject createBrokenConditionJson(class_2960 id,
			class_2960 brokenId, Map<class_4945, class_2960> textures) {
		JsonObject model = class_4943.field_22938.method_48524(id, textures);
		JsonArray overrides = new JsonArray();

		JsonObject override = new JsonObject();
		JsonObject predicate = new JsonObject();
		predicate.addProperty("broken", 1);
		override.add("predicate", predicate);
		override.addProperty("model", brokenId.toString());
		overrides.add(override);

		model.add("overrides", overrides);
		return model;
	}

    public void registerSpawnEgg(class_4910 blockStateModelGenerator, class_1792 item) {
    	blockStateModelGenerator.method_25538(item, class_4941.method_25845("template_spawn_egg"));
    }

    public void registerSeaPickle(class_4910 blockStateModelGenerator, class_1792 item, class_2248 block) {
		blockStateModelGenerator.method_25537(item);
        var textureMap = class_4944.method_25864(block);

        var id1 = GetModel("dead_sea_pickle").method_25847(block, "_one", textureMap, blockStateModelGenerator.field_22831);
        var id2 = GetModel("two_dead_sea_pickles").method_25847(block, "_two", textureMap, blockStateModelGenerator.field_22831);
        var id3 = GetModel("three_dead_sea_pickles").method_25847(block, "_three", textureMap, blockStateModelGenerator.field_22831);
        var id4 = GetModel("four_dead_sea_pickles").method_25847(block, "_four", textureMap, blockStateModelGenerator.field_22831);

		blockStateModelGenerator.field_22830
			.accept(
				class_4925.method_25769(block)
					.method_25775(
						class_4926.method_25783(class_2741.field_12543)
							.method_25793(1, class_4935.method_25824().method_25828(class_4936.field_22887, id1))
							.method_25793(2, class_4935.method_25824().method_25828(class_4936.field_22887, id2))
							.method_25793(3, class_4935.method_25824().method_25828(class_4936.field_22887, id3))
							.method_25793(4, class_4935.method_25824().method_25828(class_4936.field_22887, id4))
                    )
			);
	}
    
    public void registerCauldron(class_4910 blockStateModelGenerator, class_2248 cauldronBlock, class_2960 fluidTexture) {
    	class_4944 cauldronTextureMap = class_4944.method_32232(fluidTexture);
        blockStateModelGenerator.field_22830
			.accept(
				class_4925.method_25769(cauldronBlock)
					.method_25775(
						class_4926.method_25783(class_5556.field_27206)
							.method_25793(
								1,
								class_4935.method_25824().method_25828(
									class_4936.field_22887,
									class_4943.field_28014
										.method_25847(cauldronBlock, "_level1", cauldronTextureMap, blockStateModelGenerator.field_22831)
								)
							)
							.method_25793(
								2,
								class_4935.method_25824().method_25828(
									class_4936.field_22887,
									class_4943.field_28015
										.method_25847(cauldronBlock, "_level2", cauldronTextureMap, blockStateModelGenerator.field_22831)
								)
							)
							.method_25793(
								3,
								class_4935.method_25824().method_25828(
									class_4936.field_22887,
									class_4943.field_27784
										.method_25847(cauldronBlock, "_full", cauldronTextureMap, blockStateModelGenerator.field_22831)
								)
							)
					)
			);
    }
}
