package xen42.peacefulitems.blocks;

import org.jetbrains.annotations.Nullable;

import com.mojang.serialization.MapCodec;
import net.minecraft.class_10;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2261;
import net.minecraft.class_2338;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_5819;

public class BlazePickleBlock extends class_2261 implements class_2256 {
	public static final MapCodec<BlazePickleBlock> CODEC = method_54094(BlazePickleBlock::new);
	public static final int MAX_PICKLES = 4;
	public static final class_2758 PICKLES = class_2741.field_12543;
	protected static final class_265 ONE_PICKLE_SHAPE = class_2248.method_9541(6.0, 0.0, 6.0, 10.0, 6.0, 10.0);
	protected static final class_265 TWO_PICKLES_SHAPE = class_2248.method_9541(3.0, 0.0, 3.0, 13.0, 6.0, 13.0);
	protected static final class_265 THREE_PICKLES_SHAPE = class_2248.method_9541(2.0, 0.0, 2.0, 14.0, 6.0, 14.0);
	protected static final class_265 FOUR_PICKLES_SHAPE = class_2248.method_9541(2.0, 0.0, 2.0, 14.0, 7.0, 14.0);

	@Override
	public MapCodec<BlazePickleBlock> method_53969() {
		return field_46280;
	}

    public BlazePickleBlock(class_2251 settings) {
        super(settings);
		this.method_9590(this.field_10647.method_11664().method_11657(PICKLES, 1));
    }

    @Override
	public boolean method_9651(class_4538 world, class_2338 pos, class_2680 state) {
		return true;
	}

	@Override
	protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
		if (!this.method_9558(state, world, pos)) {
			world.method_22352(pos, true);
		}
	}

    @Override
	public void method_9652(class_3218 world, class_5819 random, class_2338 pos, class_2680 state) {
		int j = 1;
		int l = 0;
		int m = pos.method_10263() - 2;
		int n = 0;

		for (int o = 0; o < 5; o++) {
			for (int p = 0; p < j; p++) {
				int q = 2 + pos.method_10264() - 1;

				for (int r = q - 2; r < q; r++) {
					class_2338 blockPos = new class_2338(m + o, r, pos.method_10260() - n + p);
					if (blockPos != pos && random.method_43048(6) == 0 && world.method_8320(blockPos).method_27852(class_2246.field_10124)) {
						class_2680 blockState = world.method_8320(blockPos.method_10074());
						if (canPlant(blockState)) {
							world.method_8652(blockPos, this.method_9564().method_11657(PICKLES, random.method_43048(4) + 1), class_2248.field_31036);
						}
					}
				}
			}

			if (l < 2) {
				j += 2;
				n++;
			} else {
				j -= 2;
				n--;
			}

			l++;
		}

		world.method_8652(pos, state.method_11657(PICKLES, 4), class_2248.field_31028);
	}

    @Override
	protected boolean method_9695(class_2680 floor, class_1922 world, class_2338 pos) {
		return canPlant(floor) && (world.method_8320(pos.method_10084()).method_26215() || world.method_8320(pos.method_10084()).method_27852(this));
	}

	public boolean canPlant(class_2680 state) {
		return state.method_26164(class_3481.field_23119);
	}

    @Override
    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        var ground = pos.method_10074();
        return this.method_9695(world.method_8320(ground), world, ground);
    }

    @Override
    public boolean method_9650(class_1937 world, class_5819 random, class_2338 pos, class_2680 state) {
        return true;
    }

    @Override
	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		builder.method_11667(PICKLES);
	}

    @Override
	protected boolean method_9516(class_2680 state, class_10 type) {
		return false;
	}

    @Override
	protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
		switch (state.method_11654(PICKLES)) {
			case 1:
			default:
				return ONE_PICKLE_SHAPE;
			case 2:
				return TWO_PICKLES_SHAPE;
			case 3:
				return THREE_PICKLES_SHAPE;
			case 4:
				return FOUR_PICKLES_SHAPE;
		}
	}

    @Override
	protected boolean method_9616(class_2680 state, class_1750 context) {
		return !context.method_8046() && context.method_8041().method_31574(this.method_8389()) && state.method_11654(PICKLES) < 4 ? true : super.method_9616(state, context);
	}

    @Nullable
	@Override
	public class_2680 method_9605(class_1750 ctx) {
		class_2680 blockState = ctx.method_8045().method_8320(ctx.method_8037());
		if (blockState.method_27852(this)) {
			return blockState.method_11657(PICKLES, Math.min(4, (Integer)blockState.method_11654(PICKLES) + 1));
		} else {
			return super.method_9605(ctx);
		}
	}
}
