package xen42.peacefulitems.blocks;

import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3611;
import net.minecraft.class_5328;
import net.minecraft.class_5556;
import net.minecraft.class_5620;
import net.minecraft.class_5712;
import net.minecraft.class_6088;
import net.minecraft.class_9062;
import org.jetbrains.annotations.Nullable;

import com.mojang.serialization.MapCodec;
import xen42.peacefulitems.PeacefulMod;
import xen42.peacefulitems.PeacefulModBlocks;

public class DragonBreathCauldronBlock extends class_5556 {
    public static final class_5620.class_8821 DRAGON_BREATH_CAULDRON_BEHAVIOR = class_5620.method_32206("dragon_breath");
    
    public static final class_2758 LEVEL = class_2741.field_12513;
    
    public DragonBreathCauldronBlock(class_2251 settings) {
        super(class_1959.class_1963.field_9384, DRAGON_BREATH_CAULDRON_BEHAVIOR, settings);
        this.method_9590((this.field_10647.method_11664()));
        class_1792.field_8003.put(this, class_1802.field_8638);
    }
    
    public static void spawnDragonBreathCloud(class_1937 world, class_2338 pos, float radius, int duration) {
        class_1295 areaEffectCloudEntity = new class_1295(world, class_243.method_24955(pos).method_10216(), class_243.method_24955(pos).method_10214(), class_243.method_24955(pos).method_10215());
        areaEffectCloudEntity.method_5608(class_2398.field_11216);
        areaEffectCloudEntity.method_5603(radius);
        areaEffectCloudEntity.method_5604(duration);
        areaEffectCloudEntity.method_5596((7.0f - areaEffectCloudEntity.method_5599()) / (float) areaEffectCloudEntity.method_5605());
        areaEffectCloudEntity.method_5610(new class_1293(class_1294.field_5921, 1, 1){
            @Override
            public void method_58621(class_1309 livingEntity, class_1282 source, float amount){
                livingEntity.method_5643(world.method_48963().method_48833(),amount);
            }
        });
        world.method_20290(class_6088.field_31149, pos, 1);
        world.method_8649(areaEffectCloudEntity);
    }
    
    public void spawnDragonBreathCloud(class_1937 world, class_2338 pos) {
        spawnDragonBreathCloud(world, pos, this.method_9595().method_11664().method_11654(field_27206), this.method_9595().method_11664().method_11654(field_27206) * 200);
    }
    
    @Override
    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        this.method_33614(world, player, pos, state);
        if(!world.method_8608() && !player.method_7337()) {
            spawnDragonBreathCloud(world, pos);
        }
        world.method_43276(class_5712.field_28165, pos, class_5712.class_7397.method_43286(player, state));
        return state;
    }
    
    @Override
    public void method_9586(class_1937 world, class_2338 pos, class_1927 explosion) {
        if(!world.method_8608()) {
            if (explosion.method_8347() instanceof class_1657 player && player.method_7337()) {return;}
            spawnDragonBreathCloud(world, pos);
        }
    }
    
    @Override
    protected void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        if (world instanceof class_3218 serverWorld && this.method_31616(state, pos, entity)) {
            entity.method_5643(world.method_48963().method_48833(), 2.5f);
        }
    }

    @Override
    protected int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        return state.method_11654(field_27206)*4;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(field_27206);
    }

    @Override
    protected void method_32764(class_2680 state, class_1937 world, class_2338 pos, class_3611 fluid) {
        if (this.method_32766(state)) {
            return;
        }
        class_2680 blockState = state.method_11657(field_27206, state.method_11654(field_27206) + 1);
        world.method_8501(pos, blockState);
        world.method_43276(class_5712.field_28733, pos, class_5712.class_7397.method_43287(blockState));
        world.method_20290(class_6088.field_31135, pos, 0);
    }

    public static boolean setFluidLevel(class_2680 state, class_1937 world, class_2338 pos, boolean required, int level) {
        int maxLevel = getMaxFluidLevel(state);
        int actualLevel = Math.max(0, Math.min(level, maxLevel));

        if (maxLevel == -1 || (level != actualLevel && required) || getFluidLevel(state) == actualLevel) return false;

        world.method_8501(pos, actualLevel == 0 ? class_2246.field_10593.method_9564() : state.method_11657(class_5556.field_27206, actualLevel));
        return true;
    }

    public static void decrementFluidLevel(class_2680 state, class_1937 world, class_2338 pos, boolean required, int amount) {
        setFluidLevel(state, world, pos, required, getFluidLevel(state) - amount);
    }

    public static boolean incrementFluidLevel(class_2680 state, class_1937 world, class_2338 pos, boolean required, int amount) {
        return setFluidLevel(state, world, pos, required, getFluidLevel(state) + amount);
    }

    public static void method_31650(class_2680 state, class_1937 world, class_2338 pos) {
        decrementFluidLevel(state, world, pos, true, 1);
    }

    public static boolean incrementFluidLevel(class_2680 state, class_1937 world, class_2338 pos) {
        return incrementFluidLevel(state, world, pos, true, 1);
    }

    public static int getFluidLevel(class_2680 state) {
        if (state.method_27852(class_2246.field_27098)) {
            return 1;
        } else if (state.method_26204() instanceof class_5556) {
            return state.method_11654(class_5556.field_27206);
        } else if (state.method_27852(class_2246.field_10593)) {
            return 0;
        }
        return -1;
    }

    public static int getMaxFluidLevel(class_2680 state) {
        if (state.method_26204() instanceof class_5556 block) {
            return block.field_31108;
        } else if (state.method_27852(class_2246.field_27098)) {
            return 1;
        } else if (state.method_26204() instanceof class_5556) {
            return 3;
        } else if (state.method_27852(class_2246.field_10593)) {
            return 0;
        }
        return -1;
    }

    public static boolean canSetFluidLevel(class_2680 state, int level) {
        int maxLevel = getMaxFluidLevel(state);
        int actualLevel = Math.max(0, Math.min(level, maxLevel));

        return maxLevel != -1 && level == actualLevel && getFluidLevel(state) != actualLevel;
    }

    public static boolean canIncrementFluidLevel(class_2680 state, int amount) {
        return canSetFluidLevel(state, getFluidLevel(state) + amount);
    }

    public static boolean canIncrementFluidLevel(class_2680 state) {
        return canIncrementFluidLevel(state, 1);
    }

    public static class FillFromEffigyBehavior implements class_5620 {
        @Override
        public class_9062 interact(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_1799 stack) { 
            if (!world.field_9236) {
                class_1792 item = stack.method_7909();
                player.method_6122(hand, class_5328.method_30012(stack, player, class_1799.field_8037));
                player.method_7281(class_3468.field_15373);
                player.method_7259(class_3468.field_15372.method_14956(item));
                world.method_8501(pos, PeacefulModBlocks.DRAGON_BREATH_CAULDRON.method_9564().method_11657(class_5556.field_27206, 3));
                world.method_8396(null, pos, PeacefulMod.ITEM_BOTTLE_EMPTY_DRAGONBREATH, class_3419.field_15245, 1.0F, 1.0F);
                world.method_33596(null, class_5712.field_28166, pos);
            }

            return class_9062.field_47728;
        }
    }

    public static class FillFromBottleBehavior implements class_5620 {
        @Override
        public class_9062 interact(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_1799 stack) { 
            if (!world.field_9236) {
                class_1792 item = stack.method_7909();
                player.method_6122(hand, class_5328.method_30012(stack, player, new class_1799(class_1802.field_8469)));
                player.method_7281(class_3468.field_15373);
                player.method_7259(class_3468.field_15372.method_14956(item));
                world.method_8501(pos, PeacefulModBlocks.DRAGON_BREATH_CAULDRON.method_9564());
                world.method_8396(null, pos, PeacefulMod.ITEM_BOTTLE_EMPTY_DRAGONBREATH, class_3419.field_15245, 1.0F, 1.0F);
                world.method_33596(null, class_5712.field_28166, pos);
            }

            return class_9062.field_47728;
        }
    }

    public static class DecrementFluidLevelBehavior implements class_5620 {
        @Override
        public class_9062 interact(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_1799 stack) {
            if (!world.field_9236) {
                class_1792 item = stack.method_7909();
                player.method_6122(hand, class_5328.method_30012(stack, player, new class_1799(class_1802.field_8613)));
                player.method_7281(class_3468.field_15373);
                player.method_7259(class_3468.field_15372.method_14956(item));
                method_31650(state, world, pos);
                world.method_8396(null, pos, class_3417.field_15029, class_3419.field_15245, 1.0F, 1.0F);
                world.method_33596(null, class_5712.field_28166, pos);
            }
            
            return class_9062.field_47728;
        }
    }

    public static class IncrementFluidLevelBehavior implements class_5620 {
        @Override
        public class_9062 interact(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_1799 stack) {
            if (canIncrementFluidLevel(state)) {
                if (!world.field_9236) {
                    class_1792 item = stack.method_7909();
                    player.method_6122(hand, class_5328.method_30012(stack, player, new class_1799(class_1802.field_8469)));
                    player.method_7281(class_3468.field_15373);
                    player.method_7259(class_3468.field_15372.method_14956(item));
                    incrementFluidLevel(state, world, pos);
                    world.method_8396(null, pos, PeacefulMod.ITEM_BOTTLE_EMPTY_DRAGONBREATH, class_3419.field_15245, 1.0F, 1.0F);
                    world.method_33596(null, class_5712.field_28166, pos);
                }

                return class_9062.field_47728;
            } else {
                return class_9062.field_47731;
            }
        }
    }
}