package xen42.peacefulitems.entities;

import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1315;
import net.minecraft.class_1421;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_7094;
import org.jetbrains.annotations.Nullable;
import xen42.peacefulitems.PeacefulModItems;

public class EndClamEntity extends class_1421 {
    public final class_7094 idleAnimationState;
    public final class_7094 hitAnimationState;
    public final class_7094 yawnAnimationState;
    public final class_7094 openAnimationState;
    private long _revertToIdleTick;
    private long _lastYawn;

    private static final class_2940<Boolean> IS_OPENING = class_2945.method_12791(EndClamEntity.class, class_2943.field_13323);
    private static final class_2940<Boolean> IS_YAWNING = class_2945.method_12791(EndClamEntity.class, class_2943.field_13323);
    private static final class_2940<Boolean> WAS_JUST_HIT = class_2945.method_12791(EndClamEntity.class, class_2943.field_13323);

    public EndClamEntity(class_1299<? extends class_1421> entityType, class_1937 world) {
        super(entityType, world);
        this.idleAnimationState = new class_7094();
        this.hitAnimationState = new class_7094();
        this.yawnAnimationState = new class_7094();
        this.openAnimationState = new class_7094();
        method_5952(true);
    }

    @Override
    public boolean method_5936() {
        return true;
    }

    @Override
    public boolean method_5939(class_1799 stack) {
        return true;
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
		builder.method_56912(IS_OPENING, false);
		builder.method_56912(IS_YAWNING, false);
		builder.method_56912(WAS_JUST_HIT, false);
    }
    
    @Override
    protected class_3414 method_5994() {
        return class_3417.field_14632;
    }

    @Override
    protected float method_6107() {
        return 0.4f;
    }

    public static boolean isValidSpawn(class_1299<? extends EndClamEntity> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return world.method_8320(pos).method_26215() && !world.method_8320(pos.method_10074()).method_26215() && !world.method_8320(pos).method_27852(class_2246.field_10164);
    }

    public static class_5132.class_5133 method_26828() {
        return class_1421.method_26828()
            .method_26868(class_5134.field_23716, 20)
            .method_26868(class_5134.field_47760, 1.5);
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        if (field_5974.method_43057() < 0.6f) {
            this.teleportRandomly();
        }

        if (!this.method_37908().field_9236) {
            this.method_5841().method_12778(WAS_JUST_HIT, true);
        }

        return super.method_5643(source, amount);
    }

    @Override
    public class_3414 method_6011(class_1282 source) {
        return class_3417.field_15229;
    }

    @Override
    public void method_5773() {
        super.method_5773();

        // Only yawn when the idle animation has the mouth closed
        if (!method_37908().field_9236) {
            if (idleAnimationState.method_41327() && getTimeInMilliseconds() % 4000 == 0 && this.method_6051().method_43056()
                    && this.method_37908().method_8510() > _lastYawn + 40) {
                this.method_5841().method_12778(IS_YAWNING, true);
                this.method_56078(class_3417.field_15017);
                _lastYawn = this.method_37908().method_8510();
            }
        }

        updateAnimations();
    }
    
    public long getTimeInMilliseconds() {
        float f = field_6012 - idleAnimationState.method_43687();
        return (long)(f * 50.0F);
    }

    public void updateAnimations() {
        if (!idleAnimationState.method_41327() && !this.method_5841().method_12789(WAS_JUST_HIT) 
            && !this.method_5841().method_12789(IS_YAWNING) && !this.method_5841().method_12789(IS_OPENING)) {
            idleAnimationState.method_41325();
            yawnAnimationState.method_41325();
            hitAnimationState.method_41325();
            openAnimationState.method_41325();

            idleAnimationState.method_41322(this.field_6012);
        }
        else if (this.method_5841().method_12789(WAS_JUST_HIT) && !hitAnimationState.method_41327()) {
            _revertToIdleTick = method_37908().method_8510() + (long)(0.6f * 20);

            this.method_5841().method_12778(IS_YAWNING, false);
            this.method_5841().method_12778(IS_OPENING, false);

            idleAnimationState.method_41325();
            yawnAnimationState.method_41325();
            hitAnimationState.method_41325();
            openAnimationState.method_41325();

            hitAnimationState.method_41322(this.field_6012);
        }
        else if (this.method_5841().method_12789(IS_OPENING) && !openAnimationState.method_41327()) {
            _revertToIdleTick = method_37908().method_8510() + (long)(2f * 20);

            this.method_5841().method_12778(WAS_JUST_HIT, false);
            this.method_5841().method_12778(IS_YAWNING, false);

            idleAnimationState.method_41325();
            yawnAnimationState.method_41325();
            hitAnimationState.method_41325();
            openAnimationState.method_41325();

            openAnimationState.method_41322(this.field_6012);
        }
        else if (this.method_5841().method_12789(IS_YAWNING) && !yawnAnimationState.method_41327()) {
            _revertToIdleTick = method_37908().method_8510() + (long)(5f * 20);

            this.method_5841().method_12778(WAS_JUST_HIT, false);
            this.method_5841().method_12778(IS_OPENING, false);

            idleAnimationState.method_41325();
            yawnAnimationState.method_41325();
            hitAnimationState.method_41325();
            openAnimationState.method_41325();

            yawnAnimationState.method_41322(this.field_6012);
        }

        if (!this.method_37908().field_9236 && this.method_37908().method_8510() > _revertToIdleTick) {
            this.method_5841().method_12778(WAS_JUST_HIT, false);
            this.method_5841().method_12778(IS_YAWNING, false);
            this.method_5841().method_12778(IS_OPENING, false);
        }
    }

    protected boolean teleportRandomly() {
        if (method_37908().method_8608()) {
            return false; 
        } 

        // Try a few times times
        // Goes up so that when it searchs back down it can go up ledges and stuff
        for (int i = 0; i < 5; i++) {
            var x = method_23317() + (this.field_5974.method_43058() - 0.5D) * 8.0D;
            var y = method_23318() + 6;
            var z = method_23321() + (this.field_5974.method_43058() - 0.5D) * 8.0D;
            if (teleportTo(x, y, z)) {
                return true;
            }
        }
        return false;
    } 

    private boolean teleportTo(double x, double y, double z) {
        var blockPos = new class_2338.class_2339(x, y, z);

        // Search downwards for an air block with solid block below it
        class_2680 blockState, downBlockState;
        boolean flag = false;
        do {
            blockState = method_37908().method_8320(blockPos);
            downBlockState = method_37908().method_8320(blockPos.method_10074());
            var isBlockValid = blockState.method_26215();
            var isGroundValid = !downBlockState.method_26215();
            if (isBlockValid && isGroundValid) {
                flag = true;
                break;
            }
            blockPos.method_10098(class_2350.field_11033);
        }
        while(blockPos.method_10264() - 1 > method_37908().method_31607());

        if (!flag) {
            return false;
        }

        var successfulTeleport = method_6082(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260(), true); 
        if (successfulTeleport) {
            method_37908().method_32888(class_5712.field_39446, method_19538(), class_5712.class_7397.method_43285(this)); 
            if (!method_5701()) {
                method_37908().method_43128(null, this.field_6014, this.field_6036, this.field_5969, class_3417.field_14879, method_5634(), 1.0F, 1.0F);
                method_5783(class_3417.field_14879, 1.0F, 1.0F);
            } 
        } 
        return successfulTeleport;    
    } 

    @Override
    public void method_6007() {
        super.method_6007();
        if ((method_37908()).field_9236 && method_6118(class_1304.field_6173).method_31574(class_1802.field_8634)) {
            method_37908().method_8406((class_2394)class_2398.field_11214, 
                method_23322(0.25D), 
                method_23319() + 0.25D, 
                method_23325(0.25D), 
                (this.field_5974.method_43058() - 0.5D) * 2.0D, 
                -this.field_5974.method_43058(), 
                (this.field_5974.method_43058() - 0.5D) * 2.0D);
        }
    }

    @Override
    protected void method_5949(class_1542 itemEntity) {
        class_1799 itemStack = itemEntity.method_6983();
        if (!this.method_5841().method_12789(IS_OPENING)) {
            if (!method_6118(class_1304.field_6173).method_7960()) {
                if (!method_37908().field_9236) {
                    var thrownItem = new class_1542(method_37908(), method_23317() + (method_5720()).field_1352, method_23318() + 1.0D, method_23321() + (method_5720()).field_1350, 
                        method_6118(class_1304.field_6173));
                    thrownItem.method_6982(40);
                    thrownItem.method_6981(this);
                    method_37908().method_8649(thrownItem);
                }
            }

            int i = itemStack.method_7947();
            if (i > 1) {
                dropItem(itemStack.method_7971(i - 1));
            }

            method_29499(itemEntity);
            method_5673(class_1304.field_6173, itemStack.method_7971(1));
            method_25939(class_1304.field_6173);
            method_6103(itemEntity, itemStack.method_7947());
            itemEntity.method_31472();

            if(!this.method_37908().field_9236) {
                this.method_5841().method_12778(IS_OPENING, true);
                this.method_56078(class_3417.field_15017);
            }
        } 
    }

    private void dropItem(class_1799 stack) {
        var itemEntity = new class_1542(method_37908(), method_23317(), method_23318(), method_23321(), stack);
        method_37908().method_8649(itemEntity);
    }

    @Override
    protected void method_16080(class_1282 damageSource) {
        var itemStack = method_6118(class_1304.field_6173);
        if (!itemStack.method_7960()) {
            method_5775(itemStack);
            method_5673(class_1304.field_6173, class_1799.field_8037);
        }
        super.method_16080(damageSource);
    }

    @Override
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        // Spawn with item
        if (field_5974.method_43057() < 0.5f) {
            var r = field_5974.method_43057();
            class_1792 item;
            if (r < 0.5) {
                item = class_1802.field_8634;
            }
            else if (r < 0.75) {
                item = PeacefulModItems.SULPHUR;
            }
            else {
                item = class_1802.field_8397;
            }

            method_5673(class_1304.field_6173, new class_1799(item));
        }
        // Face a random direction
        method_36456(this.field_5974.method_43057() * 360f);
        this.field_6241 = method_36454();
        method_22862();
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }
}
