package xen42.peacefulitems.entity;

import net.minecraft.class_1306;
import net.minecraft.class_1921;
import net.minecraft.class_3532;
import net.minecraft.class_3881;
import net.minecraft.class_4587;
import net.minecraft.class_5597;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_6230;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import xen42.peacefulitems.entities.GhastlingEntity;


public class GhastlingEntityModel extends class_5597<GhastlingEntity> implements class_3881 {
    private final class_630 root;
    private final class_630 head;
    private final class_630 body;
    private final class_630 rightArm;
    private final class_630 leftArm;
    private final class_630 rightWing;
    private final class_630 leftWing;

    public GhastlingEntityModel(class_630 modelPart) {
        super(class_1921::method_23580);
        this.root = modelPart.method_32086(class_6230.field_37942);
        this.head = this.root.method_32086(class_6230.field_32606);
        this.body = this.root.method_32086(class_6230.field_32608);
        this.rightArm = this.body.method_32086(class_6230.field_32622);
        this.leftArm = this.body.method_32086(class_6230.field_32621);
        this.rightWing = this.body.method_32086(class_6230.field_32624);
        this.leftWing = this.body.method_32086(class_6230.field_32623);
    }

    @Override
    public class_630 method_32008() {
        return this.root;
    }

    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        class_5610 modelPartData2 = modelPartData.method_32117(class_6230.field_37942, class_5606.method_32108(), class_5603.method_32090(0.0F, 23.5F, 0.0F));
        modelPartData2.method_32117(
            class_6230.field_32606,
            class_5606.method_32108().method_32101(0, 0).method_32098(-2.5F, -5.0F, -2.5F, 5.0F, 5.0F, 5.0F, new class_5605(0.0F)),
            class_5603.method_32090(0.0F, -3.99F, 0.0F)
        );
        class_5610 modelPartData3 = modelPartData2.method_32117(
            class_6230.field_32608,
            class_5606.method_32108()
                .method_32101(0, 10)
                .method_32098(-1.5F, 0.0F, -1.0F, 3.0F, 4.0F, 2.0F, new class_5605(0.0F))
                .method_32101(0, 16)
                .method_32098(-1.5F, 0.0F, -1.0F, 3.0F, 5.0F, 2.0F, new class_5605(-0.2F)),
            class_5603.method_32090(0.0F, -4.0F, 0.0F)
        );
        modelPartData3.method_32117(
            class_6230.field_32622,
            class_5606.method_32108().method_32101(23, 0).method_32098(-0.75F, -0.5F, -1.0F, 1.0F, 4.0F, 2.0F, new class_5605(-0.01F)),
            class_5603.method_32090(-1.75F, 0.5F, 0.0F)
        );
        modelPartData3.method_32117(
            class_6230.field_32621,
            class_5606.method_32108().method_32101(23, 6).method_32098(-0.25F, -0.5F, -1.0F, 1.0F, 4.0F, 2.0F, new class_5605(-0.01F)),
            class_5603.method_32090(1.75F, 0.5F, 0.0F)
        );
        modelPartData3.method_32117(
            class_6230.field_32624,
            class_5606.method_32108().method_32101(16, 14).method_32098(0.0F, 1.0F, 0.0F, 0.0F, 5.0F, 8.0F, new class_5605(0.0F)),
            class_5603.method_32090(-0.5F, 0.0F, 0.6F)
        );
        modelPartData3.method_32117(
            class_6230.field_32623,
            class_5606.method_32108().method_32101(16, 14).method_32098(0.0F, 1.0F, 0.0F, 0.0F, 5.0F, 8.0F, new class_5605(0.0F)),
            class_5603.method_32090(0.5F, 0.0F, 0.6F)
        );
        return class_5607.method_32110(modelData, 32, 32);
    }

    public void setAngles(GhastlingEntity ghastlingEntity, float limbSwingAnimationProgress, float limbSwingAmplitude, float age, float pitch, float yaw) {
        this.method_32008().method_32088().forEach(class_630::method_41923);

        float k = age * 20.0F * (float) (Math.PI / 180.0) + limbSwingAnimationProgress;
        float l = class_3532.method_15362(k) * (float) Math.PI * 0.15F + limbSwingAmplitude;
        float m = age * 9.0F * (float) (Math.PI / 180.0);
        float n = Math.min(limbSwingAmplitude / 0.3F, 1.0F);
        float o = 1.0F - n;

        float itemHoldAnimationTicks = 0.0F;

        this.head.field_3654 = pitch * (float) (Math.PI / 180.0);
        this.head.field_3675 = yaw * (float) (Math.PI / 180.0);

        this.rightWing.field_3654 = 0.43633232F * (1.0F - n);
        this.rightWing.field_3675 = (float) (-Math.PI / 4) + l;
        this.leftWing.field_3654 = 0.43633232F * (1.0F - n);
        this.leftWing.field_3675 = (float) (Math.PI / 4) - l;
        this.body.field_3654 = n * (float) (Math.PI / 4);

        float p = itemHoldAnimationTicks * class_3532.method_16439(n, (float) (-Math.PI / 3), -1.134464F);
        this.root.field_3656 = this.root.field_3656 + (float)Math.cos(m) * 0.25F * o;
        this.rightArm.field_3654 = p;
        this.leftArm.field_3654 = p;

        float q = o * (1.0F - itemHoldAnimationTicks);
        float r = 0.43633232F - class_3532.method_15362(m + (float) (Math.PI * 3.0 / 2.0)) * (float) Math.PI * 0.075F * q;
        this.leftArm.field_3674 = -r;
        this.rightArm.field_3674 = r;
        this.rightArm.field_3675 = 0.27925268F * itemHoldAnimationTicks;
        this.leftArm.field_3675 = -0.27925268F * itemHoldAnimationTicks;
    }

    @Override
    public void method_2803(class_1306 arm, class_4587 matrices) {
        float f = 1.0F;
        float g = 3.0F;
        this.root.method_22703(matrices);
        this.body.method_22703(matrices);
        matrices.method_46416(0.0F, 0.0625F, 0.1875F);
        matrices.method_22907(class_7833.field_40714.rotation(this.rightArm.field_3654));
        matrices.method_22905(0.7F, 0.7F, 0.7F);
        matrices.method_46416(0.0625F, 0.0F, 0.0F);
    }
}
