package xen42.peacefulitems.item;

import java.util.function.Consumer;

import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2767;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_6880;
import xen42.peacefulitems.payloads.EffigyParticlePayload;

public class EffigyItem extends class_1792 {

    private String _particleID;
    private Consumer<class_3222> _onUse;
    private class_3414 _sound;
    private class_6880.class_6883<class_3414> _regSound;

    public EffigyItem(class_1793 settings, String particleID, Consumer<class_3222> onUse, class_3414 sound) {
        super(settings);
        _particleID = particleID;
        _onUse = onUse;
        _sound = sound;
    }

        public EffigyItem(class_1793 settings, String particleID, Consumer<class_3222> onUse, class_6880.class_6883<class_3414> regSound) {
        super(settings);
        _particleID = particleID;
        _onUse = onUse;
        _regSound = regSound;
    }
    
    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);

        if (_sound != null) {
            world.method_55116(user, _sound, class_3419.field_15251, 0.2f, 1f);
        }

        if (!user.method_7337()) {
            itemStack.method_7934(1);
        }

        if (!world.method_8608()) {
            _onUse.accept((class_3222)user);
            ServerPlayNetworking.send((class_3222)user, new EffigyParticlePayload(_particleID));

            // If the sound is provided as a reg key we do this server side
            if (_regSound != null) {
                 var serverPlayerEntity = (class_3222)user;
                serverPlayerEntity.field_13987.method_14364(new class_2767(_regSound, class_3419.field_15254, 
                    serverPlayerEntity.method_23317(), serverPlayerEntity.method_23318(), serverPlayerEntity.method_23321(), 128.0F, 1.0F, 1l));
            }
        }

        return class_1271.method_22428(itemStack);
    }
}
