package xen42.peacefulitems.mixin;

import java.util.UUID;
import net.minecraft.class_1267;
import net.minecraft.class_1510;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2700;
import net.minecraft.class_2881;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xen42.peacefulitems.PeacefulMod;
import xen42.peacefulitems.PeacefulModEndPersistentState;

@Mixin(class_2881.class)
public class EnderDragonFightMixin {

    @Shadow
    private class_3218 world;

    @Shadow
    private class_2338 origin;

    @Shadow
    private UUID dragonUuid;

    @Shadow
    private class_3213 bossBar;

    @Shadow
    private boolean previouslyKilled;

    @Shadow
    @Nullable
    private class_2338 exitPortalLocation;

    @Shadow
    private void generateEndPortal(boolean previouslyKilled) {}

    @Shadow
    @Nullable
    private class_2700.class_2702 findEndPortal() { return null; }

    @Inject(at = @At("HEAD"), method = "createDragon", cancellable = true)
    public void createDragon(CallbackInfoReturnable<class_1510> info) {
        if (world.method_8407() == class_1267.field_5801 && 
            !world.method_8450().method_8355(PeacefulMod.ENABLE_ENDER_DRAGON_FIGHT_PEACEFUL))
        {
            info.setReturnValue(null);
            info.cancel();
        }
    }

    @Inject(at = @At("HEAD"), method = "tick", cancellable = true)
    public void tick(CallbackInfo info) {
        var fight = (class_2881)((Object)this);

        if (world.method_8407() == class_1267.field_5801 && 
            !world.method_8450().method_8355(PeacefulMod.ENABLE_ENDER_DRAGON_FIGHT_PEACEFUL))
        {
            // Set the current dragon to null this way if they switch off peaceful itll come back
            dragonUuid = null;

            if (!fight.method_12536()) {
                exitPortalLocation = null; // Set to null for either findEndPortal or generateEndPortal to set the value.
                findEndPortal(); // find existing location if there is one
                generateEndPortal(true); // if no existing it will generate new one. if existing it will open the portal.

                previouslyKilled = true;
            }
            
            if (!PeacefulModEndPersistentState.INSTANCE.getHasSpawnedEgg()) {
                class_2338 eggSpawnPos = new class_2338(this.exitPortalLocation);
                while (this.world.method_8320(eggSpawnPos).method_27852(class_2246.field_9987)) {
                    eggSpawnPos = eggSpawnPos.method_10084();
                }
                this.world.method_8501(eggSpawnPos, class_2246.field_10081.method_9564());
                PeacefulModEndPersistentState.INSTANCE.setHasSpawnedEgg(true);
            }

            bossBar.method_14091(false);
            info.cancel();
        }
    }
}
