package xen42.peacefulitems.mixin;

import net.minecraft.class_1267;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_1928;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xen42.peacefulitems.PeacefulMod;

@Mixin(class_1702.class)
public class HungerManagerMixin {

    @Shadow
    private float exhaustion;

    @Shadow
    private int foodTickTimer;

    @Shadow
    private float saturationLevel;

    @Shadow
    private int foodLevel = 20;

    @Inject(at = @At("HEAD"), method = "update", cancellable = true)
    private void update(class_1657 player, CallbackInfo info)
            throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        if (player.method_37908().method_8407() != class_1267.field_5801) {
            return;
        }

        var turboHeal = player.method_37908().method_8450().method_8355(PeacefulMod.ENABLE_SUPER_HEALING_PEACEFUL);
        var canStarve = player.method_37908().method_8450().method_8355(PeacefulMod.ENABLE_STARVING_PEACEFUL);
        var canHeal = player.method_37908().method_8450().method_8355(class_1928.field_19395);
        var hungerManager = (class_1702) ((Object) this);
        
        // Do the basic not peaceful thing
        if (exhaustion > 4f) {
            exhaustion = exhaustion - 4f;
            if (hungerManager.method_7589() > 0f) {
                hungerManager.method_7581(Math.max(hungerManager.method_7589() - 1f, 0));
            } else {
                // If canStarve is off or turbo heal is on keep hunger above 5 bars 
                hungerManager.method_7580(Math.max(hungerManager.method_7586() - 1, canStarve ? 0 : 8));
            }
        }

        if (turboHeal) {
            if (canHeal && player.method_7317()) {
                // Apply healing
                foodTickTimer++;
                if (foodTickTimer >= 10) {
                    player.method_6025(1);
                    player.method_7322(2);
                    foodTickTimer = 0;
                }
            }
        }
        else {
            if (canHeal && this.saturationLevel > 0.0F && player.method_7317() && this.foodLevel >= 20) {
                ++this.foodTickTimer;
                if (this.foodTickTimer >= 10) {
                    float f = Math.min(this.saturationLevel, 6.0F);
                    player.method_6025(f / 6.0F);
                    hungerManager.method_7583(f);
                    this.foodTickTimer = 0;
                }
            } else if (canHeal && this.foodLevel >= 18 && player.method_7317()) {
                ++this.foodTickTimer;
                if (this.foodTickTimer >= 80) {
                    player.method_6025(1.0F);
                    hungerManager.method_7583(6.0F);
                    this.foodTickTimer = 0;
                }
            } else if (this.foodLevel <= 0) {
                ++this.foodTickTimer;
                if (this.foodTickTimer >= 80) {
                    if (canStarve) {
                        player.method_5643(player.method_48923().method_48825(), 1.0F);
                    }

                    this.foodTickTimer = 0;
                }
            } else {
                this.foodTickTimer = 0;
            }
        }
            
        info.cancel();
    }
}