package xen42.peacefulitems.mixin;

import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1308;
import net.minecraft.class_1420;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2398;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4050;
import net.minecraft.class_5321;
import net.minecraft.class_7102;
import net.minecraft.class_7106;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xen42.peacefulitems.PeacefulMod;

@Mixin(class_1308.class)
public class MobEntityMixin {
    @Inject(at = @At("HEAD"), method = "loot", cancellable = true)
    private void loot(class_1542 item, CallbackInfo info) {

        // Make sure the base looting logic doesnt run for frogs else they take all your stuff
        if ((Object)this instanceof class_7102) {
            info.cancel();
            var frog = (class_7102)((Object)this);
            class_1937 world = frog.method_37908();

            if (!world.field_9236 && world.method_27983() == class_1937.field_25180) {
                if (item.method_6983().method_31574(class_1802.field_8135)) {
                    var variant = (class_5321<class_7106>)frog.method_41354().method_40230().orElse(null);
                    var block = class_2246.field_37573;
                    if (variant == class_7106.field_37462) {
                        block = class_2246.field_37572;
                    }
                    else if (variant == class_7106.field_37463) {
                        block = class_2246.field_37574;
                    }
    
                    frog.method_56078(class_3417.field_37315);
                    frog.method_37908().method_43129(null, frog, class_3417.field_37315, class_3419.field_15254, 1.0f, 1.0f);
                    frog.method_18380(class_4050.field_37423);
                    frog.method_5951(item, 180, 180);
                    frog.method_6121(item);
    
                    var count = item.method_6983().method_7947();
                    // Random number between half and all of the magma cream
                    var spawnCount = (int)(frog.method_6051().method_43057() * count / 2) + count / 2;
                    if (spawnCount > 0) {
                        frog.method_5775(new class_1799(block.method_8389(), spawnCount)); 
                    }
                    item.method_31472();
                }
            }
        }
    }

    @Inject(at = @At("HEAD"), method = "interactMob", cancellable = true)
    private void interactMob(class_1657 player, class_1268 hand, CallbackInfoReturnable<class_1269> info) {
        
        if ((Object)this instanceof class_1420) {
            class_1799 item = player.method_5998(hand);
            var bat = ((class_1420)(Object)this);

            if (item.method_31574(class_1802.field_8497) && bat.method_5841().method_12789(PeacefulMod.BAT_BREEDING_TICKS) <= 0f 
                    && bat.method_5841().method_12789(PeacefulMod.BAT_BREEDING_COOLDOWN) <= 0f) {                
                if (!player.method_31549().field_7477) {
                    item.method_7934(1);
                }
                for (int i = 0; i < 7; ++i) {
                    double d = bat.method_6051().method_43059() * 0.02;
                    double e = bat.method_6051().method_43059() * 0.02;
                    double f = bat.method_6051().method_43059() * 0.02;
                    bat.method_37908().method_8406(class_2398.field_11201, bat.method_23322(1.0), bat.method_23319() + 0.5, bat.method_23325(1.0), d, e, f);
                }
                // 40 seconds I think?
                bat.method_5841().method_12778(PeacefulMod.BAT_BREEDING_TICKS, 40*20);
                info.setReturnValue(class_1269.field_5812);
            }
        }
    }

    @Inject(at = @At("RETURN"), method = "setBaby", cancellable = true)
    private void setBaby(boolean baby, CallbackInfo info) {
        if (((Object)this) instanceof class_1420) {
            var bat = ((class_1420)(Object)this);
            bat.method_5841().method_12778(PeacefulMod.BAT_IS_BABY, baby);
            if (baby) {
                // Breeding cooldown doubles as age timer because why not
                bat.method_5841().method_12778(PeacefulMod.BAT_BREEDING_COOLDOWN, PeacefulMod.BatGrowUpTicks);
            }
            else {
                bat.method_5841().method_12778(PeacefulMod.BAT_BREEDING_COOLDOWN, 0);
            }
        }
    }

    @Inject(at = @At("RETURN"), method = "canImmediatelyDespawn", cancellable = true)
    public void canImmediatelyDespawn(double distanceSquared, CallbackInfoReturnable<Boolean> info) {
        if (((Object)this) instanceof class_1420) {
            info.setReturnValue(false);
        }
    }
}
