package xen42.peacefulitems.recipe;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_3956;
import net.minecraft.class_5699;
import net.minecraft.class_7225;
import net.minecraft.class_7225.class_7874;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

import it.unimi.dsi.fastutil.chars.CharArraySet;
import it.unimi.dsi.fastutil.chars.CharSet;
import xen42.peacefulitems.PeacefulMod;
import xen42.peacefulitems.PeacefulModBlocks;
import xen42.peacefulitems.PeacefulModItems;

public class EffigyAltarRecipe implements class_1860<EffigyAltarRecipeInput> {
	final RawRecipe raw;
	public final class_1799 result;
	final OptionalInt cost;
	final String group;

	public EffigyAltarRecipe(String group, RawRecipe raw, class_1799 result) {
		this(group, raw, result, OptionalInt.empty());
	}

	public EffigyAltarRecipe(String group, RawRecipe raw, class_1799 result, Optional<Integer> cost) {
		this(group, raw, result, cost.stream().mapToInt(i -> i).findFirst());
	}

	public EffigyAltarRecipe(String group, RawRecipe raw, class_1799 result, OptionalInt cost) {
		this.group = group;
		this.raw = raw;
		this.result = result;
		this.cost = cost;
	}

	@Override
	public class_3956<EffigyAltarRecipe> method_17716() {
		return PeacefulMod.EFFIGY_ALTAR_RECIPE_TYPE;
	}

	@Override
	public class_1865<? extends EffigyAltarRecipe> method_8119() {
		return PeacefulMod.EFFIGY_ALTAR_RECIPE_SERIALIZER;
	}

	@Override
	public String method_8112() {
		return this.group;
	}

	@Override
	public boolean method_8118() {
		return false;
	}

	@Override
	public boolean method_49188() {
		return true;
	}

	@Override
	public boolean method_31584() {
		class_2371<class_1856> defaultedList = this.method_8117();
		return defaultedList.isEmpty()
			|| defaultedList.stream().filter(ingredient -> !ingredient.method_8103()).anyMatch(ingredient -> ingredient.method_8105().length == 0);
	}

	public class_2371<class_1799> getRecipeRemainders(EffigyAltarRecipeInput input) {
		return collectRecipeRemainders(input);
	}

	public static class_2371<class_1799> collectRecipeRemainders(EffigyAltarRecipeInput input) {
		class_2371<class_1799> defaultedList = class_2371.method_10213(input.method_5439(), class_1799.field_8037);

		for (int i = 0; i < defaultedList.size(); i++) {
			defaultedList.set(i, input.getStackInSlot(i));
		}

		return defaultedList;
	}

	@Override
	@VisibleForTesting
	public class_2371<class_1856> method_8117() {
		return this.raw.getIngredients();
	}

	public boolean matches(EffigyAltarRecipeInput input, class_1937 world) {
		return this.raw.matches(input);
	}

	public class_1799 craft(EffigyAltarRecipeInput input, class_7225.class_7874 wrapperLookup) {
		return this.result.method_7972();
	}

	public class_1799 result() {
		return this.result;
	}
	
	public OptionalInt getCost() {
		return cost;
	}
	
	public int getCostOrDefault() {
		return getCost().orElse(5);
	}
	
	public Optional<Integer> getBoxedCost() {
		return cost.stream().boxed().findFirst();
	}

	public static class Serializer implements class_1865<EffigyAltarRecipe> {
		public static final MapCodec<EffigyAltarRecipe> CODEC = RecordCodecBuilder.mapCodec(
			instance -> instance.group(
					Codec.STRING.optionalFieldOf("group", "").forGetter(recipe -> recipe.group),
					RawRecipe.CODEC.forGetter(recipe -> recipe.raw),
					class_1799.field_51397.fieldOf("result").forGetter(recipe -> recipe.result),
					Codec.INT.optionalFieldOf("cost").forGetter(EffigyAltarRecipe::getBoxedCost)
				)
				.apply(instance, EffigyAltarRecipe::new)
		);
		public static final class_9139<class_9129, EffigyAltarRecipe> PACKET_CODEC = class_9139.method_56437(
				EffigyAltarRecipe.Serializer::write, EffigyAltarRecipe.Serializer::read
		);

		@Override
		public MapCodec<EffigyAltarRecipe> method_53736() {
			return CODEC;
		}

		@Deprecated
		@Override
		public class_9139<class_9129, EffigyAltarRecipe> method_56104() {
			return PACKET_CODEC;
		}

		private static EffigyAltarRecipe read(class_9129 buf) {
			String string = buf.method_19772();
			RawRecipe rawRecipe = RawRecipe.PACKET_CODEC.decode(buf);
			class_1799 result = class_1799.field_48349.decode(buf);
			Optional<Integer> cost = class_9135.method_56382(class_9135.field_49675).decode(buf);
			return new EffigyAltarRecipe(string, rawRecipe, result, cost);
		}

		private static void write(class_9129 buf, EffigyAltarRecipe recipe) {
			buf.method_10814(recipe.group);
			RawRecipe.PACKET_CODEC.encode(buf, recipe.raw);
			class_1799.field_48349.encode(buf, recipe.result);
			class_9135.method_56382(class_9135.field_49675).encode(buf, recipe.getBoxedCost());
		}
	}
	

	public static final class RawRecipe {
		private static final int MAX_WIDTH_AND_HEIGHT = 3;
		private static final int MAX_WIDTH_END = 1;
		public static final char SPACE = ' ';
		public static final MapCodec<RawRecipe> CODEC = RawRecipe.Data.CODEC
			.flatXmap(
				RawRecipe::fromData,
				recipe -> (DataResult<RawRecipe.Data>)recipe.data.map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Cannot encode unpacked recipe"))
			);
		public static final class_9139<class_9129, RawRecipe> PACKET_CODEC = class_9139.method_56438(RawRecipe::writeToBuf, RawRecipe::readFromBuf);

		private void writeToBuf(class_9129 buf) {
			for (class_1856 ingredient : this.ingredients) {
				class_1856.field_48355.encode(buf, ingredient);
			}
		}

		private static RawRecipe readFromBuf(class_9129 buf) {
			class_2371<class_1856> defaultedList = class_2371.method_10213((MAX_WIDTH_AND_HEIGHT * MAX_WIDTH_AND_HEIGHT) - MAX_WIDTH_END, class_1856.field_9017);
			defaultedList.replaceAll(ingredient -> class_1856.field_48355.decode(buf));
			return new RawRecipe(defaultedList, Optional.empty());
		}
		
		private final class_2371<class_1856> ingredients;
		private final Optional<RawRecipe.Data> data;
		private final int ingredientCount;
		private final class_1856 brimstone;
	
		public RawRecipe(class_2371<class_1856> ingredients, Optional<RawRecipe.Data> data) {
			this.ingredients = ingredients;
			brimstone = getBrimstone();
			ingredients.set(MAX_WIDTH_END + ((MAX_WIDTH_AND_HEIGHT - MAX_WIDTH_END) * MAX_WIDTH_AND_HEIGHT), brimstone);
			this.data = data;
			this.ingredientCount = (int)ingredients.stream().count();
		}
	
		private static RawRecipe create(class_2371<class_1856> ingredients) {
			return new RawRecipe(ingredients, Optional.empty());
		}
	
		public static RawRecipe create(Map<Character, class_1856> key, String... pattern) {
			return create(key, List.of(pattern));
		}
	
		public static RawRecipe create(Map<Character, class_1856> key, List<String> pattern) {
			RawRecipe.Data data = new RawRecipe.Data(key, pattern);
			return fromData(data).getOrThrow();
		}
	
		private static DataResult<RawRecipe> fromData(RawRecipe.Data data) {
			String[] strings = removePadding(data.pattern);
			int i = strings[0].length();
			int j = strings.length;
			class_2371<class_1856> defaultedList = class_2371.method_10213(i * j - MAX_WIDTH_END, class_1856.field_9017);
			CharSet charSet = new CharArraySet(data.key.keySet());

			for (int k = 0; k < strings.length; k++) {
				String string = strings[k];

				for (int l = 0; l < string.length(); l++) {
					char c = string.charAt(l);
					class_1856 ingredient = c == ' ' ? class_1856.field_9017 : (class_1856)data.key.get(c);
					if (ingredient == null) {
						return DataResult.error(() -> "Pattern references symbol '" + c + "' but it's not defined in the key");
					}

					charSet.remove(c);
					PeacefulMod.LOGGER.info("" + (l + i * k));
					defaultedList.set(l + i * k, ingredient);
				}
			}
	
			return !charSet.isEmpty()
				? DataResult.error(() -> "Key defines symbols that aren't used in pattern: " + charSet)
				: DataResult.success(new RawRecipe(defaultedList, Optional.of(data)));
		}
	
		/**
		 * Removes empty space from around the recipe pattern.
		 * 
		 * <p>Turns patterns such as:
		 * <pre>
		 * {@code
		 * "   o"
		 * "   a"
		 * "	"
		 * }
		 * </pre>
		 * Into:
		 * <pre>
		 * {@code
		 * "o"
		 * "a"
		 * }
		 * </pre>
		 * 
		 * @return a new recipe pattern with all leading and trailing empty rows/columns removed
		 */
		@VisibleForTesting
		static String[] removePadding(List<String> pattern) {
			// Trim each line
			List<String> trimmedLines = pattern.stream()
				.map(String::trim)
				.toList();

			// Remove leading empty lines
			int start = 0;
			while (start < trimmedLines.size() && trimmedLines.get(start).isEmpty()) {
				start++;
			}

			// Remove trailing empty lines
			int end = trimmedLines.size();
			while (end > start && trimmedLines.get(end - 1).isEmpty()) {
				end--;
			}

			// Return the cleaned pattern
			return trimmedLines.subList(start, end).toArray(new String[0]);
		}
	
		public boolean matches(EffigyAltarRecipeInput input) {
			if (input.getStackCount() != this.ingredientCount) {
				return false;
			} else {
				for (int i = 0; i < MAX_WIDTH_AND_HEIGHT; i++) {
					final int fi = i + 1;
					if (fi == MAX_WIDTH_AND_HEIGHT) {
						class_1856 ingredient = this.ingredients.get(i * MAX_WIDTH_AND_HEIGHT);

						class_1799 itemStack = input.getStackInSlot(0, i);
						if (!ingredient.method_8093(itemStack)) {
							return false;
						}

						if (!brimstone.method_8093(input.getStackInSlot(1, i))) {
							return false;
						}
					}
					else {
						for (int j = 0; j < MAX_WIDTH_AND_HEIGHT; j++) {
							class_1856 ingredient = this.ingredients.get(j + i * MAX_WIDTH_AND_HEIGHT);

							class_1799 itemStack = input.getStackInSlot(j, i);
							if (!ingredient.method_8093(itemStack)) {
								return false;
							}
						}
					}
				}
		
				return true;
			}
		}
	
		public class_2371<class_1856> getIngredients() {
			return this.ingredients;
		}
	
		public record Data(Map<Character, class_1856> key, List<String> pattern) {
			private static final Codec<List<String>> PATTERN_CODEC = Codec.STRING.listOf().comapFlatMap(pattern -> {
				if (pattern.size() > MAX_WIDTH_AND_HEIGHT) {
					return DataResult.error(() -> "Invalid pattern: too many rows, 3 is maximum");
				} else if (pattern.isEmpty()) {
					return DataResult.error(() -> "Invalid pattern: empty pattern not allowed");
				} else {
					for (int i = 0; i < pattern.size(); i++) {
						final int fi = i + 1;
						String string = pattern.get(i);
						int length = string.length();
						if (fi == MAX_WIDTH_AND_HEIGHT) { // is end
							if (length > MAX_WIDTH_END) {
								return DataResult.error(() -> "Invalid pattern: too many columns for row #" + fi + ", 1 is maximum and minimum");
							}
							else if (length < MAX_WIDTH_END) {
								return DataResult.error(() -> "Invalid pattern: too little columns for row #" + fi + ", 1 is maximum and minimum");
							}
						}
						else {
							if (length > MAX_WIDTH_AND_HEIGHT) {
								return DataResult.error(() -> "Invalid pattern: too many columns for row #" + fi + ", 3 is maximum and minimum");
							}
							else if (length < MAX_WIDTH_AND_HEIGHT) {
								return DataResult.error(() -> "Invalid pattern: too little columns for row #" + fi + ", 3 is maximum and minimum");
							}
						}
					}
	
					return DataResult.success(pattern);
				}
			}, Function.identity());
			private static final Codec<Character> KEY_ENTRY_CODEC = Codec.STRING.comapFlatMap(keyEntry -> {
				if (keyEntry.length() != 1) {
					return DataResult.error(() -> "Invalid key entry: '" + keyEntry + "' is an invalid symbol (must be 1 character only).");
				} else {
					return " ".equals(keyEntry) ? DataResult.error(() -> "Invalid key entry: ' ' is a reserved symbol.") : DataResult.success(keyEntry.charAt(0));
				}
			}, String::valueOf);
			public static final MapCodec<RawRecipe.Data> CODEC = RecordCodecBuilder.mapCodec(
				instance -> instance.group(
						class_5699.method_53703(KEY_ENTRY_CODEC, class_1856.field_46096).fieldOf("key").forGetter(data -> data.key),
						PATTERN_CODEC.fieldOf("pattern").forGetter(data -> data.pattern)
					)
					.apply(instance, RawRecipe.Data::new)
			);
		}
	}

	public static class_1856 getBrimstone() {
		return class_1856.method_8091(PeacefulModItems.SULPHUR);
	}
	
	public static Optional<class_1856> getBrimstoneOptional() {
		return Optional.of(getBrimstone());
	}

	@Override
	public boolean method_8113(int width, int height) {
		if (width == RawRecipe.MAX_WIDTH_AND_HEIGHT) {
			return height <= RawRecipe.MAX_WIDTH_AND_HEIGHT - RawRecipe.MAX_WIDTH_END;
		}
		else {
			return width >= RawRecipe.MAX_WIDTH_AND_HEIGHT && height >= RawRecipe.MAX_WIDTH_AND_HEIGHT;
		}
	}

	@Override
	public class_1799 method_8110(class_7874 registriesLookup) {
		return result();
	}
}