package xen42.peacefulitems.recipe;

import java.util.List;
import net.minecraft.class_1262;
import net.minecraft.class_1657;
import net.minecraft.class_1662;
import net.minecraft.class_1799;
import net.minecraft.class_8566;
import xen42.peacefulitems.screen.EffigyAltarScreenHandler;

public class EffigyAltarRecipeInput implements class_8566 {
	private static final int MAX_WIDTH_AND_HEIGHT = 3;
	private final List<class_1799> stacks;
	private final class_1662 matcher = new class_1662();
	private final int stackCount;
	private final EffigyAltarScreenHandler handler;

	private EffigyAltarRecipeInput(EffigyAltarScreenHandler handler, List<class_1799> stacks) {
		this.handler = handler;
		this.stacks = stacks;
		int i = 0;

		for (class_1799 itemStack : stacks) {
			if (!itemStack.method_7960()) {
				i++;
				this.matcher.method_20478(itemStack, 1);
			}
		}

		this.stackCount = i;
	}

	public static EffigyAltarRecipeInput create(EffigyAltarScreenHandler handler, List<class_1799> stacks) {
		return new EffigyAltarRecipeInput(handler, stacks);
	}

	public class_1799 getStackInSlot(int slot) {
		return (class_1799)this.stacks.get(slot);
	}

	public class_1799 getStackInSlot(int x, int y) {
		return (class_1799)this.stacks.get(x + y * MAX_WIDTH_AND_HEIGHT);
	}

	public int method_5439() {
		return this.stacks.size();
	}

	@Override
	public boolean method_5442() {
		return this.stackCount == 0;
	}

	public class_1662 getRecipeMatcher() {
		return this.matcher;
	}

	public List<class_1799> getStacks() {
		return this.stacks;
	}

	public int getStackCount() {
		return this.stackCount;
	}
	
	public static boolean stacksEqual(List<class_1799> left, List<class_1799> right) {
		if (left.size() != right.size()) {
			return false;
		} else {
			for (int i = 0; i < left.size(); i++) {
				if (!class_1799.method_7973((class_1799)left.get(i), (class_1799)right.get(i))) {
					return false;
				}
			}

			return true;
		}
	}

	public boolean equals(Object o) {
		if (o == this) {
			return true;
		} else {
			return !(o instanceof EffigyAltarRecipeInput effigyAltarRecipeInput)
				? false
				: this.stackCount == effigyAltarRecipeInput.stackCount
					&& stacksEqual(this.stacks, effigyAltarRecipeInput.stacks);
		}
	}

	public int hashCode() {
		int i = 0;
		
		for (class_1799 itemStack : this.stacks) {
			i = i * 31 + class_1799.method_57355(itemStack);
		}

		return i;
	}

	public int getSize() {
		return method_5439();
	}

	@Override
	public class_1799 method_5438(int slot) {
		return slot >= this.method_5439() ? class_1799.field_8037 : this.stacks.get(slot);
	}

	@Override
	public class_1799 method_5441(int slot) {
		return class_1262.method_5428(this.stacks, slot);
	}

	@Override
	public class_1799 method_5434(int slot, int amount) {
		class_1799 itemStack = class_1262.method_5430(this.stacks, slot, amount);
		if (!itemStack.method_7960()) {
			this.handler.method_7609(this);
		}

		return itemStack;
	}

	@Override
	public void method_5447(int slot, class_1799 stack) {
		this.stacks.set(slot, stack);
		this.handler.method_7609(this);
	}

	@Override
	public void method_5431() {
	}

	@Override
	public boolean method_5443(class_1657 player) {
		return true;
	}

	@Override
	public void method_5448() {
		getStacks().clear();
	}

	@Override
	public void method_7683(class_1662 finder) {
		for (class_1799 itemStack : getStacks()) {
			finder.method_7404(itemStack);
		}
	}

	@Override
	public int method_17398() {
		return MAX_WIDTH_AND_HEIGHT;
	}

	@Override
	public int method_17397() {
		return MAX_WIDTH_AND_HEIGHT;
	}

	@Override
	public List<class_1799> method_51305() {
		return List.copyOf(getStacks());
	}
}
