package xen42.peacefulitems.recipe;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2119;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_8782;
import net.minecraft.class_8790;
import xen42.peacefulitems.PeacefulMod;

import org.jetbrains.annotations.Nullable;

public class EffigyAltarRecipeJsonBuilder implements class_5797 {
	private static final int MAX_WIDTH_AND_HEIGHT = 3;
	private static final int MAX_WIDTH_END = 1;
	public static final String SPACE = " ";
	class_2960 ROOT = class_2960.method_43902("minecraft","recipes/root");
	private final class_1792 output;
	private final int count;
	private final List<String> pattern = Lists.<String>newArrayList();
	private final Map<Character, class_1856> inputs = Maps.<Character, class_1856>newLinkedHashMap();
	private final Map<String, class_175<?>> criteria = new LinkedHashMap<String, class_175<?>>();
	private OptionalInt cost = OptionalInt.empty();
	@Nullable
	private String group;

	private final class_7871<class_1792> registryLookup;

	private EffigyAltarRecipeJsonBuilder(class_7871<class_1792> registryLookup, class_1935 output, int count) {
		this.registryLookup = registryLookup;
		this.output = output.method_8389();
		this.count = count;
	}

	public static EffigyAltarRecipeJsonBuilder create(class_7871<class_1792> registryLookup, class_1935 output) {
		return create(registryLookup, output, 1);
	}

	public static EffigyAltarRecipeJsonBuilder create(class_7871<class_1792> registryLookup, class_1935 output, int count) {
		return new EffigyAltarRecipeJsonBuilder(registryLookup, output, count);
	}

	public EffigyAltarRecipeJsonBuilder input(Character c, class_6862<class_1792> tag) {
		return this.input(c, class_1856.method_8106(tag));
	}

	public EffigyAltarRecipeJsonBuilder input(Character c, class_1935 item) {
		return this.input(c, class_1856.method_8091(item));
	}

	public EffigyAltarRecipeJsonBuilder input(Character c, class_1856 ingredient) {
		if (this.inputs.containsKey(c)) {
			throw new IllegalArgumentException("Symbol '" + c + "' is already defined!");
		} else if (c == ' ') {
			throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
		} else {
			this.inputs.put(c, ingredient);
			return this;
		}
	}

	public EffigyAltarRecipeJsonBuilder pattern(String patternStr1, String patternStr2, String patternStr3) {
		if (!this.pattern.isEmpty()) {
			throw new IllegalStateException("Already added pattern!");
		}
		else if (patternStr1.isEmpty() || patternStr2.isEmpty() || patternStr3.isEmpty()) {
			throw new IllegalArgumentException("Pattern must not be empty!");
		}
		else if (patternStr1.length() != MAX_WIDTH_AND_HEIGHT) {
			throw new IllegalArgumentException("Pattern #1 must have a width of 3!");
		}
		else if (patternStr2.length() != MAX_WIDTH_AND_HEIGHT) {
			throw new IllegalArgumentException("Pattern #2 must have a width of 3!");
		}
		else if (patternStr3.length() != MAX_WIDTH_END) {
			throw new IllegalArgumentException("Pattern #3 must have a width of 1!");
		}
		else if (patternStr1.contains(SPACE) || patternStr2.contains(SPACE) || patternStr3.contains(SPACE)) {
			throw new IllegalArgumentException("Pattern must not have empty spaces!");
		}
		else {
			this.pattern.add(patternStr1);
			this.pattern.add(patternStr2);
			this.pattern.add(patternStr3);
			return this;
		}
	}

	public EffigyAltarRecipeJsonBuilder method_33530(String string, class_175<?> advancementCriterion) {
		this.criteria.put(string, advancementCriterion);
		return this;
	}

	public EffigyAltarRecipeJsonBuilder cost(int cost) {
		if (cost > 0) {
			this.cost = OptionalInt.of(cost);
		} else {
			this.cost = OptionalInt.empty();
		}
		return this;
	}

	public EffigyAltarRecipeJsonBuilder method_33529(@Nullable String string) {
		this.group = string;
		return this;
	}

	public class_1792 method_36441() {
		return this.output;
	}

	@Override
	public void method_17972(class_8790 exporter, class_2960 recipeId) {
		EffigyAltarRecipe.RawRecipe rawRecipe = this.validate(recipeId);
		class_161.class_162 builder = exporter.method_53818()
			.method_705("has_the_recipe", class_2119.method_27847(recipeId))
			.method_703(class_170.class_171.method_753(recipeId))
			.method_704(class_8782.class_8797.field_1257);
		this.criteria.forEach(builder::method_705);
		EffigyAltarRecipe recipe = new EffigyAltarRecipe(
			(String)Objects.requireNonNullElse(this.group, ""),
			rawRecipe,
			new class_1799(this.output, this.count),
			this.cost
		);
		exporter.method_53819(recipeId, recipe, builder.method_695(recipeId.method_45138("recipes/effigy_altar/")));
	}

	public void offerTo(class_8790 exporter, class_5321<class_1860<?>> recipeKey) {
		method_17972(exporter, recipeKey.method_29177());
	}

	private EffigyAltarRecipe.RawRecipe validate(class_2960 recipeId) {
		if (this.criteria.isEmpty()) {
			throw new IllegalStateException("No way of obtaining recipe " + recipeId);
		} else {
			return EffigyAltarRecipe.RawRecipe.create(this.inputs, this.pattern);
		}
	}
	
	public void method_10431(class_8790 exporter) {
		this.method_17972(exporter, method_36442(this.method_36441()));
	}

	public void method_36443(class_8790 exporter, String recipePath) {
		class_2960 identifier = method_36442(this.method_36441());
		class_2960 identifier2 = class_2960.method_43902(PeacefulMod.MOD_ID, recipePath);
		if (identifier2.equals(identifier)) {
			throw new IllegalStateException("Recipe " + recipePath + " should remove its 'save' argument as it is equal to default one");
		} else {
			this.method_17972(exporter, identifier2);
		}
	}

	public static class_2960 method_36442(class_1935 item) {
		return class_2960.method_43902(PeacefulMod.MOD_ID, class_7923.field_41178.method_10221(item.method_8389()).method_12832());
	}
}
