package xen42.peacefulitems.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1662;
import net.minecraft.class_1703;
import net.minecraft.class_1729;
import net.minecraft.class_1731;
import net.minecraft.class_1732;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2653;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_5421;
import net.minecraft.class_8566;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;

import com.google.common.collect.Lists;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import xen42.peacefulitems.PeacefulMod;
import xen42.peacefulitems.PeacefulModBlocks;
import xen42.peacefulitems.PeacefulModItems;
import xen42.peacefulitems.recipe.EffigyAltarRecipe;
import xen42.peacefulitems.recipe.EffigyAltarRecipeInput;

public class EffigyAltarScreenHandler extends class_1729<EffigyAltarRecipeInput> {

    public static final int OUTPUT_SLOT = 0;
    public static final int INPUT_SLOTS_START = 1;
    public static final int INPUT_SLOTS_END = 7;
    public static final int BRIMSTONE_SLOT = 8;
    public static final int MAX_WIDTH_AND_HEIGHT = 3;
    public static final int MAX_WIDTH_END = 1;
    public static final int INVENTORY_SLOTS_START = 9;
    public static final int INVENTORY_SLOTS_END = 35;
    public static final int HOTBAR_SLOTS_START = 36;
    public static final int HOTBAR_SLOTS_END = 45;

    public final class_8566 inventory;
    private final class_1731 resultInventory;
    private final class_3915 levelCost = class_3915.method_17403();

    public class_3914 context;
    private final class_1657 player;

    public boolean canTake(int xpCost) {
        return (player.method_56992() || player.field_7520 >= xpCost) && xpCost > 0;
    }

    public boolean canTake() {
        return canTake(getOutputXPCost());
    }

    public boolean hasOutput() {
        return _outputSlot.method_7681();
    }
    
    public int getXPCost(class_3218 serverWorld, List<class_1799> input) {
        EffigyAltarRecipeInput recipeInput = EffigyAltarRecipeInput.create(this, input);
        Optional<class_8786<EffigyAltarRecipe>> optional = serverWorld.method_8433().method_8132(PeacefulMod.EFFIGY_ALTAR_RECIPE_TYPE, recipeInput, serverWorld);
        if (optional.isPresent()) {
            class_8786<EffigyAltarRecipe> recipeEntry = (class_8786<EffigyAltarRecipe>)optional.get();
            EffigyAltarRecipe altarRecipe = recipeEntry.comp_1933();
            return altarRecipe.getCostOrDefault();
        }
        return 0;
    }

    public int getOutputXPCost() {
        return levelCost.method_17407();
    }

    @SuppressWarnings("unused")
    private class_1735[] _slots;
    private class_1735 _outputSlot;
    private class_1735 _brimstoneSlot;
    
    private boolean filling;

    public EffigyAltarScreenHandler(int syncId, class_1661 playerInventory){
        this(syncId, playerInventory, class_3914.field_17304);
    }

    public EffigyAltarScreenHandler(int syncId, class_1661 playerInventory, class_3914 context) {
        super(PeacefulMod.EFFIGY_ALTAR_SCREEN_HANDLER, syncId);
        this.inventory = new EffigySimpleInventory(this, BRIMSTONE_SLOT);
        this.resultInventory = new EffigyCraftingResultInventory(this);
        this.method_17362(this.levelCost);
        this.context = context;
        this.player = playerInventory.field_7546;

        _outputSlot = this.method_7621(new OutputSlot(this, this.player, this.inventory, this.resultInventory, 0, 132, 29 - 8));
        
        _slots = new class_1735[] {
            this.method_7621(new CustomSlot(this, this.inventory, 0, 22, 17)),
            this.method_7621(new CustomSlot(this, this.inventory, 1, 40, 17)),
            this.method_7621(new CustomSlot(this, this.inventory, 2, 58, 17)),
            this.method_7621(new CustomSlot(this, this.inventory, 3, 22, 35)),
            this.method_7621(new CustomSlot(this, this.inventory, 4, 40, 35)),
            this.method_7621(new CustomSlot(this, this.inventory, 5, 58, 35)),
            this.method_7621(new CustomSlot(this, this.inventory, 6, 40, 53))
        };
        
        _brimstoneSlot = this.method_7621(new BrimstoneSlot(this, this.inventory, 7, 89, 53 - 8));

        this.addPlayerSlots(playerInventory, 8, 84);
    }
    
    protected void addPlayerHotbarSlots(class_1263 playerInventory, int left, int y) {
        for (int i = 0; i < 9; i++) {
            this.method_7621(new class_1735(playerInventory, i, left + i * 18, y));
        }
    }

    protected void addPlayerInventorySlots(class_1263 playerInventory, int left, int top) {
        for (int i = 0; i < 3; i++) {
            for (int j = 0; j < 9; j++) {
                this.method_7621(new class_1735(playerInventory, j + (i + 1) * 9, left + j * 18, top + i * 18));
            }
        }
    }

    protected void addPlayerSlots(class_1263 playerInventory, int left, int top) {
        this.addPlayerInventorySlots(playerInventory, left, top);
        this.addPlayerHotbarSlots(playerInventory, left, top + 58);
    }
    
    public static boolean isBrimstone(class_1799 stack) {
        return stack.method_31574(PeacefulModItems.SULPHUR);
    }
    
    public static boolean isAir(class_1799 stack) {
        return stack.method_31574(class_1802.field_8162);
    }
    
    public void updateResult(
        class_3218 world,
        @Nullable class_8786<EffigyAltarRecipe> recipe
    ) {
        EffigyAltarRecipeInput recipeInput = EffigyAltarRecipeInput.create(this, inventory.method_51305());
        class_3222 serverPlayerEntity = (class_3222)player;
        class_1799 resultStack = class_1799.field_8037;
        int cost = 0;
        
        if (isBrimstone(_brimstoneSlot.method_7677())) {
            Optional<class_8786<EffigyAltarRecipe>> optional = world.method_8503().method_3772().method_8132(PeacefulMod.EFFIGY_ALTAR_RECIPE_TYPE, recipeInput, world);
            if (optional.isPresent()) {
                class_8786<EffigyAltarRecipe> recipeEntry = (class_8786<EffigyAltarRecipe>)optional.get();
                EffigyAltarRecipe altarRecipe = recipeEntry.comp_1933();
                boolean shouldCraftRecipe = resultInventory.method_7665(world, serverPlayerEntity, recipeEntry);
                if (shouldCraftRecipe) {
                    class_1799 craftedStack = altarRecipe.craft(recipeInput, world.method_30349());
                    boolean isItemEnabled = craftedStack.method_45435(world.method_45162());
                    if (isItemEnabled) {
                        resultStack = craftedStack;
                        cost = altarRecipe.getCostOrDefault();
                    }
                }
            }
        }

        levelCost.method_17404(cost);
        resultInventory.method_5447(0, resultStack);
        this.method_34245(0, resultStack);
        serverPlayerEntity.field_13987.method_14364(new class_2653(this.field_7763, this.method_37422(), 0, resultStack));
    }

    @Override
    public void method_7609(class_1263 inventory) {
        if (!this.filling) {
            this.context.method_17393((world, pos) -> {
                if (world instanceof class_3218 serverWorld) {
                    updateResult(serverWorld, null);
                }
            });
        }
    }

    @Override
    public class_1799 method_7601(class_1657 player, int slot) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 slotAtIndex = this.field_7761.get(slot);
        if (slotAtIndex != null && slotAtIndex.method_7681() && slotAtIndex.method_7674(player)) {
            class_1799 itemStackAtIndex = slotAtIndex.method_7677();
            itemStack = itemStackAtIndex.method_7972();
            if (slot == OUTPUT_SLOT) {
                itemStackAtIndex.method_7909().method_54465(itemStackAtIndex, player.method_37908(), player);
                if (!this.method_7616(itemStackAtIndex, INVENTORY_SLOTS_START, HOTBAR_SLOTS_END, true)) {
                    return class_1799.field_8037;
                }

                slotAtIndex.method_7670(itemStackAtIndex, itemStack);
            } else if (slot >= INVENTORY_SLOTS_START && slot < HOTBAR_SLOTS_END) {
                if (!this.method_7616(itemStackAtIndex, INPUT_SLOTS_START, INVENTORY_SLOTS_START, false)) {
                    if (slot < HOTBAR_SLOTS_START) {
                        if (!this.method_7616(itemStackAtIndex, HOTBAR_SLOTS_START, HOTBAR_SLOTS_END, false)) {
                            return class_1799.field_8037;
                        }
                    } else if (!this.method_7616(itemStackAtIndex, INVENTORY_SLOTS_START, HOTBAR_SLOTS_START, false)) {
                        return class_1799.field_8037;
                    }
                }
            } else if (!this.method_7616(itemStackAtIndex, INVENTORY_SLOTS_START, HOTBAR_SLOTS_END, false)) {
                return class_1799.field_8037;
            }

            if (itemStackAtIndex.method_7960()) {
                slotAtIndex.method_53512(class_1799.field_8037);
            } else {
                slotAtIndex.method_7668();
            }

            if (itemStackAtIndex.method_7947() == itemStack.method_7947()) {
                return class_1799.field_8037;
            }

            slotAtIndex.method_7667(player, itemStackAtIndex);
            if (slot == OUTPUT_SLOT) {
                player.method_7328(itemStackAtIndex, false);
            }
        }

        return itemStack;
    }

    @Override
    public boolean method_7597(class_1657 player) {
        return method_17695(this.context, player, PeacefulModBlocks.EFFIGY_ALTAR);
    }

    @Override
    public boolean method_32339(int index) {
        return index != this.method_7655();
    }

    @Override
    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.context.method_17393((world, pos) -> this.method_7607(player, this.inventory));
    }

    @Override
    public void method_7654(class_1662 finder) {
        this.inventory.method_7683(finder);
    }

    @Override
    public class_5421 method_30264() {
        return class_5421.field_25763; // Return crafting because making a RecipeBookCategory is impossible.
    }

    public void onInputSlotFillStart() {
        this.filling = true;
    }

    public void onInputSlotFillFinish(class_3218 world, class_8786<EffigyAltarRecipe> recipe) {
        this.filling = false;
        updateResult(world, recipe);
    }

    public class_1735 getBrimstoneSlot() {
        return this._brimstoneSlot;
    }

    public class_1735 getOutputSlot() {
        return this._outputSlot;
    }

    public List<class_1735> getInputSlots() {
        return this.field_7761.subList(INPUT_SLOTS_START, BRIMSTONE_SLOT);
    }

    public class_1657 getPlayer() {
        return this.player;
    }

    @Override
    public int method_7655() {
        return OUTPUT_SLOT;
    }

    @Override
    public int method_7653() {
        return MAX_WIDTH_AND_HEIGHT;
    }

    @Override
    public int method_7656() {
        return MAX_WIDTH_AND_HEIGHT;
    }

    @Override
    public int method_7658() {
        return BRIMSTONE_SLOT;
    }

    @Override
    public void method_7657() {
        this.inventory.method_5448();
        this.resultInventory.method_5448();
    }

    @Override
    public boolean method_7652(class_8786<? extends class_1860<EffigyAltarRecipeInput>> recipe) {
    	EffigyAltarRecipe recipeValue = (EffigyAltarRecipe)recipe.comp_1933();
        return recipeValue.matches(EffigyAltarRecipeInput.create(this, this.inventory.method_51305()), this.player.method_37908());
    }
    
    private class EffigySimpleInventory extends class_1277 implements class_8566 {
        private class_1703 _screen;
        EffigySimpleInventory(EffigyAltarScreenHandler screen, int size) {
            super(size);
            _screen = screen;
        }

        public void method_5431() {
            _screen.method_7609(this);
            super.method_5431();
        }

        @Override
        public int method_17398() {
            return MAX_WIDTH_AND_HEIGHT;
        }

        @Override
        public int method_17397() {
            return MAX_WIDTH_AND_HEIGHT;
        }
    }

    private class EffigyCraftingResultInventory extends class_1731 {
        private class_1703 _screen;
        EffigyCraftingResultInventory(EffigyAltarScreenHandler screen) {
            super();
            _screen = screen;
        }

        public void method_5431() {
            _screen.method_7609(this);
            super.method_5431();
        }
    }

    private class CustomSlot extends class_1735 {
        private EffigyAltarScreenHandler _altar;
        public CustomSlot(EffigyAltarScreenHandler altar, class_1263 inventory, int index, int x, int y) {
            super(inventory, index, x, y);
            _altar = altar;
        }

        @Override
        public void method_7668() {
            super.method_7668();
            _altar.method_7609(_altar.inventory);
        }

        @Override
        public boolean method_7680(class_1799 stack) {
            return !isBrimstone(stack);
        }
    }

    private class BrimstoneSlot extends CustomSlot {
        public BrimstoneSlot(EffigyAltarScreenHandler altar, class_1263 inventory, int index, int x, int y) {
            super(altar, inventory, index, x, y);
        }

        @Override
        public boolean method_7680(class_1799 stack) {
            return isAir(stack) || isBrimstone(stack);
        }
    }

    private class OutputSlot extends class_1735 {
        private final class_8566 input;
        private final class_1657 player;
        private final EffigyAltarScreenHandler handler;
        private int amount;
        public OutputSlot(EffigyAltarScreenHandler handler, class_1657 player, class_8566 input, class_1263 inventory, int index, int x, int y) {
            super(inventory, index, x, y);
            this.player = player;
            this.input = input;
            this.handler = handler;
        }

        @Override
        public boolean method_7680(class_1799 stack) {
            return false;
        }

        @Override
        public boolean method_7674(class_1657 player) {
            return handler.canTake();
        }

        @Override
        public class_1799 method_7671(int amount) {
            if (this.method_7681()) {
                this.amount = this.amount + Math.min(amount, this.method_7677().method_7947());
            }

            return super.method_7671(amount);
        }

        @Override
        protected void method_7678(class_1799 stack, int amount) {
            this.amount += amount;
            this.method_7669(stack);
        }

        @Override
        protected void method_7672(int amount) {
            this.amount += amount;
        }

        @Override
        protected void method_7669(class_1799 stack) {
            if (this.amount > 0) {
                stack.method_7982(this.player.method_37908(), this.player, this.amount);
            }

            if (this.field_7871 instanceof class_1732 recipeUnlocker) {
                recipeUnlocker.method_7664(this.player, this.input.method_51305());
            }

            this.amount = 0;
        }

        private static class_2371<class_1799> copyInput(EffigyAltarRecipeInput input) {
            class_2371<class_1799> defaultedList = class_2371.method_10213(input.method_5439(), class_1799.field_8037);

            for (int i = 0; i < defaultedList.size(); i++) {
                defaultedList.set(i, input.getStackInSlot(i));
            }

            return defaultedList;
        }

        private class_2371<class_1799> getRecipeRemainders(EffigyAltarRecipeInput input, class_1937 world) {
            return world instanceof class_3218 serverWorld
                ? (class_2371<class_1799>)serverWorld.method_8433()
                    .method_8132(PeacefulMod.EFFIGY_ALTAR_RECIPE_TYPE, input, serverWorld)
                    .map(recipe -> ((EffigyAltarRecipe)recipe.comp_1933()).getRecipeRemainders(input))
                    .orElseGet(() -> copyInput(input))
                : EffigyAltarRecipe.collectRecipeRemainders(input);
        }

        @Override
        public void method_7667(class_1657 player, class_1799 stack) {
            this.method_7669(stack);
            EffigyAltarRecipeInput recipeInput = EffigyAltarRecipeInput.create(this.handler, this.input.method_51305());
            class_2371<class_1799> defaultedList = this.getRecipeRemainders(recipeInput, player.method_37908());

            this.handler.context.method_17393((world, pos) -> {
                if (!player.method_56992()) {
                    player.method_7316(-getOutputXPCost());
                }
                world.method_45445((class_1297)null, pos, class_3417.field_15119, class_3419.field_15245, 1.0F, world.field_9229.method_43057() * 0.1F + 0.9F);
            });

            for (int y = 0; y < MAX_WIDTH_AND_HEIGHT; y++) {
                for (int x = 0; x < (y == MAX_WIDTH_AND_HEIGHT - 1 ? MAX_WIDTH_AND_HEIGHT - MAX_WIDTH_END : MAX_WIDTH_AND_HEIGHT); x++) {
                    int z = x + y * MAX_WIDTH_AND_HEIGHT;
                    class_1799 itemStack = this.input.method_5438(z);
                    class_1799 defaultStack = defaultedList.get(z);
                    if (!itemStack.method_7960()) {
                        this.input.method_5434(z, 1);
                        itemStack = this.input.method_5438(z);
                    }

                    if (!defaultStack.method_7960()) {
                        if (itemStack.method_7960()) {
                            this.input.method_5447(z, defaultStack);
                        } else if (class_1799.method_31577(itemStack, defaultStack)) {
                            defaultStack.method_7933(itemStack.method_7947());
                            this.input.method_5447(z, defaultStack);
                        } else if (!this.player.method_31548().method_7394(defaultStack)) {
                            this.player.method_7328(defaultStack, false);
                        }
                    }
                }
            }
        }

        @Override
        public boolean method_55059() {
            return true;
        }
    }


    private class EffigyAltarInputSlotFiller {
    }
}
