package xen42.peacefulitems;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleFactory;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleRegistry;
import net.fabricmc.fabric.api.loot.v3.LootTableEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.minecraft.class_10295;
import net.minecraft.class_10355;
import net.minecraft.class_117;
import net.minecraft.class_125;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_141;
import net.minecraft.class_1420;
import net.minecraft.class_1802;
import net.minecraft.class_1865;
import net.minecraft.class_1928;
import net.minecraft.class_1928.class_4310;
import net.minecraft.class_1928.class_5198;
import net.minecraft.class_1937;
import net.minecraft.class_1972;
import net.minecraft.class_2378;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3414;
import net.minecraft.class_3917;
import net.minecraft.class_3956;
import net.minecraft.class_44;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_5662;
import net.minecraft.class_6796;
import net.minecraft.class_77;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9169;
import xen42.peacefulitems.entities.EndClamEntity;
import xen42.peacefulitems.entities.GhastlingEntity;
import xen42.peacefulitems.payloads.EffigyParticlePayload;
import xen42.peacefulitems.payloads.GhostRecipeCostRequest;
import xen42.peacefulitems.payloads.GhostRecipeCostResponse;
import xen42.peacefulitems.recipe.EffigyAltarRecipe;
import xen42.peacefulitems.recipe.EffigyAltarRecipeDisplay;
import xen42.peacefulitems.screen.EffigyAltarScreenHandler;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeacefulMod implements ModInitializer {
	public static final String MOD_ID = "peaceful-items";

	// This logger is used to write text to the console and the log file.
	// It is considered best practice to use your mod id as the logger's name.
	// That way, it's clear which mod wrote info, warnings, and errors.
	public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);
	
	public static final class_5321<class_3195> EFFIGY_ALTAR_DUNGEON_KEY = class_5321.method_29179(class_7924.field_41246, class_2960.method_60655(MOD_ID, "effigy_altar_dungeon"));

	public static final class_5321<class_3956<?>> EFFIGY_ALTAR_RECIPE_TYPE_KEY = class_5321.method_29179(class_7924.field_41217, class_2960.method_60655(MOD_ID, "effigy_altar"));
	public static final class_3956<EffigyAltarRecipe> EFFIGY_ALTAR_RECIPE_TYPE = class_2378.method_10230(class_7923.field_41188, class_2960.method_60655(MOD_ID, "effigy_altar"), new class_3956<EffigyAltarRecipe>() {
		public String toString() {
			return "effigy_altar";
		}
	});
	public static final class_1865<EffigyAltarRecipe> EFFIGY_ALTAR_RECIPE_SERIALIZER = class_2378.method_10230(class_7923.field_41189, class_2960.method_60655(MOD_ID, "effigy_altar"), new EffigyAltarRecipe.Serializer());
	public static final class_10295.class_10296<EffigyAltarRecipeDisplay> EFFIGY_ALTAR_RECIPE_DISPLAY = class_2378.method_10230(class_7923.field_54874, class_2960.method_60655(MOD_ID, "effigy_altar"), EffigyAltarRecipeDisplay.SERIALIZER);
	public static final class_10355 EFFIGY_ALTAR_RECIPE_BOOK_CATEGORY = class_2378.method_10230(class_7923.field_54927, class_2960.method_60655(MOD_ID, "effigy_altar"), new class_10355() {
		public String toString() {
			return "EFFIGY_ALTAR";
		}
	});
	public static final class_5321<class_6796> FOSSIL_ORE_PLACED_KEY = class_5321.method_29179(class_7924.field_41245, class_2960.method_60655(MOD_ID,"fossil_ore"));
	public static final class_5321<class_6796> NETHER_FOSSIL_ORE_PLACED_KEY = class_5321.method_29179(class_7924.field_41245, class_2960.method_60655(MOD_ID,"nether_fossil_ore"));
	public static final class_5321<class_6796> SULPHUR_ORE_PLACED_KEY = class_5321.method_29179(class_7924.field_41245, class_2960.method_60655(MOD_ID,"sulphur_ore"));
	public static final class_5321<class_6796> SULPHUR_CLUSTER_FLOOR_PLACED_KEY = class_5321.method_29179(class_7924.field_41245, class_2960.method_60655(MOD_ID,"sulphur_cluster_patch_floor"));
	public static final class_5321<class_6796> SULPHUR_CLUSTER_CEILING_PLACED_KEY = class_5321.method_29179(class_7924.field_41245, class_2960.method_60655(MOD_ID,"sulphur_cluster_patch_ceiling"));
	public static final class_5321<class_6796> FLAX_PLACED_KEY = class_5321.method_29179(class_7924.field_41245, class_2960.method_60655(MOD_ID,"flax"));

	public static final class_2940<Integer> BAT_BREEDING_TICKS = class_2945.method_12791(class_1420.class, class_2943.field_13327);
	public static final class_2940<Boolean> BAT_IS_BABY = class_2945.method_12791(class_1420.class, class_2943.field_13323);
	public static final class_2940<Integer> BAT_BREEDING_COOLDOWN = class_2945.method_12791(class_1420.class, class_2943.field_13327);
	public static int BatGrowUpTicks = 5 * 60 * 20; // Normal mobs its 20 minutes but I feel like bats can grow up fast maybe idk!
	public static int BatBreedingCooldown = 5 * 60 * 20;

	public static final class_1928.class_4313<class_4310> ENABLE_ENDER_DRAGON_FIGHT_PEACEFUL =
		GameRuleRegistry.register("enableEnderDragonFightPeaceful", class_5198.field_24095, GameRuleFactory.createBooleanRule(false));
	public static final class_1928.class_4313<class_4310> ENABLE_SUPER_HEALING_PEACEFUL =
		GameRuleRegistry.register("enableSuperHealingPeaceful", class_5198.field_24094, GameRuleFactory.createBooleanRule(true));
	public static final class_1928.class_4313<class_4310> ENABLE_STARVING_PEACEFUL =
		GameRuleRegistry.register("enableStarvingPeaceful", class_5198.field_24094, GameRuleFactory.createBooleanRule(false));

	public static final class_5321<class_1299<?>> GHASTLING_ENTITY_KEY = class_5321.method_29179(class_7924.field_41266, class_2960.method_60655(MOD_ID,"ghastling"));
	public static final class_1299<GhastlingEntity> GHASTLING_ENTITY = class_2378.method_10230(
		class_7923.field_41177, 
		class_2960.method_60655(MOD_ID, "ghastling"), 
		class_1299.class_1300.method_5903(GhastlingEntity::new, class_1311.field_6303).method_17687(0.5f, 1.5f).method_5905(GHASTLING_ENTITY_KEY));

	public static final class_5321<class_1299<?>> END_CLAM_ENTITY_KEY = class_5321.method_29179(class_7924.field_41266, class_2960.method_60655(MOD_ID,"end_clam"));
	public static final class_1299<EndClamEntity> END_CLAM_ENTITY = class_2378.method_10230(
		class_7923.field_41177, 
		class_2960.method_60655(MOD_ID, "end_clam"), 
		class_1299.class_1300.method_5903(EndClamEntity::new, class_1311.field_6303).method_17687(0.5f, 0.3f).method_5905(END_CLAM_ENTITY_KEY));

	public static final class_2960 EFFIGY_PARTICLE_PAYLOAD = class_2960.method_60655(MOD_ID, "effigy_particle_payload");

	public static final class_3917<EffigyAltarScreenHandler> EFFIGY_ALTAR_SCREEN_HANDLER = class_2378.method_10230(
		class_7923.field_41187,
		class_2960.method_60655(MOD_ID, "effigy_altar"),
		new class_3917<EffigyAltarScreenHandler>(EffigyAltarScreenHandler::new, null));

	public static final class_3414 ITEM_BOTTLE_EMPTY_DRAGONBREATH = class_2378.method_10230(
		class_7923.field_41172,
		class_2960.method_60655(MOD_ID, "item.bottle.empty_dragonbreath"),
		class_3414.method_47908(class_2960.method_60655(MOD_ID, "item.bottle.empty_dragonbreath")));

	@Override
	public void onInitialize() {
		// This code runs as soon as Minecraft is in a mod-load-ready state.
		// However, some things (like resources) may still be uninitialized.
		// Proceed with mild caution.

		LOGGER.info("Loading Peaceful Mod!");

		PeacefulModItems.initialize();
		PeacefulModBlocks.initialize();
		PeacefulModFluids.initialize();
		PeacefulModVillagers.initialize();
		PeacefulModPotions.initialize();

		BiomeModifications.addFeature(BiomeSelectors.foundInOverworld(), class_2893.class_2895.field_13176, FOSSIL_ORE_PLACED_KEY);
		BiomeModifications.addFeature(BiomeSelectors.foundInTheNether(), class_2893.class_2895.field_13176, NETHER_FOSSIL_ORE_PLACED_KEY);
		BiomeModifications.addFeature(BiomeSelectors.foundInTheNether(), class_2893.class_2895.field_13176, SULPHUR_ORE_PLACED_KEY); 
		BiomeModifications.addFeature(BiomeSelectors.foundInTheNether(), class_2893.class_2895.field_13176, SULPHUR_CLUSTER_CEILING_PLACED_KEY); 
		BiomeModifications.addFeature(BiomeSelectors.foundInTheNether(), class_2893.class_2895.field_13176, SULPHUR_CLUSTER_FLOOR_PLACED_KEY); 
		BiomeModifications.addFeature(BiomeSelectors.includeByKey(class_1972.field_9451, class_1972.field_34470, class_1972.field_35116), class_2893.class_2895.field_13178, FLAX_PLACED_KEY);

		FabricDefaultAttributeRegistry.register(GHASTLING_ENTITY, GhastlingEntity.method_26828());
		FabricDefaultAttributeRegistry.register(END_CLAM_ENTITY, EndClamEntity.method_26828());
		
		// I don't know why but the SpawnGroup.CREATURES group had them never spawning
		// Ghastling further lowers its spawn area to fortresses in its own class
		var ghastlingBiomes = BiomeSelectors.foundInTheNether();
		var clamBiomes = BiomeSelectors.includeByKey(class_1972.field_22075).or(BiomeSelectors.foundInTheEnd());

		BiomeModifications.addSpawn(ghastlingBiomes, class_1311.field_6303, GHASTLING_ENTITY, 100, 2, 3);
		class_1317.method_20637(GHASTLING_ENTITY, class_9169.field_48745, class_2902.class_2903.field_13203, GhastlingEntity::isValidSpawn);

		BiomeModifications.addSpawn(clamBiomes, class_1311.field_6303, END_CLAM_ENTITY, 100, 1, 1);
		class_1317.method_20637(END_CLAM_ENTITY, class_9169.field_48745, class_2902.class_2903.field_13203, EndClamEntity::isValidSpawn);

		PayloadTypeRegistry.playS2C().register(EffigyParticlePayload.ID, EffigyParticlePayload.CODEC);

		PayloadTypeRegistry.playS2C().register(GhostRecipeCostResponse.PAYLOAD_ID, GhostRecipeCostResponse.CODEC);
		PayloadTypeRegistry.playC2S().register(GhostRecipeCostRequest.PAYLOAD_ID, GhostRecipeCostRequest.CODEC);
		ServerPlayNetworking.registerGlobalReceiver(GhostRecipeCostRequest.PAYLOAD_ID, (payload, context) -> {
			int cost = EffigyAltarScreenHandler.getXPCost(context.player().method_51469(), payload.ghostInputs());
			ServerPlayNetworking.send(context.player(), new GhostRecipeCostResponse(cost));
		});

		LootTableEvents.MODIFY.register((key, tableBuilder, source, registries) -> {
			if (key.method_29177().equals(class_2960.method_60655("minecraft", "archaeology/ocean_ruin_cold"))) {
				tableBuilder.modifyPools(pool -> {
					pool.method_351(class_77.method_411(class_1802.field_8547).method_437(1));
				});
			}
			if (key.method_29177().equals(class_2960.method_60655("minecraft", "archaeology/ocean_ruin_warm"))) {
				tableBuilder.modifyPools(pool -> {
					pool.method_351(class_77.method_411(class_1802.field_8662).method_437(1));
					pool.method_351(class_77.method_411(class_1802.field_8434).method_437(1));
				});
			}
			if (key.method_29177().equals(class_2960.method_60655("minecraft", "chests/simple_dungeon"))) {
				tableBuilder.modifyPools(pool -> {
					pool.method_351(class_77.method_411(class_1802.field_8470).method_437(1));
					pool.method_351(class_77.method_411(class_1802.field_8681).method_437(1));
				});
			}
			if (key.method_29177().equals(class_2960.method_60655("minecraft", "chests/ruined_portal")) ||
				key.method_29177().equals(class_2960.method_60655("minecraft", "chests/nether_bridge"))) {
				tableBuilder.modifyPools(pool -> {
					pool.method_351(class_77.method_411(class_1802.field_41304).method_437(1));
				});
			}
			if (key.method_29177().equals(class_2960.method_60655("minecraft", "entities/cod")) ||
				key.method_29177().equals(class_2960.method_60655("minecraft", "entities/salmon")) ||
				key.method_29177().equals(class_2960.method_60655("minecraft", "entities/salmon")) ||
				key.method_29177().equals(class_2960.method_60655("minecraft", "entities/tropical_fish"))
				) {
				tableBuilder.method_336(class_55.method_347()
					.method_352(class_44.method_32448(0.25f))
					.method_351(class_77.method_411(class_1802.field_8606))
					.method_353(class_141.method_621(class_5662.method_32462(0, 1)))
					.method_353((class_117.class_118)class_125.method_547(registries, class_5662.method_32462(0f, 1f)))
				);
				tableBuilder.method_336(class_55.method_347()
					.method_352(class_44.method_32448(0.05f))
					.method_351(class_77.method_411(class_1802.field_8324))
					.method_353(class_141.method_621(class_5662.method_32462(0, 1)))
					.method_353((class_117.class_118)class_125.method_547(registries, class_5662.method_32462(0f, 1f)))
				);
			}
		});

		ServerWorldEvents.LOAD.register(((server, world) -> {
			if (world.method_27983() == class_1937.field_25181) {
				PeacefulModEndPersistentState.INSTANCE = PeacefulModEndPersistentState.get(world);
			}
		}));
		ServerWorldEvents.UNLOAD.register(((server, world) -> {
			if (world.method_27983() == class_1937.field_25181) {
				PeacefulModEndPersistentState.INSTANCE = null;
			}
		}));
	}
}