package xen42.peacefulitems;

import java.util.List;
import java.util.concurrent.CompletableFuture;

import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricBlockLootTableProvider;
import net.minecraft.class_141;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_212;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_44;
import net.minecraft.class_4559;
import net.minecraft.class_52;
import net.minecraft.class_55;
import net.minecraft.class_5662;
import net.minecraft.class_7225;
import net.minecraft.class_7225.class_7874;
import net.minecraft.class_77;
import net.minecraft.class_7924;
import net.minecraft.class_94;
import xen42.peacefulitems.blocks.BlazePickleBlock;
import xen42.peacefulitems.blocks.FlaxCropBlock;

public class PeacefulModBlockLootTableGenerator extends FabricBlockLootTableProvider {

    protected PeacefulModBlockLootTableGenerator(FabricDataOutput dataOutput,
            CompletableFuture<class_7874> registryLookup) {
        super(dataOutput, registryLookup);
    }

    @Override
    public String method_10321() {
        return "PeacefulModBlockLootTableGenerator";
    }

    @Override
    public void method_10379() {
        method_46025(PeacefulModBlocks.SULPHUR_BLOCK);
        method_46025(PeacefulModBlocks.SULPHUR_STAIRS);
		method_45994(PeacefulModBlocks.SULPHUR_SLAB, block -> method_45980(block));
        method_46025(PeacefulModBlocks.SULPHUR_WALL);
        method_46025(PeacefulModBlocks.CHISELED_SULPHUR_BLOCK);
        method_45994(PeacefulModBlocks.FOSSIL_ORE, block -> fossilOreDrops(block));
        method_45994(PeacefulModBlocks.DEEPSLATE_FOSSIL_ORE, block -> fossilOreDrops(block));
        method_45994(PeacefulModBlocks.SOUL_SOIL_FOSSIL_ORE, block -> fossilOreDrops(block));
        method_45994(PeacefulModBlocks.SULPHUR_ORE, block -> method_45981(PeacefulModBlocks.SULPHUR_ORE, PeacefulModItems.SULPHUR));
        method_45994(PeacefulModBlocks.SULPHUR_CLUSTER, block -> dropItem(PeacefulModItems.SULPHUR, 1, 1));
        this.method_45994(PeacefulModBlocks.BLAZE_PICKLE, (class_2248 block) 
            -> class_52.method_324().method_336(class_55.method_347().method_352(class_44.method_32448(1.0f))
            .method_351(this.method_45977(PeacefulModBlocks.BLAZE_PICKLE, class_77.method_411(block)
            .method_43739(List.of(Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)), pickles 
            -> class_141.method_621(class_44.method_32448(pickles.intValue()))
            .method_524(class_212.method_900(block)
            .method_22584(class_4559.class_4560.method_22523().method_22524(BlazePickleBlock.PICKLES, pickles.intValue()))))))));
        
        this.method_45994(PeacefulModBlocks.BREEZE_CORAL, (class_2248 block) 
            -> class_52.method_324().method_336(class_55.method_347().method_352(class_44.method_32448(1.0f))
            .method_351(this.method_45977(PeacefulModBlocks.BREEZE_CORAL, class_77.method_411(block)
            .method_43739(List.of(Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)), pickles 
            -> class_141.method_621(class_44.method_32448(pickles.intValue()))
            .method_524(class_212.method_900(block)
            .method_22584(class_4559.class_4560.method_22523().method_22524(BlazePickleBlock.PICKLES, pickles.intValue()))))))));

        class_212.class_213 flax_condition = class_212.method_900(PeacefulModBlocks.FLAX_CROP)
            .method_22584(class_4559.class_4560.method_22523().method_22524(FlaxCropBlock.field_10835, 7));
        method_45994(PeacefulModBlocks.FLAX_CROP, block -> this.method_45982(block, class_1802.field_8276, PeacefulModItems.FLAX, flax_condition));

        method_46006(PeacefulModBlocks.DRAGON_BREATH_CAULDRON, class_2246.field_10593);
    }

    private class_52.class_53 fossilOreDrops(class_2248 block) {
        class_7225.class_7226<class_1887> impl = this.field_51845.method_46762(class_7924.field_41265);

        var boneMealDrop = class_77.method_411(class_1802.field_8324).method_438(class_141.method_621(class_5662.method_32462(1.0f, 3.0f)))
            .method_438(class_94.method_455(impl.method_46747(class_1893.field_9130)));

        var normalDrop = (class_52.class_53)class_52.method_324()
            .method_336(class_55.method_347().method_351(boneMealDrop).method_356(method_60391()))
            .method_336(class_55.method_347().method_351(class_77.method_411(block)).method_356(method_60390()));

        return normalDrop;
    }

    private class_52.class_53 dropItem(class_1792 item, int min, int max) {
        var dropItem = (class_77.method_411(item).method_438(class_141.method_621(class_5662.method_32462(min, max))));

        return class_52.method_324().method_336(class_55.method_347().method_351(dropItem));
    }
}