package xen42.peacefulitems;

import java.util.concurrent.CompletableFuture;

import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.class_1928;
import net.minecraft.class_3195;
import net.minecraft.class_3611;
import net.minecraft.class_3852;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7045;
import net.minecraft.class_7225;
import net.minecraft.class_7225.class_7874;

public abstract class PeacefulModLanguageProvider extends FabricLanguageProvider {
    public PeacefulModLanguageProvider(FabricDataOutput output, String languageCode, CompletableFuture<class_7225.class_7874> registryLookup) {
    	super(output, languageCode, registryLookup);
    }

	public void generateTranslations(class_7225.class_7874 registryLookup, TranslationBuilder translationBuilder) {
		generate(registryLookup, new ModTranslationBuilder(translationBuilder));
	}
	
	public String processValue(String value) {
		return value;
	}

	public abstract void generate(class_7225.class_7874 registryLookup, ModTranslationBuilder translationBuilder);
	
	public class ModTranslationBuilder implements TranslationBuilder {
		private final TranslationBuilder original;
		
		public ModTranslationBuilder(TranslationBuilder original) {
			this.original = original;
		}
		
		@Override
		public void add(String key, String value) {
			original.add(key, processValue(value));
		}
		
		public void add(class_6862<?> key, String value) {
			add(key.getTranslationKey(), value);
		}
		
		public void addTags(String value, class_6862<?>... keys) {
			for (class_6862<?> key : keys) {
				add(key, value);
			}
		}
		
		public void add(class_1928.class_4313<?> key, String value) {
			add(key.method_27334(), value);
		}
		
		public void add(class_1928.class_4313<?> key, String title, String description) {
			add(key.method_27334(), title);
			add(key.method_27334() + ".description", description);
		}

		@SuppressWarnings("deprecation")
		public void add(class_3611 fluid, String value) {
			class_5321<class_3611> key = fluid.method_40178().method_40237();
			add("block." + key.method_29177().method_12836() + "." + key.method_29177().method_12832(), value);
		}

		public void addVillagerProfession(class_5321<class_3852> key, String value) {
			add("entity." + key.method_29177().method_12836() + ".villager." + key.method_29177().method_12832(), value);
		}

		public void addFilledMap(class_6862<class_3195> structure, String value) {
			add("filled_map." + structure.comp_327().method_12836() + "." + structure.comp_327().method_12832(), value);
		}
	}
	
	public static class English extends PeacefulModLanguageProvider {

		public English(FabricDataOutput output, String languageCode, CompletableFuture<class_7874> registryLookup) {
			super(output, languageCode, registryLookup);
		}

		public English(FabricDataOutput output, CompletableFuture<class_7874> registryLookup) {
			this(output, "en_us", registryLookup);
		}

		@Override
		public void generate(class_7874 registryLookup, ModTranslationBuilder translationBuilder) {
			translationBuilder.add(PeacefulModItems.BAT_WING, "Bat Wing");
			translationBuilder.add(PeacefulModItems.GUANO, "Guano");
			translationBuilder.add(PeacefulModItems.ECTOPLASM, "Ectoplasm");
			translationBuilder.add(PeacefulModItems.SULPHUR, "Brimstone");
			translationBuilder.add(PeacefulModItems.FLAX, "Flax Seeds");
			
			translationBuilder.add(PeacefulModBlocks.SULPHUR_BLOCK, "Block of Brimstone");
			translationBuilder.add(PeacefulModBlocks.SULPHUR_STAIRS, "Brimstone Stairs");
			translationBuilder.add(PeacefulModBlocks.SULPHUR_SLAB, "Brimstone Slab");
			translationBuilder.add(PeacefulModBlocks.SULPHUR_WALL, "Brimstone Wall");
			translationBuilder.add(PeacefulModBlocks.CHISELED_SULPHUR_BLOCK, "Chiseled Brimstone Block");
			translationBuilder.add(PeacefulModBlocks.SULPHUR_ORE, "Brimstone Ore");
			translationBuilder.add(PeacefulModBlocks.FOSSIL_ORE, "Fossil Ore");
			translationBuilder.add(PeacefulModBlocks.DEEPSLATE_FOSSIL_ORE, "Deepslate Fossil Ore");
			translationBuilder.add(PeacefulModBlocks.SOUL_SOIL_FOSSIL_ORE, "Nether Fossil Ore");
			translationBuilder.add(PeacefulModBlocks.EFFIGY_ALTAR, "Effigy Altar");
			translationBuilder.add(PeacefulModItems.CLAM, "Clam");
			translationBuilder.add(PeacefulModItems.COOKED_CLAM, "Cooked Clam");
			
			translationBuilder.add(PeacefulModBlocks.BLAZE_PICKLE, "Blaze Coral");
			translationBuilder.add(PeacefulModBlocks.BREEZE_CORAL, "Breeze Coral");
			translationBuilder.add(PeacefulModItems.GHASTLING_SPAWN_EGG, "Wisp Spawn Egg");
			translationBuilder.add(PeacefulModItems.END_CLAM_SPAWN_EGG, "Enderclam Spawn Egg");

			translationBuilder.addVillagerProfession(PeacefulModVillagers.DJ_VILLAGER_KEY, "Musician");
			translationBuilder.add(PeacefulMod.GHASTLING_ENTITY, "Wisp");
			translationBuilder.add(PeacefulMod.END_CLAM_ENTITY, "Enderclam");

			translationBuilder.add(PeacefulModItems.CAPE, "Cape");
			translationBuilder.add(PeacefulModItems.WITHER_EFFIGY, "Wither Effigy");
			translationBuilder.add(PeacefulModItems.DRAGON_EFFIGY, "Dragon Effigy");
			translationBuilder.add(PeacefulModItems.GUARDIAN_EFFIGY, "Elder Effigy");
			translationBuilder.add(PeacefulModItems.RAID_EFFIGY, "Raid Effigy");
			
			translationBuilder.add(PeacefulModFluids.DRAGON_BREATH, "Dragon's Breath");
			translationBuilder.add(PeacefulModBlocks.DRAGON_BREATH_CAULDRON, "Dragon's Breath Cauldron");
			
			translationBuilder.addFilledMap(PeacefulModTags.StructureTags.EFFIGY_ALTAR_DUNGEON, "Effigy Altar Dungeon Map");
			translationBuilder.addFilledMap(PeacefulModTags.StructureTags.TRAIL_RUINS, "Trail Ruins Map");
			translationBuilder.addFilledMap(class_7045.field_37049, "Ocean Ruin Map");
			
			translationBuilder.add(PeacefulMod.ENABLE_STARVING_PEACEFUL, "Enable starving in peaceful");
			translationBuilder.add(PeacefulMod.ENABLE_SUPER_HEALING_PEACEFUL, "Enable super healing in peaceful");
			translationBuilder.add(PeacefulMod.ENABLE_ENDER_DRAGON_FIGHT_PEACEFUL, "Enable Ender Dragon fight in peaceful");

			translationBuilder.add(PeacefulModTags.ItemTags.EFFIGIES, "Effigies");
			translationBuilder.add(PeacefulModTags.StructureTags.EFFIGY_ALTAR_DUNGEON, "Effigy Altar Dungeon");
			translationBuilder.add(PeacefulModTags.StructureTags.TRAIL_RUINS, "Trail Ruins");
			translationBuilder.add(class_7045.field_37049, "Ocean Ruin");
			translationBuilder.addTags("Soul Soil Ore Bearing Ground", PeacefulModTags.ItemTags.ORE_BEARING_GROUND_SOUL_SOIL, PeacefulModTags.BlockTags.ORE_BEARING_GROUND_SOUL_SOIL);
			translationBuilder.addTags("Soul Soil Ores In Ground", PeacefulModTags.ItemTags.ORES_IN_GROUND_SOUL_SOIL, PeacefulModTags.BlockTags.ORES_IN_GROUND_SOUL_SOIL);
			translationBuilder.addTags("Fossil Ores", PeacefulModTags.ItemTags.FOSSIL_ORES, PeacefulModTags.ItemTags.FOSSIL_ORES_C, PeacefulModTags.BlockTags.FOSSIL_ORES, PeacefulModTags.BlockTags.FOSSIL_ORES_C);
			translationBuilder.addTags("Brimstone Ores", PeacefulModTags.ItemTags.SULPHUR_ORES, PeacefulModTags.ItemTags.SULPHUR_ORES_C, PeacefulModTags.ItemTags.SULFUR_ORES, PeacefulModTags.BlockTags.SULPHUR_ORES, PeacefulModTags.BlockTags.SULPHUR_ORES_C, PeacefulModTags.BlockTags.SULFUR_ORES);
		}
	}
	
	public static class EnglishUpsideDown extends English {
		private static final String NORMAL_CHARS = " abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_,;.?!/\\'\"";
		private static final String UPSIDE_DOWN_CHARS = " ɐqɔpǝɟᵷɥᴉɾʞꞁɯuodbɹsʇnʌʍxʎzⱯᗺƆᗡƎℲ⅁HIՐꞰꞀWNOԀὉᴚS⟘∩ΛMXʎZ0⥝ᘔƐ߈ϛ9ㄥ86‾'⸵˙¿¡\\/,„";

		public EnglishUpsideDown(FabricDataOutput output, CompletableFuture<class_7874> registryLookup) {
			super(output, "en_ud", registryLookup);
		}

		@Override
		public String processValue(String value) {
			return toUpsideDown(value);
		}

		private static String toUpsideDown(String name) {
			StringBuilder builder = new StringBuilder();

			for (int i = name.length() - 1; i >= 0; i--) {
				if (i > 2 && name.substring(i - 3, i + 1).equals("%1$s")) {
					builder.append(name, i - 3, i + 1);
					i -= 4;
					continue;
				}

				if (i < 0)
					continue;

				char normalChar = name.charAt(i);
				int normalIndex = NORMAL_CHARS.indexOf(normalChar);
				if (normalIndex < 0) {
					builder.append(normalChar);
				} else {
					char upsideDown = UPSIDE_DOWN_CHARS.charAt(normalIndex);
					builder.append(upsideDown);
				}
			}

			return builder.toString();
		}
		
	}
	
	public static class ChineseSimplified extends PeacefulModLanguageProvider {

		public ChineseSimplified(FabricDataOutput output, String languageCode, CompletableFuture<class_7874> registryLookup) {
			super(output, languageCode, registryLookup);
		}

		public ChineseSimplified(FabricDataOutput output, CompletableFuture<class_7874> registryLookup) {
			this(output, "zh_cn", registryLookup);
		}

		@Override
		public void generate(class_7874 registryLookup, ModTranslationBuilder translationBuilder) {
			translationBuilder.add(PeacefulModItems.BAT_WING, "蝙蝠翅膀");
			translationBuilder.add(PeacefulModItems.GUANO, "粪便");
			translationBuilder.add(PeacefulModItems.ECTOPLASM, "灵质");
			translationBuilder.add(PeacefulModItems.SULPHUR, "硫磺");
			translationBuilder.add(PeacefulModItems.FLAX, "亚麻种子");
			
			translationBuilder.add(PeacefulModBlocks.SULPHUR_BLOCK, "硫磺块");
			translationBuilder.add(PeacefulModBlocks.SULPHUR_STAIRS, "硫磺楼梯");
			translationBuilder.add(PeacefulModBlocks.SULPHUR_SLAB, "硫磺台阶");
			translationBuilder.add(PeacefulModBlocks.SULPHUR_WALL, "硫磺围墙");
			translationBuilder.add(PeacefulModBlocks.CHISELED_SULPHUR_BLOCK, "雕纹硫磺块");
			translationBuilder.add(PeacefulModBlocks.SULPHUR_ORE, "硫磺矿石");
			translationBuilder.add(PeacefulModBlocks.FOSSIL_ORE, "化石矿石");
			translationBuilder.add(PeacefulModBlocks.DEEPSLATE_FOSSIL_ORE, "深层化石矿石");
			translationBuilder.add(PeacefulModBlocks.SOUL_SOIL_FOSSIL_ORE, "下界化石矿石");
			translationBuilder.add(PeacefulModBlocks.EFFIGY_ALTAR, "塑像祭坛");
			translationBuilder.add(PeacefulModItems.CLAM, "蛤");
			translationBuilder.add(PeacefulModItems.COOKED_CLAM, "熟蛤");
			
			translationBuilder.add(PeacefulModBlocks.BLAZE_PICKLE, "烈焰珊瑚");
			translationBuilder.add(PeacefulModBlocks.BREEZE_CORAL, "旋风珊瑚");
			translationBuilder.add(PeacefulModItems.GHASTLING_SPAWN_EGG, "小精灵刷怪蛋");
			translationBuilder.add(PeacefulModItems.END_CLAM_SPAWN_EGG, "末影蛤刷怪蛋");

			translationBuilder.addVillagerProfession(PeacefulModVillagers.DJ_VILLAGER_KEY, "音乐家");
			translationBuilder.add(PeacefulMod.GHASTLING_ENTITY, "小精灵");
			translationBuilder.add(PeacefulMod.END_CLAM_ENTITY, "末影蛤");

			translationBuilder.add(PeacefulModItems.CAPE, "披风");
			translationBuilder.add(PeacefulModItems.WITHER_EFFIGY, "凋灵塑像");
			translationBuilder.add(PeacefulModItems.DRAGON_EFFIGY, "龙塑像");
			translationBuilder.add(PeacefulModItems.GUARDIAN_EFFIGY, "远古塑像");
			translationBuilder.add(PeacefulModItems.RAID_EFFIGY, "袭击塑像");
			
			translationBuilder.add(PeacefulModFluids.DRAGON_BREATH, "龙息");
			translationBuilder.add(PeacefulModBlocks.DRAGON_BREATH_CAULDRON, "装有龙息的炼药锅");
			
			translationBuilder.addFilledMap(PeacefulModTags.StructureTags.EFFIGY_ALTAR_DUNGEON, "塑像祭坛地图");
			translationBuilder.addFilledMap(PeacefulModTags.StructureTags.TRAIL_RUINS, "古迹废墟地图");
			translationBuilder.addFilledMap(class_7045.field_37049, "海底废墟地图");
			
			translationBuilder.add(PeacefulMod.ENABLE_STARVING_PEACEFUL, "启用和平中的饿死");
			translationBuilder.add(PeacefulMod.ENABLE_SUPER_HEALING_PEACEFUL, "启用和平中的超级生命恢复");
			translationBuilder.add(PeacefulMod.ENABLE_ENDER_DRAGON_FIGHT_PEACEFUL, "启用和平中的末影龙");

			translationBuilder.add(PeacefulModTags.ItemTags.EFFIGIES, "塑像");
			translationBuilder.add(PeacefulModTags.StructureTags.EFFIGY_ALTAR_DUNGEON, "塑像祭坛");
			translationBuilder.add(PeacefulModTags.StructureTags.TRAIL_RUINS, "古迹废墟");
			translationBuilder.add(class_7045.field_37049, "海底废墟");
			translationBuilder.addTags("灵魂土含矿石地", PeacefulModTags.ItemTags.ORE_BEARING_GROUND_SOUL_SOIL, PeacefulModTags.BlockTags.ORE_BEARING_GROUND_SOUL_SOIL);
			translationBuilder.addTags("地下灵魂土矿石", PeacefulModTags.ItemTags.ORES_IN_GROUND_SOUL_SOIL, PeacefulModTags.BlockTags.ORES_IN_GROUND_SOUL_SOIL);
			translationBuilder.addTags("化石矿石", PeacefulModTags.ItemTags.FOSSIL_ORES, PeacefulModTags.ItemTags.FOSSIL_ORES_C, PeacefulModTags.BlockTags.FOSSIL_ORES, PeacefulModTags.BlockTags.FOSSIL_ORES_C);
			translationBuilder.addTags("硫磺矿石", PeacefulModTags.ItemTags.SULPHUR_ORES, PeacefulModTags.ItemTags.SULPHUR_ORES_C, PeacefulModTags.ItemTags.SULFUR_ORES, PeacefulModTags.BlockTags.SULPHUR_ORES, PeacefulModTags.BlockTags.SULPHUR_ORES_C, PeacefulModTags.BlockTags.SULFUR_ORES);
		}
	}
	
	public static class Russian extends PeacefulModLanguageProvider {

		public Russian(FabricDataOutput output, String languageCode, CompletableFuture<class_7874> registryLookup) {
			super(output, languageCode, registryLookup);
		}

		public Russian(FabricDataOutput output, CompletableFuture<class_7874> registryLookup) {
			this(output, "ru_ru", registryLookup);
		}

		@Override
		public void generate(class_7874 registryLookup, ModTranslationBuilder translationBuilder) {
			translationBuilder.add(PeacefulModItems.BAT_WING, "Крыло летучей мыши");
			translationBuilder.add(PeacefulModItems.GUANO, "Гуано");
			translationBuilder.add(PeacefulModItems.ECTOPLASM, "Эктоплазма");
			translationBuilder.add(PeacefulModItems.SULPHUR, "Сера");
			translationBuilder.add(PeacefulModItems.FLAX, "Семена льна");
			
			translationBuilder.add(PeacefulModBlocks.SULPHUR_BLOCK, "Серный блок");
			translationBuilder.add(PeacefulModBlocks.SULPHUR_STAIRS, "Серные ступеньки");
			translationBuilder.add(PeacefulModBlocks.SULPHUR_SLAB, "Серная плита");
			translationBuilder.add(PeacefulModBlocks.SULPHUR_WALL, "Серная ограда");
			translationBuilder.add(PeacefulModBlocks.CHISELED_SULPHUR_BLOCK, "Резной серный блок");
			translationBuilder.add(PeacefulModBlocks.SULPHUR_ORE, "Серная руда");
			translationBuilder.add(PeacefulModBlocks.FOSSIL_ORE, "Окаменелость");
			translationBuilder.add(PeacefulModBlocks.DEEPSLATE_FOSSIL_ORE, "Глубинносланцевая окаменелость");
			translationBuilder.add(PeacefulModBlocks.SOUL_SOIL_FOSSIL_ORE, "Незерская окаменелость");
			translationBuilder.add(PeacefulModBlocks.EFFIGY_ALTAR, "Алтарь тотемов");
			translationBuilder.add(PeacefulModItems.CLAM, "Моллюск");
			translationBuilder.add(PeacefulModItems.COOKED_CLAM, "Жареный моллюск");
			
			translationBuilder.add(PeacefulModBlocks.BLAZE_PICKLE, "Полыхающий коралл");
			translationBuilder.add(PeacefulModBlocks.BREEZE_CORAL, "Ветренный коралл");
			translationBuilder.add(PeacefulModItems.GHASTLING_SPAWN_EGG, "Яйцо призыва души");
			translationBuilder.add(PeacefulModItems.END_CLAM_SPAWN_EGG, "Яйцо призыва эндер-моллюска");

			translationBuilder.addVillagerProfession(PeacefulModVillagers.DJ_VILLAGER_KEY, "Музыкант");
			translationBuilder.add(PeacefulMod.GHASTLING_ENTITY, "Душа");
			translationBuilder.add(PeacefulMod.END_CLAM_ENTITY, "Эндер-моллюск");

			translationBuilder.add(PeacefulModItems.CAPE, "Плащ");
			translationBuilder.add(PeacefulModItems.WITHER_EFFIGY, "Тотем визера");
			translationBuilder.add(PeacefulModItems.DRAGON_EFFIGY, "Тотем Эндер-дракона");
			translationBuilder.add(PeacefulModItems.GUARDIAN_EFFIGY, "Тотем древнего стража");
			translationBuilder.add(PeacefulModItems.RAID_EFFIGY, "Тотем рейда");
			
			translationBuilder.add(PeacefulModFluids.DRAGON_BREATH, "Дыхание дракона");
			translationBuilder.add(PeacefulModBlocks.DRAGON_BREATH_CAULDRON, "Котёл с дыханием дракона");
			
			translationBuilder.addFilledMap(PeacefulModTags.StructureTags.EFFIGY_ALTAR_DUNGEON, "Карта искателя алтарей");
			translationBuilder.addFilledMap(PeacefulModTags.StructureTags.TRAIL_RUINS, "Карта исследователя руины троп");
			translationBuilder.addFilledMap(class_7045.field_37049, "Карта исследователя подводных руин");
			
			translationBuilder.add(PeacefulMod.ENABLE_STARVING_PEACEFUL, "Включить голодание на мирной сложности");
			translationBuilder.add(PeacefulMod.ENABLE_SUPER_HEALING_PEACEFUL, "Включить быстрое восстановление здоровья на мирной сложности");
			translationBuilder.add(PeacefulMod.ENABLE_ENDER_DRAGON_FIGHT_PEACEFUL, "Включить битву с драконом на мирной сложности");

			translationBuilder.add(PeacefulModTags.ItemTags.EFFIGIES, "Тотемы");
			translationBuilder.add(PeacefulModTags.StructureTags.EFFIGY_ALTAR_DUNGEON, "Алтари тотемов");
			translationBuilder.add(PeacefulModTags.StructureTags.TRAIL_RUINS, "Руины троп");
			translationBuilder.add(class_7045.field_37049, "Подводные руины");
			translationBuilder.addTags("Рудоносная почва душ", PeacefulModTags.ItemTags.ORE_BEARING_GROUND_SOUL_SOIL, PeacefulModTags.BlockTags.ORE_BEARING_GROUND_SOUL_SOIL);
			translationBuilder.addTags("Руды почвы душ в земле", PeacefulModTags.ItemTags.ORES_IN_GROUND_SOUL_SOIL, PeacefulModTags.BlockTags.ORES_IN_GROUND_SOUL_SOIL);
			translationBuilder.addTags("Окаменелости", PeacefulModTags.ItemTags.FOSSIL_ORES, PeacefulModTags.ItemTags.FOSSIL_ORES_C, PeacefulModTags.BlockTags.FOSSIL_ORES, PeacefulModTags.BlockTags.FOSSIL_ORES_C);
			translationBuilder.addTags("Серные руды", PeacefulModTags.ItemTags.SULPHUR_ORES, PeacefulModTags.ItemTags.SULPHUR_ORES_C, PeacefulModTags.ItemTags.SULFUR_ORES, PeacefulModTags.BlockTags.SULPHUR_ORES, PeacefulModTags.BlockTags.SULPHUR_ORES_C, PeacefulModTags.BlockTags.SULFUR_ORES);
		}
	}
}
