package xen42.peacefulitems;

import java.util.Optional;

import net.fabricmc.fabric.api.client.datagen.v1.provider.FabricModelProvider;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2741;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_5556;
import net.minecraft.class_813;

public class PeacefulModModelGenerator extends FabricModelProvider {

    public PeacefulModModelGenerator(FabricDataOutput output) {
        super(output);
    }

    @Override
    public void generateBlockStateModels(class_4910 blockStateModelGenerator) {
        blockStateModelGenerator.method_25650(PeacefulModBlocks.SULPHUR_BLOCK).method_33522(PeacefulModBlocks.SULPHUR);
        blockStateModelGenerator.method_25641(PeacefulModBlocks.FOSSIL_ORE);
        blockStateModelGenerator.method_25641(PeacefulModBlocks.DEEPSLATE_FOSSIL_ORE);
        blockStateModelGenerator.method_25641(PeacefulModBlocks.SOUL_SOIL_FOSSIL_ORE);
        blockStateModelGenerator.method_25641(PeacefulModBlocks.SULPHUR_ORE);
        blockStateModelGenerator.method_32229(PeacefulModBlocks.SULPHUR_CLUSTER);
        registerSeaPickle(blockStateModelGenerator, PeacefulModBlocks.BLAZE_PICKLE.method_8389(), PeacefulModBlocks.BLAZE_PICKLE);
        registerSeaPickle(blockStateModelGenerator, PeacefulModBlocks.BREEZE_CORAL.method_8389(), PeacefulModBlocks.BREEZE_CORAL);

        blockStateModelGenerator.method_25547(PeacefulModBlocks.FLAX_CROP, class_2741.field_12550, 0, 1, 2, 3, 4, 4, 5, 6);
        
        registerCauldron(blockStateModelGenerator, PeacefulModBlocks.DRAGON_BREATH_CAULDRON, class_2960.method_60655(PeacefulMod.MOD_ID, "dragon_breath").method_45138("block/"));
    }

    @Override
    public void generateItemModels(class_4915 itemModelGenerator) {
        itemModelGenerator.method_65442(PeacefulModItems.BAT_WING, class_4943.field_22938);
        itemModelGenerator.method_65448(PeacefulModItems.CAPE);
        itemModelGenerator.method_65442(PeacefulModItems.GUANO, class_4943.field_22938);
        itemModelGenerator.method_65442(PeacefulModItems.ECTOPLASM, class_4943.field_22938);
        itemModelGenerator.method_65442(PeacefulModItems.SULPHUR, class_4943.field_22938);
        
        itemModelGenerator.method_65442(PeacefulModItems.WITHER_EFFIGY, class_4943.field_22938);
        itemModelGenerator.method_65442(PeacefulModItems.GUARDIAN_EFFIGY, class_4943.field_22938);
        itemModelGenerator.method_65442(PeacefulModItems.DRAGON_EFFIGY, class_4943.field_22938);
        itemModelGenerator.method_65442(PeacefulModItems.RAID_EFFIGY, class_4943.field_22938);

        itemModelGenerator.method_65442(PeacefulModItems.GHASTLING_SPAWN_EGG, class_4943.field_22938);
        itemModelGenerator.method_65442(PeacefulModItems.END_CLAM_SPAWN_EGG, class_4943.field_22938);

        itemModelGenerator.method_65442(PeacefulModItems.CLAM, class_4943.field_22938);
        itemModelGenerator.method_65442(PeacefulModItems.COOKED_CLAM, class_4943.field_22938);
    }

    @Override
    public String method_10321() {
        return "PeacefulModModelGenerator";
    }

    private class_4942 GetModel(String parent) {
        return new class_4942(Optional.of(class_2960.method_60656("block/" + parent)), Optional.empty(), class_4945.field_23010, class_4945.field_23012);
    }

    public void registerSeaPickle(class_4910 blockStateModelGenerator, class_1792 item, class_2248 block) {
		blockStateModelGenerator.method_25537(item);
        var textureMap = class_4944.method_25864(block);

        var id1 = GetModel("dead_sea_pickle").method_25847(block, "_one", textureMap, blockStateModelGenerator.field_22831);
        var id2 = GetModel("two_dead_sea_pickles").method_25847(block, "_two", textureMap, blockStateModelGenerator.field_22831);
        var id3 = GetModel("three_dead_sea_pickles").method_25847(block, "_three", textureMap, blockStateModelGenerator.field_22831);
        var id4 = GetModel("four_dead_sea_pickles").method_25847(block, "_four", textureMap, blockStateModelGenerator.field_22831);

		blockStateModelGenerator.field_22830
			.accept(
                class_4925.method_67852(block)
                    .method_67859(class_4926.method_67864(class_2741.field_12543)
							.method_25794(1, class_4910.method_67822(new class_813(id1)))
							.method_25794(2, class_4910.method_67822(new class_813(id2)))
							.method_25794(3, class_4910.method_67822(new class_813(id3)))
							.method_25794(4, class_4910.method_67822(new class_813(id4)))
                    )
			);
	}
    
    public void registerCauldron(class_4910 blockStateModelGenerator, class_2248 cauldronBlock, class_2960 fluidTexture) {
    	class_4944 cauldronTextureMap = class_4944.method_32232(fluidTexture);
        blockStateModelGenerator.field_22830
			.accept(
				class_4925.method_67852(cauldronBlock)
					.method_67859(
						class_4926.method_67864(class_5556.field_27206)
							.method_25794(
								1,
								class_4910.method_67835(
									class_4943.field_28014
										.method_25847(cauldronBlock, "_level1", cauldronTextureMap, blockStateModelGenerator.field_22831)
								)
							)
							.method_25794(
								2,
								class_4910.method_67835(
									class_4943.field_28015
										.method_25847(cauldronBlock, "_level2", cauldronTextureMap, blockStateModelGenerator.field_22831)
								)
							)
							.method_25794(
								3,
								class_4910.method_67835(
									class_4943.field_27784
										.method_25847(cauldronBlock, "_full", cauldronTextureMap, blockStateModelGenerator.field_22831)
								)
							)
					)
			);
    }
}
