package xen42.peacefulitems;

import java.util.List;
import java.util.concurrent.CompletableFuture;

import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1874;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2446;
import net.minecraft.class_2454;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_3859;
import net.minecraft.class_3861;
import net.minecraft.class_3981;
import net.minecraft.class_5321;
import net.minecraft.class_5797;
import net.minecraft.class_7225.class_7874;
import net.minecraft.class_7800;
import net.minecraft.class_7924;
import net.minecraft.class_8790;
import xen42.peacefulitems.recipe.EffigyAltarRecipeJsonBuilder;

public class PeacefulModRecipeGenerator extends FabricRecipeProvider {
    public PeacefulModRecipeGenerator(FabricDataOutput generator, CompletableFuture<class_7874> registriesFuture) {
        super(generator, registriesFuture);
    }

    @Override
    public String method_10321() {
        return "PeacefulModRecipeGenerator";
    }

    @Override
    public class_2960 getRecipeIdentifier(class_2960 identifier) {
        return class_2960.method_60655(PeacefulMod.MOD_ID, identifier.method_12832());
    }
    
    public static void offerTo(class_5797 builder, class_8790 exporter) {
        builder.method_17972(exporter, class_5321.method_29179(class_7924.field_52178, EffigyAltarRecipeJsonBuilder.method_36442(builder.method_36441())));
    }

    public static void offerTo(class_5797 builder, class_8790 exporter, String recipePath) {
        class_2960 defaultIdentifier = EffigyAltarRecipeJsonBuilder.method_36442(builder.method_36441());
        class_2960 identifier = class_2960.method_60655(PeacefulMod.MOD_ID, recipePath);
        if (identifier.equals(defaultIdentifier)) {
            throw new IllegalStateException("Recipe " + recipePath + " should remove its 'save' argument as it is equal to default one");
        } else {
            builder.method_17972(exporter, class_5321.method_29179(class_7924.field_52178, identifier));
        }
    }

    @Override
    protected class_2446 method_62766(class_7874 registryLookup, class_8790 exporter) {
        return new class_2446(registryLookup, exporter) {
            @Override
            public void method_36233(List<class_1935> inputs, class_7800 category, class_1935 output, float experience, int cookingTime, String group) {
                this.fixedOfferMultipleOptions(class_1865.field_9042, class_3861::new, inputs, category, output, experience, cookingTime, group, "_from_smelting");
            }

            @Override
            public void method_36234(List<class_1935> inputs, class_7800 category, class_1935 output, float experience, int cookingTime, String group) {
                this.fixedOfferMultipleOptions(class_1865.field_17084, class_3859::new, inputs, category, output, experience, cookingTime, group, "_from_blasting");
            }

            @Override
            public void method_33715(class_7800 category, class_1935 output, class_1935 input, int count) {
                offerTo(class_3981.method_17969(class_1856.method_8101(input), category, output, count)
                        .method_17970(method_32807(input), this.method_10426(input))
                        , field_53721, method_33714(output, input) + "_stonecutting");
            }
            
            public final <T extends class_1874> void fixedOfferMultipleOptions(
                    class_1865<T> serializer,
                    class_1874.class_3958<T> recipeFactory,
                    List<class_1935> inputs,
                    class_7800 category,
                    class_1935 output,
                    float experience,
                    int cookingTime,
                    String group,
                    String suffix
                ) {
                    for (class_1935 itemConvertible : inputs) {
                        offerTo(class_2454.method_17801(class_1856.method_8101(itemConvertible), category, output, experience, cookingTime, serializer, recipeFactory)
                            .method_35917(group)
                            .method_10469(method_32807(itemConvertible), this.method_10426(itemConvertible))
                            , field_53721, method_33716(output) + suffix + "_" + method_33716(itemConvertible));
                    }
            }
            
            @Override
            public void method_10419() {
                offerTo(method_62746(class_7800.field_40642, class_1802.field_8745)
                        .method_10439("XX")
                        .method_10439("XX")
                        .method_10434('X', PeacefulModItems.BAT_WING)
                        // Advancement that gives the recipe
                        .method_10429(method_32807(PeacefulModItems.BAT_WING), method_10426(PeacefulModItems.BAT_WING))
                        , field_53721);
                
                offerTo(method_62750(class_7800.field_40642, class_1802.field_8054, 3)
                        .method_10454(class_1802.field_8665) 
                        .method_10446(PeacefulModTags.ItemTags.GUANO) 
                        .method_10454(PeacefulModItems.SULPHUR) 
                        .method_10442(method_32807(class_1802.field_8665), method_10426(class_1802.field_8665))
                        .method_10442(method_32807(PeacefulModItems.GUANO), method_10420(PeacefulModTags.ItemTags.GUANO))
                        .method_10442(method_32807(PeacefulModItems.SULPHUR), method_10426(PeacefulModItems.SULPHUR))
                        , field_53721);
                
                offerTo(method_62750(class_7800.field_40642, class_1802.field_8296, 1)
                        .method_10446(PeacefulModTags.ItemTags.GUANO)
                        .method_10442(method_32807(PeacefulModItems.GUANO), method_10420(PeacefulModTags.ItemTags.GUANO))
                        , field_53721);

                offerTo(method_62746(class_7800.field_40642, PeacefulModBlocks.SULPHUR_BLOCK)
                        .method_10439("XXX")
                        .method_10439("XXX")
                        .method_10439("XXX")
                        .method_10434('X', PeacefulModItems.SULPHUR)
                        // Advancement that gives the recipe
                        .method_10429(method_32807(PeacefulModItems.SULPHUR), method_10426(PeacefulModItems.SULPHUR))
                        , field_53721);

                offerTo(method_62746(class_7800.field_40642, class_1802.field_8175)
                        .method_10439("XXX")
                        .method_10439("ZYZ")
                        .method_10434('X', class_1802.field_8745)
                        .method_10434('Y', class_1802.field_8777)
                        .method_10434('Z', class_1802.field_8620)
                        // Advancement that gives the recipe
                        .method_10429(method_32807(class_1802.field_8745), method_10426(class_1802.field_8745))
                        .method_10429(method_32807(class_1802.field_8777), method_10426(class_1802.field_8777))
                        .method_10429(method_32807(class_1802.field_8620), method_10426(class_1802.field_8620))
                        , field_53721);

                offerTo(method_62749(class_7800.field_40642, class_1802.field_8511)
                    .method_10454(PeacefulModItems.SULPHUR)
                    .method_10446(class_3489.field_49932)
                    .method_10442(method_32807(PeacefulModItems.SULPHUR), method_10426(PeacefulModItems.SULPHUR))
                    , field_53721);

                offerTo(method_62750(class_7800.field_40642, PeacefulModItems.SULPHUR, 9)
                        .method_10454(PeacefulModBlocks.SULPHUR_BLOCK) 
                        .method_10442(method_32807(PeacefulModBlocks.SULPHUR_BLOCK), method_10426(PeacefulModBlocks.SULPHUR_BLOCK))
                        , field_53721);
                method_33715(class_7800.field_40634, PeacefulModBlocks.SULPHUR_SLAB, PeacefulModBlocks.SULPHUR_BLOCK, 2);
                method_33717(class_7800.field_40634, PeacefulModBlocks.SULPHUR_STAIRS, PeacefulModBlocks.SULPHUR_BLOCK);
                method_33717(class_7800.field_40635, PeacefulModBlocks.SULPHUR_WALL, PeacefulModBlocks.SULPHUR_BLOCK);
                method_33717(class_7800.field_40634, PeacefulModBlocks.CHISELED_SULPHUR_BLOCK, PeacefulModBlocks.SULPHUR_BLOCK);
                offerTo(method_32804(class_7800.field_40634, PeacefulModBlocks.SULPHUR_SLAB, class_1856.method_8091(PeacefulModBlocks.SULPHUR_BLOCK, PeacefulModBlocks.CHISELED_SULPHUR_BLOCK))
                        .method_33530(method_32807(PeacefulModBlocks.SULPHUR_BLOCK), method_10426(PeacefulModBlocks.SULPHUR_BLOCK))
                        .method_33530(method_32807(PeacefulModBlocks.CHISELED_SULPHUR_BLOCK), method_10426(PeacefulModBlocks.CHISELED_SULPHUR_BLOCK))
                        , field_53721);
                offerTo(method_32808(PeacefulModBlocks.SULPHUR_STAIRS, class_1856.method_8091(PeacefulModBlocks.SULPHUR_BLOCK, PeacefulModBlocks.CHISELED_SULPHUR_BLOCK))
                        .method_33530(method_32807(PeacefulModBlocks.SULPHUR_BLOCK), method_10426(PeacefulModBlocks.SULPHUR_BLOCK))
                        .method_33530(method_32807(PeacefulModBlocks.CHISELED_SULPHUR_BLOCK), method_10426(PeacefulModBlocks.CHISELED_SULPHUR_BLOCK))
                        , field_53721);
                offerTo(method_32805(class_7800.field_40634, PeacefulModBlocks.CHISELED_SULPHUR_BLOCK, class_1856.method_8101(PeacefulModBlocks.SULPHUR_SLAB))
                        .method_10429(method_32807(PeacefulModBlocks.SULPHUR_BLOCK), method_10426(PeacefulModBlocks.SULPHUR_BLOCK))
                        .method_10429(method_32807(PeacefulModBlocks.CHISELED_SULPHUR_BLOCK), method_10426(PeacefulModBlocks.CHISELED_SULPHUR_BLOCK))
                        , field_53721);
                offerTo(method_33531(class_7800.field_40635, PeacefulModBlocks.SULPHUR_WALL, class_1856.method_8101(PeacefulModBlocks.SULPHUR_BLOCK))
                        .method_33530(method_32807(PeacefulModBlocks.SULPHUR_BLOCK), this.method_10426(PeacefulModBlocks.SULPHUR_BLOCK))
                        , field_53721);

                method_36233(List.of(PeacefulModBlocks.BLAZE_PICKLE), class_7800.field_40642, class_1802.field_8894, 0.45f, 200, PeacefulModBlocks.BLAZE_PICKLE.method_9518().toString());
                method_36233(List.of(PeacefulModBlocks.BREEZE_CORAL), class_7800.field_40642, class_1802.field_49821, 0.45f, 200, PeacefulModBlocks.BREEZE_CORAL.method_9518().toString());
                
                method_36233(List.of(PeacefulModItems.CLAM), class_7800.field_40640, PeacefulModItems.COOKED_CLAM, 0.35f, 200, PeacefulModItems.CLAM.method_63680().toString());

                offerTo(method_62750(class_7800.field_40642, class_1802.field_8192, 1)
                        .method_10454(PeacefulModItems.SULPHUR)
                        .method_10442(method_32807(PeacefulModItems.SULPHUR), method_10426(PeacefulModItems.SULPHUR))
                        , field_53721);

                offerTo(method_62750(class_7800.field_40642, class_1802.field_8492, 1)
                        .method_10454(PeacefulModBlocks.BLAZE_PICKLE)
                        .method_10442(method_32807(PeacefulModBlocks.BLAZE_PICKLE), method_10426(PeacefulModBlocks.BLAZE_PICKLE))
                        , field_53721);

                offerTo(method_62750(class_7800.field_40642, class_1802.field_8298, 1)
                        .method_10454(PeacefulModBlocks.BREEZE_CORAL)
                        .method_10442(method_32807(PeacefulModBlocks.BREEZE_CORAL), method_10426(PeacefulModBlocks.BREEZE_CORAL))
                        , field_53721);

                offerTo(method_62750(class_7800.field_40642, class_1802.field_8614, 2)
                        .method_10449(PeacefulModItems.BAT_WING, 3) 
                        .method_10454(PeacefulModItems.ECTOPLASM)
                        .method_10442(method_32807(PeacefulModItems.BAT_WING), method_10426(PeacefulModItems.BAT_WING))
                        .method_10442(method_32807(PeacefulModItems.ECTOPLASM), method_10426(PeacefulModItems.ECTOPLASM))
                        , field_53721);
                
                offerTo(createEffigyAltar(class_1802.field_8288)
                        .pattern("ebe",
                                 "ggg",
                                  "g")
                        .input('b', class_2246.field_10205)
                        .input('e', class_1802.field_8687)
                        .input('g', class_1802.field_8695)
                        // Advancement that gives the recipe
                        .method_33530(method_32807(class_2246.field_10205), method_10426(class_2246.field_10205))
                        .method_33530(method_32807(class_1802.field_8687), method_10426(class_1802.field_8687))
                        .method_33530(method_32807(class_1802.field_8695), method_10426(class_1802.field_8695))
                        , field_53721);

                createEffigyAltar(PeacefulModItems.DRAGON_EFFIGY)
                        .pattern("ebe",
                                 "wsw",
                                  "g")
                        .input('b', class_2246.field_22423)
                        .input('s', class_2246.field_10471)
                        .input('e', class_1802.field_8449)
                        .input('g', class_2246.field_10540)
                        .input('w', PeacefulModItems.BAT_WING)
                        .cost(15)
                        // Advancement that gives the recipe
                        .method_33530(method_32807(class_2246.field_10471), method_10426(class_2246.field_10471))
                        .method_33530(method_32807(class_2246.field_22423), method_10426(class_2246.field_22423))
                        .method_33530(method_32807(class_1802.field_8449), method_10426(class_1802.field_8449))
                        .method_33530(method_32807(class_2246.field_10540), method_10426(class_2246.field_10540))
                        .method_33530(method_32807(PeacefulModItems.BAT_WING), method_10426(PeacefulModItems.BAT_WING))
                        .method_10431(field_53721);

                createEffigyAltar(PeacefulModItems.GUARDIAN_EFFIGY)
                        .pattern("beb",
                                 "bbb",
                                  "b")
                        .input('b', class_1802.field_8846)
                        .input('e', class_1802.field_8434)
                        // Advancement that gives the recipe
                        .method_33530(method_32807(class_1802.field_8846), method_10426(class_1802.field_8846))
                        .method_33530(method_32807(class_1802.field_8434), method_10426(class_1802.field_8434))
                        .method_10431(field_53721);

                createEffigyAltar(PeacefulModItems.WITHER_EFFIGY)
                        .pattern("bbb",
                                 "eee",
                                  "e")
                        .input('b', class_1802.field_8791)
                        .input('e', class_2246.field_10114)
                        .cost(10)
                        // Advancement that gives the recipe
                        .method_33530(method_32807(class_1802.field_8791), method_10426(class_1802.field_8791))
                        .method_33530(method_32807(class_2246.field_10114), method_10426(class_2246.field_10114))
                        .method_10431(field_53721);

                createEffigyAltar(PeacefulModItems.RAID_EFFIGY)
                        .pattern("ebe",
                                 "ggg",
                                  "g")
                        .input('b', PeacefulModTags.ItemTags.GUANO)
                        .input('e', class_1802.field_8687)
                        .input('g', class_1802.field_8620)
                        // Advancement that gives the recipe
                        .method_33530(method_32807(PeacefulModItems.GUANO), method_10420(PeacefulModTags.ItemTags.GUANO))
                        .method_33530(method_32807(class_1802.field_8687), method_10426(class_1802.field_8687))
                        .method_33530(method_32807(class_1802.field_8620), method_10426(class_1802.field_8620))
                        .method_10431(field_53721);

                offerTo(method_62746(class_7800.field_40638, PeacefulModItems.CAPE)
                        .method_10439("blb")
                        .method_10439("b b")
                        .method_10434('b', PeacefulModItems.BAT_WING)
                        .method_10434('l', class_1802.field_8745)
                        .method_10429(method_32807(PeacefulModItems.BAT_WING), method_10426(PeacefulModItems.BAT_WING))
                        .method_10429(method_32807(class_1802.field_8745), method_10426(class_1802.field_8745))
                        , field_53721);
            }
            
            public EffigyAltarRecipeJsonBuilder createEffigyAltar(class_1935 output) {
                return EffigyAltarRecipeJsonBuilder.create(registryLookup.method_46762(class_7924.field_41197), output);
            }
        };
    }
}
