package xen42.peacefulitems;


import com.google.common.collect.ImmutableSet;
import net.fabricmc.fabric.api.object.builder.v1.trade.TradeOfferHelper;
import net.fabricmc.fabric.api.object.builder.v1.world.poi.PointOfInterestHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1914;
import net.minecraft.class_21;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3489;
import net.minecraft.class_3852;
import net.minecraft.class_3853.class_1652;
import net.minecraft.class_3853.class_1654;
import net.minecraft.class_4158;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7045;
import net.minecraft.class_7430;
import net.minecraft.class_7441;
import net.minecraft.class_7477;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9306;
import net.minecraft.class_9428;

public class PeacefulModVillagers {
    public static final class_5321<class_4158> JUKEBOX_KEY = class_5321.method_29179(class_7924.field_41212, class_2960.method_60655(PeacefulMod.MOD_ID, "jukebox_poi"));
    public static final class_4158 JUKEBOX_POI = registerNewPOI("jukebox_poi", class_2246.field_10223);
    public static final class_5321<class_3852> DJ_VILLAGER_KEY = class_5321.method_29179(class_7924.field_41234, class_2960.method_60655(PeacefulMod.MOD_ID, "dj"));
    public static final class_3852 DJ_VILLAGER = registerNewProfession(DJ_VILLAGER_KEY, JUKEBOX_KEY, class_3417.field_20677);

    public static class_3852 registerNewProfession(class_5321<class_3852> key, class_5321<class_4158> poi, class_3414 sound) {
        var profession = new class_3852(
                class_2561.method_43471("entity." + key.method_29177().method_12836() + ".villager." + key.method_29177().method_12832()),
                entry -> entry.method_40225(poi),
                entry -> entry.method_40225(poi),
                ImmutableSet.of(),
                ImmutableSet.of(),
                sound
            );
        return class_2378.method_10230(class_7923.field_41195, key.method_29177(), profession);
    }

    public static class_4158 registerNewPOI(String name, class_2248 block) {
        return PointOfInterestHelper.register(class_2960.method_60655(PeacefulMod.MOD_ID, name), 1, 1, block);
    }

    
    public static void initialize() {
		class_6880<class_4158> poiTypeEntry = class_7923.field_41128.method_46747(class_7477.field_39285);
		for (class_2680 state : PeacefulModBlocks.DRAGON_BREATH_CAULDRON.method_9595().method_11662())
			class_7477.field_39301.put(state, poiTypeEntry);
		
		// 0.05 is a "low" price modifier. High is 0.2
		// I think level 1 is Novice, level 5 is Master
		TradeOfferHelper.registerVillagerOffers(class_3852.field_17055, 1, factories -> {
			factories.add((entity, random) -> new class_1914(
				new class_9306(class_1802.field_8687, 1),
				new class_1799(class_1802.field_8680, 3), 12, 1, 0.05f));
		});

		// Identical trade to wheat
		TradeOfferHelper.registerVillagerOffers(class_3852.field_17056, 1, factories -> {
			factories.add((entity, random) -> new class_1914(
				new class_9306(PeacefulModItems.FLAX, 20),
				new class_1799(class_1802.field_8687, 1), 16, 2, 0.05f));
		});

		// Identical trade to rabbit hide
		TradeOfferHelper.registerVillagerOffers(class_3852.field_17059, 3, factories -> {
			factories.add((entity, random) -> new class_1914(
				new class_9306(PeacefulModItems.BAT_WING, 9),
				new class_1799(class_1802.field_8687, 1), 12, 20, 0.05f));
		});

        // CUSTOM VILLAGER
        TradeOfferHelper.registerVillagerOffers(DJ_VILLAGER_KEY, 1, factories -> {
			// Same as librarian
            factories.add((entity, random) -> new class_1914(
				new class_9306(class_1802.field_8407, 24),
				new class_1799(class_1802.field_8687, 1), 16, 2, 0.05f));
            factories.add((entity, random) -> new class_1914(
                new class_9306(class_1802.field_8276, 12),
                new class_1799(class_1802.field_8687, 1), 16, 2, 0.05f));
		});

        TradeOfferHelper.registerVillagerOffers(DJ_VILLAGER_KEY, 2, factories -> {
            factories.add((entity, random) -> new class_1914(
				new class_9306(class_1802.field_8687, 2),
				new class_1799(class_2246.field_10179, 1), 12, 5, 0.05f));
            factories.add((entity, random) -> RandomHorn(entity, random));
		});

        TradeOfferHelper.registerVillagerOffers(DJ_VILLAGER_KEY, 3, factories -> {
            factories.add((entity, random) -> new class_1914(
				new class_9306(class_1802.field_8687, 6),
				new class_1799(class_2246.field_10223, 1), 12, 20, 0.05f));
            factories.add((entity, random) -> RandomDisc(entity, random));
		});

        TradeOfferHelper.registerVillagerOffers(DJ_VILLAGER_KEY, 4, factories -> {
            factories.add((entity, random) -> new class_1914(
				new class_9306(class_1802.field_8687, 12),
				new class_1799(class_2246.field_16332, 1), 12, 20, 0.05f));
            factories.add((entity, random) -> RandomDisc(entity, random));
		});

        TradeOfferHelper.registerVillagerOffers(DJ_VILLAGER_KEY, 5, factories -> {
            factories.add((entity, random) -> RandomHorn(entity, random));
            factories.add((entity, random) -> RandomDisc(entity, random));
		});

		TradeOfferHelper.registerWanderingTraderOffers(builder -> {
			builder.addOffersToPool(
				TradeOfferHelper.WanderingTraderOffersBuilder.SELL_SPECIAL_ITEMS_POOL, 
				new TradeOfferFactory(new class_1914(
					new class_9306(class_1802.field_8687, 5),
					new class_1799(class_1802.field_47315, 1), 12, 20, 0.05f)
				),
				new TradeOfferFactory(new class_1914(
					new class_9306(class_1802.field_8687, 10),
					new class_1799(class_1802.field_50139, 1), 12, 20, 0.05f)
				),
				new TradeOfferFactory(new class_1914(
					new class_9306(class_1802.field_8687, 5),
					new class_1799(class_1802.field_41304, 1), 12, 20, 0.05f)
				),
				new TradeOfferFactory(new class_1914(
					new class_9306(class_1802.field_8687, 5),
					new class_1799(class_1802.field_8681, 1), 12, 20, 0.05f)
				),
				new TradeOfferFactory(new class_1914(
					new class_9306(class_1802.field_8687, 5),
					new class_1799(class_1802.field_8470, 1), 12, 20, 0.05f)
				)
			);
		});
		
		TradeOfferHelper.registerVillagerOffers(class_3852.field_17054, 3, factories -> {
			// Map to altar
			factories.add((entity, random) -> SellMap(entity, random, 10,
				PeacefulModTags.StructureTags.EFFIGY_ALTAR_DUNGEON, class_21.field_84, 4, 15));
			
			// Map to trail ruin
			factories.add((entity, random) -> SellMap(entity, random, 10,
				PeacefulModTags.StructureTags.TRAIL_RUINS, class_21.field_84, 12, 10));
			
			// Map to ocean ruin
			factories.add((entity, random) -> SellMap(entity, random, 10,
				class_7045.field_37049, class_21.field_84, 12, 10));
		});
    }
    
    private static class_1914 SellMap(class_1297 entity, class_5819 random, int price, class_6862<class_3195> structure, class_6880<class_9428> decoration, int maxUses, int experience) {
    	return new class_1654(price, structure, 
    		"filled_map." + structure.comp_327().method_12836() + "." + structure.comp_327().method_12832(),
    		decoration, maxUses, experience).method_7246(entity, random);
    }

    private static class_1914 RandomDisc(class_1297 entity, class_5819 random) {
        var item = entity.method_73183().method_30349().method_30530(class_7924.field_41197).method_73042(class_3489.field_23969, random).get();
        return new class_1914(
            new class_9306(class_1802.field_8687, 24),
            new class_1799(item, 1), 1, 30, 0.05f);
    }

	private static class_1914 RandomHorn(class_1297 entity, class_5819 random) {
		var tag = random.method_43056() ? class_7441.field_39107 : class_7441.field_39106;
		var horn = entity.method_73183().method_30349().method_30530(class_7924.field_41275).method_73042(tag, random)
			.map(registryEntry -> class_7430.method_43558(class_1802.field_39057, registryEntry))
			.orElseGet(() -> new class_1799(class_1802.field_39057));
		return new class_1914(
			new class_9306(class_1802.field_8687, 6),
			horn, 2, 5, 0.05f);
	}

	private static class TradeOfferFactory implements class_1652 {
		private class_1914 _tradeOffer;

		public TradeOfferFactory(class_1914 tradeOffer) {
			_tradeOffer = tradeOffer;
		}

		@Override
		public class_1914 method_7246(class_1297 arg0, class_5819 arg1) {
			return _tradeOffer.method_53881();
		}
	}
}
