package xen42.peacefulitems.blocks;

import net.minecraft.class_10225;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import xen42.peacefulitems.PeacefulModItems;

public class SulphurClusterBlock extends class_2248 implements class_3737 {
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2754<class_2350> FACING = class_2741.field_12525;
    protected final class_265 northShape;
    protected final class_265 southShape;
    protected final class_265 eastShape;
    protected final class_265 westShape;
    protected final class_265 upShape;
    protected final class_265 downShape;

    public SulphurClusterBlock(int height, int xzOffset, class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657(WATERLOGGED, false)).method_11657(FACING, class_2350.field_11036));
        this.upShape = class_2248.method_9541(xzOffset, 0.0, xzOffset, 16 - xzOffset, height, 16 - xzOffset);
        this.downShape = class_2248.method_9541(xzOffset, 16 - height, xzOffset, 16 - xzOffset, 16.0, 16 - xzOffset);
        this.northShape = class_2248.method_9541(xzOffset, xzOffset, 16 - height, 16 - xzOffset, 16 - xzOffset, 16.0);
        this.southShape = class_2248.method_9541(xzOffset, xzOffset, 0.0, 16 - xzOffset, 16 - xzOffset, height);
        this.eastShape = class_2248.method_9541(0.0, xzOffset, xzOffset, height, 16 - xzOffset, 16 - xzOffset);
        this.westShape = class_2248.method_9541(16 - height, xzOffset, xzOffset, 16.0, 16 - xzOffset, 16 - xzOffset);
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        switch (state.method_11654(FACING)) {
            case field_11043: {
                return this.northShape;
            }
            case field_11035: {
                return this.southShape;
            }
            case field_11034: {
                return this.eastShape;
            }
            case field_11039: {
                return this.westShape;
            }
            case field_11033: {
                return this.downShape;
            }
            default:
                break;
        }
        return this.upShape;
    }

    @Override
    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2350 lv = state.method_11654(FACING);
        class_2338 lv2 = pos.method_10093(lv.method_10153());
        return world.method_8320(lv2).method_26206(world, lv2, lv);
    }

    @Override
    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_1937 lv = ctx.method_8045();
        class_2338 lv2 = ctx.method_8037();
        return (class_2680)((class_2680)this.method_9564().method_11657(WATERLOGGED, lv.method_8316(lv2).method_15772() == class_3612.field_15910)).method_11657(FACING, ctx.method_8038());
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657(FACING, rotation.method_10503(state.method_11654(FACING)));
    }

    @Override
    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345(state.method_11654(FACING)));
    }

    @Override
    public class_3610 method_9545(class_2680 state) {
        if (state.method_11654(WATERLOGGED).booleanValue()) {
            return class_3612.field_15910.method_15729(false);
        }
        return super.method_9545(state);
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(WATERLOGGED, FACING);
    }

    @Override
    protected class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state, boolean includeData) {
        return new class_1799(PeacefulModItems.SULPHUR);
    }

    protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        if ((Boolean)state.method_11654(WATERLOGGED)) {
            tickView.method_64312(pos, class_3612.field_15910, class_3612.field_15910.method_15789(world));
        }

        return direction == ((class_2350)state.method_11654(FACING)).method_10153() && !state.method_26184(world, pos) ? class_2246.field_10124.method_9564() : super.method_9559(state, world, tickView, pos, direction, neighborPos, neighborState, random);
   }
}
