package xen42.peacefulitems.eiv;

import de.crafty.eiv.common.api.recipe.EivRecipeType;
import de.crafty.eiv.common.api.recipe.IEivServerRecipe;
import de.crafty.eiv.common.recipe.util.EivTagUtil;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2487;
import net.minecraft.class_2960;

import static xen42.peacefulitems.PeacefulMod.MOD_ID;

public class EffigyAltarServerRecipe implements IEivServerRecipe {
    public static final EivRecipeType<EffigyAltarServerRecipe> TYPE = EivRecipeType.register(
            class_2960.method_60655(MOD_ID,"effigy"),
            () -> new EffigyAltarServerRecipe(null, null, 0)
    );
    private int cost;
    private List<Optional<class_1856>> ingredients;
    private class_1799 result;

    public EffigyAltarServerRecipe(List<Optional<class_1856>> ingredients, class_1799 result, int cost) {
        this.ingredients = ingredients;
        this.result = result;
        this.cost = cost;
    }


    @Override
    public void writeToTag(class_2487 tag) {
        tag.method_10566("ingredients", EivTagUtil.writeList(this.ingredients, (origin, tag1) -> origin.map(EivTagUtil::writeIngredient).orElseGet(class_2487::new)));
        tag.method_10566("result", EivTagUtil.encodeItemStackOnServer(this.result));
        tag.method_10569("cost", this.cost);
    }

    @Override
    public void loadFromTag(class_2487 tag) {
        this.ingredients = EivTagUtil.readList(tag, "ingredients", (nbtCompound)-> Optional.ofNullable(EivTagUtil.readIngredient(nbtCompound)));
        this.result = EivTagUtil.decodeItemStackOnClient(tag.method_10562("result").orElseGet(class_2487::new));
        this.cost = tag.method_68083("experience", 5);
    }

    @Override
    public EivRecipeType<? extends IEivServerRecipe> getRecipeType() {
        return TYPE;
    }

    public List<Optional<class_1856>> getIngredients() {
        return ingredients;
    }

    public class_1799 getResult() {
        return result;
    }
}
