package xen42.peacefulitems.eiv;

import de.crafty.eiv.common.api.recipe.IEivRecipeViewType;
import de.crafty.eiv.common.recipe.inventory.RecipeViewMenu;
import xen42.peacefulitems.PeacefulModBlocks;

import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

import static xen42.peacefulitems.PeacefulMod.MOD_ID;

public class EffigyAltarViewType implements IEivRecipeViewType {

    public static final EffigyAltarViewType INSTANCE = new EffigyAltarViewType();

    @Override
    public class_2561 getDisplayName() {
        return class_2561.method_43471("block.peaceful-items.effigy_altar");
    }

    @Override
    public int getDisplayWidth() {
        return 150;
    }

    @Override
    public int getDisplayHeight() {
        return 75;
    }

    @Override
    public class_2960 getGuiTexture() {
        return class_2960.method_60655(MOD_ID, "textures/gui/effigy_altar_eiv.png");
    }

    @Override
    public int getSlotCount() {
        return 9;
    }

    @Override
    public void placeSlots(RecipeViewMenu.SlotDefinition builder) {
        //ingredients
        builder.addItemSlot(0, 11, 13);
        builder.addItemSlot(1, 29, 13);
        builder.addItemSlot(2, 47, 13);
        builder.addItemSlot(3, 11, 31);
        builder.addItemSlot(4, 29, 31);
        builder.addItemSlot(5, 47, 31);
        builder.addItemSlot(6, 29, 49);
        //brimstone
        builder.addItemSlot(7, 78, 41);
        //output
        builder.addItemSlot(8, 121, 18);
    }

    @Override
    public class_2960 getId() {
        return class_2960.method_60655(MOD_ID, "effigy_altar");
    }

    @Override
    public class_1799 getIcon() {
        return PeacefulModBlocks.EFFIGY_ALTAR.method_8389().method_7854();
    }

    @Override
    public List<class_1799> getCraftReferences() {
        return List.of(PeacefulModBlocks.EFFIGY_ALTAR.method_8389().method_7854());
    }

}
