package xen42.peacefulitems.mixin;

import xen42.peacefulitems.PeacefulMod;
import xen42.peacefulitems.PeacefulModItems;
import xen42.peacefulitems.entities.BatHelper;

import java.util.List;
import java.util.Random;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1303;
import net.minecraft.class_1420;
import net.minecraft.class_1657;
import net.minecraft.class_1802;
import net.minecraft.class_1928;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3468;
import net.minecraft.class_3730;
import net.minecraft.class_5575;
import net.minecraft.class_5712;
import net.minecraft.class_6024;
import net.minecraft.class_8779;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1420.class)
public class BatEntityMixin {
	private static final Random random = new Random();

	@Inject(at = @At("TAIL"), method = "initDataTracker")
    public void initDataTracker(class_2945.class_9222 builder, CallbackInfo info) {
		builder.method_56912(PeacefulMod.BAT_BREEDING_TICKS, 0);
		builder.method_56912(PeacefulMod.BAT_IS_BABY, false);
		builder.method_56912(PeacefulMod.BAT_BREEDING_COOLDOWN, 0);
    }

	@Inject(at = @At("HEAD"), method = "tick")
	private void tick(CallbackInfo info) {
		var bat = ((class_1420)(Object)this);

		// On average once every X seconds, I think!
		// 20 ticks per second
		if (!bat.method_73183().method_8608() && bat.method_5805() && !bat.method_6109() && random.nextFloat() < 1f / (300f * 20f)) {
			bat.method_32876(class_5712.field_28738);
			bat.method_5783(class_3417.field_15219, 1.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f);
            bat.method_5706((class_3218)bat.method_73183(), PeacefulModItems.GUANO);
		}
	}

	@Inject(at = @At("RETURN"), method = "isPushable", cancellable = true)
	private void isPushable(CallbackInfoReturnable<Boolean> info) {
		info.setReturnValue(true);
		info.cancel();
	}

	@Inject(at = @At("HEAD"), method = "pushAway")
	private void pushAway(class_1297 entity, CallbackInfo info) {
		var bat = ((class_1420)(Object)this);
		entity.method_5697(bat);
	}

	@Inject(at = @At("HEAD"), method = "tickCramming")
	private void tickCramming(CallbackInfo info) {
		var bat = ((class_1420)(Object)this);

		if (!(bat.method_73183() instanceof class_3218 serverWorld)) {
			bat.method_73183()
				.method_18023(class_5575.method_31795(class_1657.class), bat.method_5829(), class_1301.method_5911(bat))
				.forEach((entity) -> entity.method_5697(bat));
		} else {
			List<class_1297> list = bat.method_73183().method_8333(bat, bat.method_5829(), class_1301.method_5911(bat));
			if (!list.isEmpty()) {
				int i = serverWorld.method_64395().method_8356(class_1928.field_19405);
				if (i > 0 && list.size() > i - 1 && random.nextInt(4) == 0) {
					int j = 0;

					for (class_1297 entity : list) {
						if (!entity.method_5765()) {
							j++;
						}
					}

					if (j > i - 1) {
						bat.method_64397(serverWorld, bat.method_48923().method_48823(), 6.0F);
					}
				}

				for (class_1297 entity2 : list) {
					entity2.method_5697(bat);
				}
			}
		}
	}

	@Inject(at = @At("HEAD"), method = "mobTick", cancellable = true)
    public void mobTick(class_3218 world, CallbackInfo info) {
		var bat = ((class_1420)(Object)this);
		var player = world.method_18460(bat, 10);
		if (!bat.method_6450()) {
			var breedingTicks = bat.method_5841().method_12789(PeacefulMod.BAT_BREEDING_TICKS);
			var batBreedingCooldown = bat.method_5841().method_12789(PeacefulMod.BAT_BREEDING_COOLDOWN);
			if (bat.method_6109() && batBreedingCooldown <= 0) {
				bat.method_5841().method_12778(PeacefulMod.BAT_IS_BABY, false);
			}
			if (batBreedingCooldown > 0) {
				bat.method_5841().method_12778(PeacefulMod.BAT_BREEDING_COOLDOWN, batBreedingCooldown - 1);
			}
			if (!bat.method_6109() && breedingTicks > 0) {
				bat.method_5841().method_12778(PeacefulMod.BAT_BREEDING_TICKS, breedingTicks - 1);

        		List<class_1420> list = world.method_18467(class_1420.class, bat.method_5829().method_1014(10.0));
				class_1420 mate = null;
				for (var otherBat : list) {
					if (otherBat != bat && otherBat.method_5841().method_12789(PeacefulMod.BAT_BREEDING_TICKS) > 0) {
						mate = otherBat;
					}
				}
				if (mate != null) {
					if (mate.method_5739(bat) < 0.5f) {
						var baby = class_1299.field_6108.method_5883(world, class_3730.field_16466);
						baby.method_5808(bat.method_23317(), bat.method_23318(), bat.method_23321(), 0.0f, 0.0f);
						world.method_30771(baby);
						world.method_8421(bat, class_6024.field_30043);
						if (world.method_64395().method_8355(class_1928.field_19391)) {
							world.method_8649(new class_1303(world, bat.method_23322(1.0), bat.method_23319() + 0.5, bat.method_23325(1.0), bat.method_59922().method_43048(7) + 1));
						}
						for (int i = 0; i < 7; ++i) {
							double d = bat.method_59922().method_43059() * 0.02;
							double e = bat.method_59922().method_43059() * 0.02;
							double f = bat.method_59922().method_43059() * 0.02;
							world.method_8406(class_2398.field_11201, bat.method_23322(1.0), bat.method_23319() + 0.5, bat.method_23325(1.0), d, e, f);
						}

						bat.method_5841().method_12778(PeacefulMod.BAT_BREEDING_TICKS, 0);
						mate.method_5841().method_12778(PeacefulMod.BAT_BREEDING_TICKS, 0);
						baby.method_5841().method_12778(PeacefulMod.BAT_IS_BABY, true);

						bat.method_5841().method_12778(PeacefulMod.BAT_BREEDING_COOLDOWN, PeacefulMod.BatBreedingCooldown);
						mate.method_5841().method_12778(PeacefulMod.BAT_BREEDING_COOLDOWN, PeacefulMod.BatBreedingCooldown);
						// Breeding cooldown doubles as age timer because why not
						baby.method_5841().method_12778(PeacefulMod.BAT_BREEDING_COOLDOWN, PeacefulMod.BatGrowUpTicks);

						if (player != null && player instanceof class_3222 serverPlayer && serverPlayer.method_51469().method_8503() != null) {
							serverPlayer.method_7281(class_3468.field_15410);
							// Grant the player the "The Parrots and the Bats" advancement
							class_8779 parrotsAndBats = serverPlayer.method_51469().method_8503().method_3851().method_12896(class_2960.method_60656("husbandry/breed_an_animal"));
							if (parrotsAndBats != null)
							{
								String first = parrotsAndBats.comp_1920().comp_1915().keySet().iterator().next();
								serverPlayer.method_14236().method_12878(parrotsAndBats, first);
							}
						}
					}
					else {
						BatHelper.FlyTowards(bat, mate.method_73189());
					}
					info.cancel();
					return;
				}
			}
			if (player != null && player.method_24518(class_1802.field_8497)) {
				var playerPos = player.method_73189().method_1019(player.method_5735().method_62676());

				BatHelper.FlyTowards(bat, playerPos.method_1019(new class_243(0f, 1.0f, 0f)));
				info.cancel();
			}
		}
	}

	@Inject(at = @At("TAIL"), method = "writeCustomData")
	public void writeCustomDataToNbt(class_11372 view, CallbackInfo ci) {
		var bat = ((class_1420)(Object)this);

		view.method_71472("IsBaby", bat.method_5841().method_12789(PeacefulMod.BAT_IS_BABY));
		view.method_71465("BreedingTicks", bat.method_5841().method_12789(PeacefulMod.BAT_BREEDING_TICKS));
		view.method_71465("BreedingCooldown", bat.method_5841().method_12789(PeacefulMod.BAT_BREEDING_COOLDOWN));
	}

	@Inject(at = @At("TAIL"), method = "readCustomData")
	public void readCustomDataFromNbt(class_11368 view, CallbackInfo ci) {
		var bat = ((class_1420)(Object)this);

		bat.method_5841().method_12778(PeacefulMod.BAT_IS_BABY, view.method_71433("IsBaby", false));
		bat.method_5841().method_12778(PeacefulMod.BAT_BREEDING_TICKS, view.method_71424("BreedingTicks", 0));
		bat.method_5841().method_12778(PeacefulMod.BAT_BREEDING_COOLDOWN, view.method_71424("BreedingCooldown", 0));
	}
}