package xen42.peacefulitems.recipe;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_10295;
import net.minecraft.class_10302;
import net.minecraft.class_10302.class_10306;
import net.minecraft.class_10302.class_10307;
import net.minecraft.class_10352;
import net.minecraft.class_10358;
import net.minecraft.class_7699;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import xen42.peacefulitems.PeacefulModItems;

public record EffigyAltarRecipeDisplay(List<class_10302> ingredients, BrimstoneSlotDisplay brimstone, class_10307 result, int cost, class_10306 craftingStation)
	implements class_10295 {
	public static final MapCodec<EffigyAltarRecipeDisplay> CODEC = RecordCodecBuilder.mapCodec(
		instance -> instance.group(
				class_10302.field_54671.listOf().fieldOf("ingredients").forGetter(EffigyAltarRecipeDisplay::ingredients),
				BrimstoneSlotDisplay.CODEC.fieldOf("brimstone").forGetter(EffigyAltarRecipeDisplay::brimstone),
				class_10307.field_54688.fieldOf("result").forGetter(EffigyAltarRecipeDisplay::comp_3258),
				Codec.INT.fieldOf("cost").forGetter(EffigyAltarRecipeDisplay::cost),
				class_10306.field_54685.fieldOf("crafting_station").forGetter(EffigyAltarRecipeDisplay::comp_3259)
			)
			.apply(instance, EffigyAltarRecipeDisplay::new)
	);
	public static final class_9139<class_9129, EffigyAltarRecipeDisplay> field_54662 = class_9139.method_56906(
		class_10302.field_54672.method_56433(class_9135.method_56363()),
		EffigyAltarRecipeDisplay::ingredients,
		BrimstoneSlotDisplay.field_54672,
		EffigyAltarRecipeDisplay::brimstone,
		class_10307.field_54689,
		EffigyAltarRecipeDisplay::comp_3258,
		class_9135.field_49675,
		EffigyAltarRecipeDisplay::cost,
		class_10306.field_54686,
		EffigyAltarRecipeDisplay::comp_3259,
		EffigyAltarRecipeDisplay::new
	);
	public static final class_10295.class_10296<EffigyAltarRecipeDisplay> SERIALIZER = new class_10295.class_10296<>(CODEC, field_54662);

	public static final int MAX_INGREDIENTS = (3 * 2) + 1;
	
	public EffigyAltarRecipeDisplay(List<class_10302> ingredients, BrimstoneSlotDisplay brimstone, class_10307 result, int cost, class_10306 craftingStation) {
		List<class_10302> subbedIngredients = ingredients.subList(0, MAX_INGREDIENTS);
		if (subbedIngredients.size() != MAX_INGREDIENTS) {
			throw new IllegalArgumentException("Invalid shaped recipe display contents");
		} else {
			this.ingredients = subbedIngredients;
			this.brimstone = brimstone;
			this.result = result;
			this.cost = cost;
			this.craftingStation = craftingStation;
		}
	}

	@Override
	public class_10295.class_10296<EffigyAltarRecipeDisplay> method_64726() {
		return SERIALIZER;
	}

	@Override
	public boolean method_64728(class_7699 features) {
		return this.ingredients.stream().allMatch(ingredient -> ingredient.method_64737(features)) && class_10295.super.method_64728(features);
	}
	
	public static class BrimstoneSlotDisplay implements class_10302 {
		public static final BrimstoneSlotDisplay INSTANCE = new BrimstoneSlotDisplay();
		public static final MapCodec<BrimstoneSlotDisplay> CODEC = MapCodec.unit(INSTANCE);
		public static final class_9139<class_9129, BrimstoneSlotDisplay> PACKET_CODEC = class_9139.method_56431(INSTANCE);
		public static final class_10302.class_10312<BrimstoneSlotDisplay> SERIALIZER = new class_10302.class_10312<>(CODEC, PACKET_CODEC);

		private BrimstoneSlotDisplay() {
		}

		@Override
		public class_10302.class_10312<BrimstoneSlotDisplay> method_64736() {
			return SERIALIZER;
		}

		public String toString() {
			return "Brimstone";
		}

		@Override
		public <T> Stream<T> method_64739(class_10352 parameters, class_10358<T> factory) {
			if (factory instanceof class_10358.class_10360<T> fromStack) {
				return Stream.of(fromStack.method_64998(PeacefulModItems.SULPHUR));
			}

			return Stream.empty();
		}
	}
}
