package xen42.peacefulitems.recipe;

import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_9695;
import net.minecraft.class_9875;

public class EffigyAltarRecipeInput implements class_9695 {
	private static final int MAX_WIDTH_AND_HEIGHT = 3;
	private final List<class_1799> stacks;
	private final class_9875 matcher = new class_9875();
	private final int stackCount;

	private EffigyAltarRecipeInput(List<class_1799> stacks) {
		this.stacks = stacks;
		int i = 0;

		for (class_1799 itemStack : stacks) {
			if (!itemStack.method_7960()) {
				i++;
				this.matcher.method_61536(itemStack, 1);
			}
		}

		this.stackCount = i;
	}

	public static EffigyAltarRecipeInput create(List<class_1799> stacks) {
		return new EffigyAltarRecipeInput(stacks);
	}

	@Override
	public class_1799 method_59984(int slot) {
		return (class_1799)this.stacks.get(slot);
	}

	public class_1799 getStackInSlot(int x, int y) {
		return (class_1799)this.stacks.get(x + y * MAX_WIDTH_AND_HEIGHT);
	}

	@Override
	public int method_59983() {
		return this.stacks.size();
	}

	@Override
	public boolean method_59987() {
		return this.stackCount == 0;
	}

	public class_9875 getRecipeMatcher() {
		return this.matcher;
	}

	public List<class_1799> getStacks() {
		return this.stacks;
	}

	public int getStackCount() {
		return this.stackCount;
	}
	
	public static boolean stacksEqual(List<class_1799> left, List<class_1799> right) {
		if (left.size() != right.size()) {
			return false;
		} else {
			for (int i = 0; i < left.size(); i++) {
				if (!class_1799.method_7973((class_1799)left.get(i), (class_1799)right.get(i))) {
					return false;
				}
			}

			return true;
		}
	}

	public boolean equals(Object o) {
		if (o == this) {
			return true;
		} else {
			return !(o instanceof EffigyAltarRecipeInput effigyAltarRecipeInput)
				? false
				: this.stackCount == effigyAltarRecipeInput.stackCount
					&& stacksEqual(this.stacks, effigyAltarRecipeInput.stacks);
		}
	}

	public int hashCode() {
		int i = 0;
		
		for (class_1799 itemStack : this.stacks) {
			i = i * 31 + class_1799.method_57355(itemStack);
		}

		return i;
	}
}
