package xen42.peacefulitems.rei;

import java.util.List;
import java.util.Optional;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.plugin.client.displays.ClientsidedRecipeBookDisplay;
import net.minecraft.class_10298;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import xen42.peacefulitems.recipe.EffigyAltarRecipeDisplay;

public class ClientsidedEffigyAltarREIDisplay extends EffigyAltarREIDisplay implements ClientsidedRecipeBookDisplay {
	public static final DisplaySerializer<ClientsidedEffigyAltarREIDisplay> SERIALIZER = DisplaySerializer.of(
			RecordCodecBuilder.mapCodec(instance -> instance.group(
					EntryIngredient.codec().listOf().fieldOf("inputs").forGetter(ClientsidedEffigyAltarREIDisplay::getInputEntries),
					EntryIngredient.codec().listOf().fieldOf("outputs").forGetter(ClientsidedEffigyAltarREIDisplay::getOutputEntries),
					Codec.INT.fieldOf("cost").forGetter(ClientsidedEffigyAltarREIDisplay::getCost),
					Codec.INT.xmap(class_10298::new, class_10298::comp_3267).optionalFieldOf("id").forGetter(ClientsidedEffigyAltarREIDisplay::recipeDisplayId)
			).apply(instance, ClientsidedEffigyAltarREIDisplay::new)),
			class_9139.method_56905(
					EntryIngredient.streamCodec().method_56433(class_9135.method_56363()),
					ClientsidedEffigyAltarREIDisplay::getInputEntries,
					EntryIngredient.streamCodec().method_56433(class_9135.method_56363()),
					ClientsidedEffigyAltarREIDisplay::getOutputEntries,
					class_9135.field_49675,
					ClientsidedEffigyAltarREIDisplay::getCost,
					class_9135.method_56382(class_9135.field_49675.method_56432(class_10298::new, class_10298::comp_3267)),
					ClientsidedEffigyAltarREIDisplay::recipeDisplayId,
					ClientsidedEffigyAltarREIDisplay::new
			), false);
	
	private final Optional<class_10298> id;
	
	public ClientsidedEffigyAltarREIDisplay(EffigyAltarRecipeDisplay recipe, Optional<class_10298> id) {
		super(recipe);
		this.id = id;
	}
	
	public ClientsidedEffigyAltarREIDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, int cost, Optional<class_10298> id) {
		super(inputs, outputs, cost);
		this.id = id;
	}

	@Override
	public Optional<class_10298> recipeDisplayId() {
		return id;
	}

	@Override
	public DisplaySerializer<? extends Display> getSerializer() {
		return SERIALIZER;
	}

	@Override
	public CategoryIdentifier<?> getCategoryIdentifier() {
		return EffigyAltarServerPlugin.EFFIGY_ALTAR_CATEGORY;
	}
}
