package xen42.peacefulitems.rei;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

import me.shedaniel.rei.api.client.registry.transfer.simple.SimpleTransferHandler;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_746;
import xen42.peacefulitems.screen.EffigyAltarScreenHandler;

public class EffigyAltarTransferHandler implements SimpleTransferHandler {
	
	public EffigyAltarScreenHandler getEffigyAltarMenu(Context context) {
		if (context.getMenu() instanceof EffigyAltarScreenHandler altarMenu) {
			return altarMenu;
		}
		else {
			return null;
		}
	}
	
	@Override
	public ApplicabilityResult checkApplicable(Context context) {
		if (context.getMenu() instanceof EffigyAltarScreenHandler
				&& context.getDisplay().getCategoryIdentifier() == EffigyAltarServerPlugin.EFFIGY_ALTAR_CATEGORY
				&& context.getContainerScreen() != null) {
			return ApplicabilityResult.createApplicable();
		}
		else {
			return ApplicabilityResult.createNotApplicable();
		}
	}
	
	@Override
	public Iterable<SlotAccessor> getInputSlots(Context context) {
		EffigyAltarScreenHandler altarMenu = getEffigyAltarMenu(context);
		List<class_1735> slots = altarMenu.getInputSlots();
		List<SlotAccessor> accessors = new ArrayList<SlotAccessor>();
		for (class_1735 slot : slots) {
			accessors.add(SlotAccessor.fromSlot(slot));
		}
		accessors.add(SlotAccessor.fromSlot(altarMenu.getBrimstoneSlot()));
		return accessors;
	}
	
	@Override
	public Iterable<SlotAccessor> getInventorySlots(Context context) {
		class_746 player = context.getMinecraft().field_1724;
		class_1661 inventory = player.method_31548();
		return IntStream.range(0, inventory.method_67533().size())
				.mapToObj(index -> SlotAccessor.fromPlayerInventory(player, index))
				.collect(Collectors.toList());
	}
}