package xen42.peacefulitems.screen;

import java.util.ArrayList;
import java.util.List;

import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_10295;
import net.minecraft.class_10302;
import net.minecraft.class_10352;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_507;
import net.minecraft.class_516;
import net.minecraft.class_8666;
import net.minecraft.class_9875;
import net.minecraft.class_9934;
import xen42.peacefulitems.PeacefulMod;
import xen42.peacefulitems.payloads.GhostRecipeCostRequest;
import xen42.peacefulitems.recipe.EffigyAltarRecipeDisplay;

public class EffigyAltarRecipeBookWidget extends class_507<EffigyAltarScreenHandler> {
	private static final class_8666 TEXTURES = new class_8666(
		class_2960.method_60656("recipe_book/filter_enabled"),
		class_2960.method_60656("recipe_book/filter_disabled"),
		class_2960.method_60656("recipe_book/filter_enabled_highlighted"),
		class_2960.method_60656("recipe_book/filter_disabled_highlighted")
	);
	private static final class_2561 TOGGLE_CRAFTABLE_TEXT = class_2561.method_43471("gui.recipebook.toggleRecipes.craftable");
	private static final List<class_507.class_10329> TABS = List.of(
		new class_507.class_10329(class_1802.field_8288, PeacefulMod.EFFIGY_ALTAR_RECIPE_BOOK_CATEGORY)
	);

	public EffigyAltarRecipeBookWidget(EffigyAltarScreenHandler screenHandler) {
		super(screenHandler, TABS);
	}

    @Override
    protected boolean method_62023(class_1735 slot) {
        return this.field_3095.getOutputSlot() == slot || this.field_3095.getInputSlots().contains(slot) || this.field_3095.getBrimstoneSlot() == slot;
    }

	private boolean canDisplay(class_10295 display) {
		return true;
	}
	
	public boolean isShowingGhostRecipes() {
		return !this.field_52843.field_52827.isEmpty();
	}
	
	public List<class_1799> getGhostInputs() {
	    List<class_1799> inputs = new ArrayList<>();
	    for (class_9934.class_9935 cyclingItem : this.field_52843.field_52827.values()) {
	        if (!cyclingItem.comp_2984()) {
	            inputs.add(cyclingItem.method_62035(0)); // Add the first item from each input stack
	        }
	    }
	    return inputs;
	}
	
	public class_1799 getGhostResult() {
	    for (class_9934.class_9935 cyclingItem : this.field_52843.field_52827.values()) {
	        if (cyclingItem.comp_2984()) {
	            return cyclingItem.method_62035(0);
	        }
	    }
	    return class_1799.field_8037;
	}

	@Override
	protected void method_64868(class_9934 ghostRecipe, class_10295 display, class_10352 context) {
		EffigyAltarRecipeDisplay effigyAltarDisplay = (EffigyAltarRecipeDisplay)display;
		ghostRecipe.method_64874(this.field_3095.getOutputSlot(), context, effigyAltarDisplay.comp_3258());
		List<class_1735> inputSlots = this.field_3095.getInputSlots();
		List<class_10302> ingredients = effigyAltarDisplay.ingredients(); 
		for (int i = 0; i < inputSlots.size(); i++) {
			ghostRecipe.method_64872(inputSlots.get(i), context, ingredients.get(i));
		}
		ghostRecipe.method_64872(this.field_3095.getBrimstoneSlot(), context, effigyAltarDisplay.brimstone());
		ClientPlayNetworking.send(new GhostRecipeCostRequest(getGhostInputs()));
	}

	@Override
	protected void method_2585() {
		this.field_3088.method_1962(TEXTURES);
	}

    @Override
	protected class_2561 method_17064() {
		return TOGGLE_CRAFTABLE_TEXT;
	}

	@Override
	protected void method_62024(class_516 recipeResultCollection, class_9875 recipeFinder) {
		recipeResultCollection.method_64884(recipeFinder, this::canDisplay);
	}
}
