package xen42.peacefulitems.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1729;
import net.minecraft.class_1731;
import net.minecraft.class_1732;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2653;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_5421;
import net.minecraft.class_6880;
import net.minecraft.class_8566;
import net.minecraft.class_8786;
import net.minecraft.class_9875;
import org.jetbrains.annotations.Nullable;

import com.google.common.collect.Lists;

import it.unimi.dsi.fastutil.ints.IntList;
import xen42.peacefulitems.PeacefulMod;
import xen42.peacefulitems.PeacefulModBlocks;
import xen42.peacefulitems.PeacefulModItems;
import xen42.peacefulitems.recipe.EffigyAltarRecipe;
import xen42.peacefulitems.recipe.EffigyAltarRecipeInput;

public class EffigyAltarScreenHandler extends class_1729 {

    public static final int OUTPUT_SLOT = 0;
    public static final int INPUT_SLOTS_START = 1;
    public static final int INPUT_SLOTS_END = 7;
    public static final int BRIMSTONE_SLOT = 8;
    public static final int MAX_WIDTH_AND_HEIGHT = 3;
    public static final int MAX_WIDTH_END = 1;
    public static final int INVENTORY_SLOTS_START = 9;
    public static final int INVENTORY_SLOTS_END = 35;
    public static final int HOTBAR_SLOTS_START = 36;
    public static final int HOTBAR_SLOTS_END = 45;

    public final class_8566 inventory;
    private final class_1731 resultInventory;
    private final class_3915 levelCost = class_3915.method_17403();

    public class_3914 context;
    private final class_1657 player;

    public boolean canTake(int xpCost) {
        return (player.method_56992() || player.field_7520 >= xpCost) && xpCost > 0;
    }

    public boolean canTake() {
        return canTake(getOutputXPCost());
    }

    public boolean hasOutput() {
        return _outputSlot.method_7681();
    }
    
    public static int getXPCost(class_3218 serverWorld, List<class_1799> input) {
        EffigyAltarRecipeInput recipeInput = EffigyAltarRecipeInput.create(input);
        Optional<class_8786<EffigyAltarRecipe>> optional = serverWorld.method_64577().method_8132(PeacefulMod.EFFIGY_ALTAR_RECIPE_TYPE, recipeInput, serverWorld);
        if (optional.isPresent()) {
            class_8786<EffigyAltarRecipe> recipeEntry = (class_8786<EffigyAltarRecipe>)optional.get();
            EffigyAltarRecipe altarRecipe = recipeEntry.comp_1933();
            return altarRecipe.getCostOrDefault();
        }
        return 0;
    }

    public int getOutputXPCost() {
        return levelCost.method_17407();
    }

    @SuppressWarnings("unused")
    private class_1735[] _slots;
    private class_1735 _outputSlot;
    private class_1735 _brimstoneSlot;
    
    private boolean filling;

    public EffigyAltarScreenHandler(int syncId, class_1661 playerInventory){
        this(syncId, playerInventory, class_3914.field_17304);
    }

    public EffigyAltarScreenHandler(int syncId, class_1661 playerInventory, class_3914 context) {
        super(PeacefulMod.EFFIGY_ALTAR_SCREEN_HANDLER, syncId);
        this.inventory = new EffigySimpleInventory(this, BRIMSTONE_SLOT);
        this.resultInventory = new EffigyCraftingResultInventory(this);
        this.method_17362(this.levelCost);
        this.context = context;
        this.player = playerInventory.field_7546;

        _outputSlot = this.method_7621(new OutputSlot(this, this.player, this.inventory, this.resultInventory, 0, 132, 29 - 8));
        
        _slots = new class_1735[] {
            this.method_7621(new CustomSlot(this, this.inventory, 0, 22, 17)),
            this.method_7621(new CustomSlot(this, this.inventory, 1, 40, 17)),
            this.method_7621(new CustomSlot(this, this.inventory, 2, 58, 17)),
            this.method_7621(new CustomSlot(this, this.inventory, 3, 22, 35)),
            this.method_7621(new CustomSlot(this, this.inventory, 4, 40, 35)),
            this.method_7621(new CustomSlot(this, this.inventory, 5, 58, 35)),
            this.method_7621(new CustomSlot(this, this.inventory, 6, 40, 53))
        };
        
        _brimstoneSlot = this.method_7621(new BrimstoneSlot(this, this.inventory, 7, 89, 53 - 8));

        this.method_61624(playerInventory, 8, 84);
    }
    
    public static boolean isBrimstone(class_1799 stack) {
        return stack.method_31574(PeacefulModItems.SULPHUR);
    }
    
    public static boolean isAir(class_1799 stack) {
        return stack.method_31574(class_1802.field_8162);
    }
    
    public void updateResult(
        class_3218 world,
        @Nullable class_8786<EffigyAltarRecipe> recipe
    ) {
        EffigyAltarRecipeInput recipeInput = EffigyAltarRecipeInput.create(inventory.method_51305());
        class_3222 serverPlayerEntity = (class_3222)player;
        class_1799 resultStack = class_1799.field_8037;
        int cost = 0;
        
        if (isBrimstone(_brimstoneSlot.method_7677())) {
            Optional<class_8786<EffigyAltarRecipe>> optional = world.method_8503().method_3772().method_59993(PeacefulMod.EFFIGY_ALTAR_RECIPE_TYPE, recipeInput, world, recipe);
            if (optional.isPresent()) {
                class_8786<EffigyAltarRecipe> recipeEntry = (class_8786<EffigyAltarRecipe>)optional.get();
                EffigyAltarRecipe altarRecipe = recipeEntry.comp_1933();
                boolean shouldCraftRecipe = resultInventory.method_7665(serverPlayerEntity, recipeEntry);
                if (shouldCraftRecipe) {
                    class_1799 craftedStack = altarRecipe.craft(recipeInput, world.method_30349());
                    boolean isItemEnabled = craftedStack.method_45435(world.method_45162());
                    if (isItemEnabled) {
                        resultStack = craftedStack;
                        cost = altarRecipe.getCostOrDefault();
                    }
                }
            }
        }

        levelCost.method_17404(cost);
        resultInventory.method_5447(0, resultStack);
        this.method_34245(0, resultStack);
        serverPlayerEntity.field_13987.method_14364(new class_2653(this.field_7763, this.method_37422(), 0, resultStack));
    }

    @Override
    public void method_7609(class_1263 inventory) {
        if (!this.filling) {
            this.context.method_17393((world, pos) -> {
                if (world instanceof class_3218 serverWorld) {
                    updateResult(serverWorld, null);
                }
            });
        }
    }

    @Override
    public class_1799 method_7601(class_1657 player, int slot) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 slotAtIndex = this.field_7761.get(slot);
        if (slotAtIndex != null && slotAtIndex.method_7681() && slotAtIndex.method_7674(player)) {
            class_1799 itemStackAtIndex = slotAtIndex.method_7677();
            itemStack = itemStackAtIndex.method_7972();
            if (slot == OUTPUT_SLOT) {
                itemStackAtIndex.method_7909().method_54465(itemStackAtIndex, player);
                if (!this.method_7616(itemStackAtIndex, INVENTORY_SLOTS_START, HOTBAR_SLOTS_END, true)) {
                    return class_1799.field_8037;
                }

                slotAtIndex.method_7670(itemStackAtIndex, itemStack);
            } else if (slot >= INVENTORY_SLOTS_START && slot < HOTBAR_SLOTS_END) {
                if (!this.method_7616(itemStackAtIndex, INPUT_SLOTS_START, INVENTORY_SLOTS_START, false)) {
                    if (slot < HOTBAR_SLOTS_START) {
                        if (!this.method_7616(itemStackAtIndex, HOTBAR_SLOTS_START, HOTBAR_SLOTS_END, false)) {
                            return class_1799.field_8037;
                        }
                    } else if (!this.method_7616(itemStackAtIndex, INVENTORY_SLOTS_START, HOTBAR_SLOTS_START, false)) {
                        return class_1799.field_8037;
                    }
                }
            } else if (!this.method_7616(itemStackAtIndex, INVENTORY_SLOTS_START, HOTBAR_SLOTS_END, false)) {
                return class_1799.field_8037;
            }

            if (itemStackAtIndex.method_7960()) {
                slotAtIndex.method_53512(class_1799.field_8037);
            } else {
                slotAtIndex.method_7668();
            }

            if (itemStackAtIndex.method_7947() == itemStack.method_7947()) {
                return class_1799.field_8037;
            }

            slotAtIndex.method_7667(player, itemStackAtIndex);
            if (slot == OUTPUT_SLOT) {
                player.method_7328(itemStackAtIndex, false);
            }
        }

        return itemStack;
    }

    @Override
    public boolean method_7597(class_1657 player) {
        return method_17695(this.context, player, PeacefulModBlocks.EFFIGY_ALTAR);
    }

    @Override
    public boolean method_7613(class_1799 stack, class_1735 slot) {
        return slot.field_7871 != this.resultInventory && super.method_7613(stack, slot);
    }

    @Override
    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.context.method_17393((world, pos) -> this.method_7607(player, this.inventory));
    }

    @SuppressWarnings("unchecked")
    @Override
    public class_9885 method_17697(
        boolean craftAll, boolean creative, class_8786<?> recipe, class_3218 world, class_1661 inventory
    ) {
        class_8786<EffigyAltarRecipe> recipeEntry = (class_8786<EffigyAltarRecipe>)recipe;
        
        this.onInputSlotFillStart();

        class_1735 brimstoneSlot = this.getBrimstoneSlot();
        List<class_1735> inputSlots = this.getInputSlots();
        class_9885 postFillAction = new EffigyAltarInputSlotFiller(brimstoneSlot, inputSlots, inventory, recipeEntry, craftAll, creative).fill();

        this.onInputSlotFillFinish(world, recipeEntry);

        return postFillAction;
    }

    @Override
    public void method_7654(class_9875 finder) {
        this.inventory.method_7683(finder);
    }

    @Override
    public class_5421 method_30264() {
        return class_5421.field_25763; // Return crafting because making a RecipeBookType is impossible.
    }

    public void onInputSlotFillStart() {
        this.filling = true;
    }

    public void onInputSlotFillFinish(class_3218 world, class_8786<EffigyAltarRecipe> recipe) {
        this.filling = false;
        updateResult(world, recipe);
    }

    public class_1735 getBrimstoneSlot() {
        return this._brimstoneSlot;
    }

    public class_1735 getOutputSlot() {
        return this._outputSlot;
    }

    public List<class_1735> getInputSlots() {
        return this.field_7761.subList(INPUT_SLOTS_START, BRIMSTONE_SLOT);
    }

    public class_1657 getPlayer() {
        return this.player;
    }
    
    private class EffigySimpleInventory extends class_1277 implements class_8566 {
        private class_1703 _screen;
        EffigySimpleInventory(EffigyAltarScreenHandler screen, int size) {
            super(size);
            _screen = screen;
        }

        public void method_5431() {
            _screen.method_7609(this);
            super.method_5431();
        }

        @Override
        public int method_17398() {
            return MAX_WIDTH_AND_HEIGHT;
        }

        @Override
        public int method_17397() {
            return MAX_WIDTH_AND_HEIGHT;
        }
    }

    private class EffigyCraftingResultInventory extends class_1731 {
        private class_1703 _screen;
        EffigyCraftingResultInventory(EffigyAltarScreenHandler screen) {
            super();
            _screen = screen;
        }

        public void method_5431() {
            _screen.method_7609(this);
            super.method_5431();
        }
    }

    private class CustomSlot extends class_1735 {
        private EffigyAltarScreenHandler _altar;
        public CustomSlot(EffigyAltarScreenHandler altar, class_1263 inventory, int index, int x, int y) {
            super(inventory, index, x, y);
            _altar = altar;
        }

        @Override
        public void method_7668() {
            super.method_7668();
            _altar.method_7609(_altar.inventory);
        }

        @Override
        public boolean method_7680(class_1799 stack) {
            return !isBrimstone(stack);
        }
    }

    private class BrimstoneSlot extends CustomSlot {
        public BrimstoneSlot(EffigyAltarScreenHandler altar, class_1263 inventory, int index, int x, int y) {
            super(altar, inventory, index, x, y);
        }

        @Override
        public boolean method_7680(class_1799 stack) {
            return isAir(stack) || isBrimstone(stack);
        }
    }

    private class OutputSlot extends class_1735 {
        private final class_8566 input;
        private final class_1657 player;
        private final EffigyAltarScreenHandler handler;
        private int amount;
        public OutputSlot(EffigyAltarScreenHandler handler, class_1657 player, class_8566 input, class_1263 inventory, int index, int x, int y) {
            super(inventory, index, x, y);
            this.player = player;
            this.input = input;
            this.handler = handler;
        }

        @Override
        public boolean method_7680(class_1799 stack) {
            return false;
        }

        @Override
        public boolean method_7674(class_1657 player) {
            return handler.canTake();
        }

        @Override
        public class_1799 method_7671(int amount) {
            if (this.method_7681()) {
                this.amount = this.amount + Math.min(amount, this.method_7677().method_7947());
            }

            return super.method_7671(amount);
        }

        @Override
        protected void method_7678(class_1799 stack, int amount) {
            this.amount += amount;
            this.method_7669(stack);
        }

        @Override
        protected void method_7672(int amount) {
            this.amount += amount;
        }

        @Override
        protected void method_7669(class_1799 stack) {
            if (this.amount > 0) {
                stack.method_7982(this.player, this.amount);
            }

            if (this.field_7871 instanceof class_1732 recipeUnlocker) {
                recipeUnlocker.method_7664(this.player, this.input.method_51305());
            }

            this.amount = 0;
        }

        private static class_2371<class_1799> copyInput(EffigyAltarRecipeInput input) {
            class_2371<class_1799> defaultedList = class_2371.method_10213(input.method_59983(), class_1799.field_8037);

            for (int i = 0; i < defaultedList.size(); i++) {
                defaultedList.set(i, input.method_59984(i));
            }

            return defaultedList;
        }

        private class_2371<class_1799> getRecipeRemainders(EffigyAltarRecipeInput input, class_1937 world) {
            return world instanceof class_3218 serverWorld
                ? (class_2371<class_1799>)serverWorld.method_64577()
                    .method_8132(PeacefulMod.EFFIGY_ALTAR_RECIPE_TYPE, input, serverWorld)
                    .map(recipe -> ((EffigyAltarRecipe)recipe.comp_1933()).getRecipeRemainders(input))
                    .orElseGet(() -> copyInput(input))
                : EffigyAltarRecipe.collectRecipeRemainders(input);
        }

        @Override
        public void method_7667(class_1657 player, class_1799 stack) {
            this.method_7669(stack);
            EffigyAltarRecipeInput recipeInput = EffigyAltarRecipeInput.create(this.input.method_51305());
            class_2371<class_1799> defaultedList = this.getRecipeRemainders(recipeInput, player.method_73183());

            this.handler.context.method_17393((world, pos) -> {
                if (!player.method_56992()) {
                    player.method_7316(-getOutputXPCost());
                }
                world.method_8396((class_1297)null, pos, class_3417.field_15119, class_3419.field_15245, 1.0F, world.field_9229.method_43057() * 0.1F + 0.9F);
            });

            for (int y = 0; y < MAX_WIDTH_AND_HEIGHT; y++) {
                for (int x = 0; x < (y == MAX_WIDTH_AND_HEIGHT - 1 ? MAX_WIDTH_AND_HEIGHT - MAX_WIDTH_END : MAX_WIDTH_AND_HEIGHT); x++) {
                    int z = x + y * MAX_WIDTH_AND_HEIGHT;
                    class_1799 itemStack = this.input.method_5438(z);
                    class_1799 defaultStack = defaultedList.get(z);
                    if (!itemStack.method_7960()) {
                        this.input.method_5434(z, 1);
                        itemStack = this.input.method_5438(z);
                    }

                    if (!defaultStack.method_7960()) {
                        if (itemStack.method_7960()) {
                            this.input.method_5447(z, defaultStack);
                        } else if (class_1799.method_31577(itemStack, defaultStack)) {
                            defaultStack.method_7933(itemStack.method_7947());
                            this.input.method_5447(z, defaultStack);
                        } else if (!this.player.method_31548().method_7394(defaultStack)) {
                            this.player.method_7328(defaultStack, false);
                        }
                    }
                }
            }
        }

        @Override
        public boolean method_55059() {
            return true;
        }
    }


    private class EffigyAltarInputSlotFiller {
        private final class_1735 brimstoneSlot;
        private final List<class_1735> inputSlots;
        private final List<class_1735> slotsToReturn;
        private final class_1661 inventory;
        private final class_8786<EffigyAltarRecipe> recipe;
        private final boolean craftAll;
        private final boolean creative;
        
        public EffigyAltarInputSlotFiller(
            class_1735 brimstoneSlot,
              List<class_1735> inputSlots,
               class_1661 inventory,
               class_8786<EffigyAltarRecipe> recipe,
            boolean craftAll,
               boolean creative
           ) {
            this(brimstoneSlot, inputSlots, inputSlots, inventory, recipe, craftAll, creative);
        }
        
        public EffigyAltarInputSlotFiller(
            class_1735 brimstoneSlot,
               List<class_1735> inputSlots,
               List<class_1735> slotsToReturn,
            class_1661 inventory,
            class_8786<EffigyAltarRecipe> recipe,
            boolean craftAll,
               boolean creative
           ) {
            this.brimstoneSlot = brimstoneSlot;
            this.inputSlots = inputSlots;
            this.slotsToReturn = slotsToReturn;
            this.inventory = inventory;
            this.recipe = recipe;
            this.craftAll = craftAll;
            this.creative = creative;
        }
        
        public class_1729.class_9885 fill() {
            if (!creative && !canReturnInputs()) {
                return class_1729.class_9885.field_52572;
            } else {
                class_9875 recipeFinder = new class_9875();
                inventory.method_7387(recipeFinder);
                method_7654(recipeFinder);
                return tryFill(recipe, recipeFinder);
            }
        }

        public void clear() {
            EffigyAltarScreenHandler.this.resultInventory.method_5448();
            EffigyAltarScreenHandler.this.inventory.method_5448();
        }

        public boolean matches(class_8786<EffigyAltarRecipe> entry) {
            return entry.comp_1933()
                .matches(EffigyAltarRecipeInput.create(EffigyAltarScreenHandler.this.inventory.method_51305()), getPlayer().method_73183());
        }

        private class_1729.class_9885 tryFill(class_8786<EffigyAltarRecipe> recipe, class_9875 finder) {
            if (finder.method_61538(recipe.comp_1933(), null)) {
                this.fill(recipe, finder);
                this.inventory.method_5431();
                return class_1729.class_9885.field_52572;
            } else {
                this.returnInputs();
                this.inventory.method_5431();
                return class_1729.class_9885.field_52573;
            }
        }

        private void returnInputs() {
            for (class_1735 slot : this.slotsToReturn) {
                class_1799 itemStack = slot.method_7677().method_7972();
                this.inventory.method_32338(itemStack, false);
                slot.method_7673(itemStack);
            }
            
            class_1799 brimstoneStack = brimstoneSlot.method_7677().method_7972();
            this.inventory.method_32338(brimstoneStack, false);
            brimstoneSlot.method_7673(brimstoneStack);

            clear();
        }

        private void fill(class_8786<EffigyAltarRecipe> recipe, class_9875 finder) {
            boolean match = matches(recipe);
            int i = finder.method_61543(recipe.comp_1933(), null);
            if (match) {
                class_1799 brimstoneItemStack = brimstoneSlot.method_7677();
                if (!brimstoneItemStack.method_7960() && Math.min(i, brimstoneItemStack.method_7914()) < brimstoneItemStack.method_7947() + 1) {
                    return;
                }
                for (class_1735 slot : this.inputSlots) {
                    class_1799 itemStack = slot.method_7677();
                    if (!itemStack.method_7960() && Math.min(i, itemStack.method_7914()) < itemStack.method_7947() + 1) {
                        return;
                    }
                }
            }

            int j = this.calculateCraftAmount(i, match);
            List<class_6880<class_1792>> entries = new ArrayList<class_6880<class_1792>>();
            boolean isCraftable = finder.method_61537(recipe.comp_1933(), j, entries::add);
            if (isCraftable) {
                int k = clampToMaxCount(j, entries);
                if (k != j) {
                    entries.clear();
                    if (!finder.method_61537(recipe.comp_1933(), k, entries::add)) {
                        return;
                    }
                }

                this.returnInputs();
                EffigyAltarRecipe recipeValue = recipe.comp_1933();
                IntList placementSlots = recipeValue.method_61671().method_65800();
                class_6880<class_1792> brimstoneRegistryEntry = entries.get(placementSlots.getInt(inputSlots.size()));
                int jk = k;

                while (jk > 0) {
                    jk = this.fillInputSlot(brimstoneSlot, brimstoneRegistryEntry, jk);
                    if (jk == -1) {
                        return;
                    }
                }
                for (int index = 0; index < inputSlots.size(); index++) {
                    class_1735 slot = inputSlots.get(index);
                    int placementSlot = placementSlots.getInt(index);
                    class_6880<class_1792> registryEntry = entries.get(placementSlot);
                    int jx = k;

                    while (jx > 0) {
                        jx = this.fillInputSlot(slot, registryEntry, jx);
                        if (jx == -1) {
                            return;
                        }
                    }
                }
            }
        }

        private static int clampToMaxCount(int count, List<class_6880<class_1792>> entries) {
            for (class_6880<class_1792> registryEntry : entries) {
                count = Math.min(count, registryEntry.comp_349().method_7882());
            }

            return count;
        }

        private int calculateCraftAmount(int forCraftAll, boolean match) {
            if (this.craftAll) {
                return forCraftAll;
            } else if (match) {
                int i = Integer.MAX_VALUE;

                for (class_1735 slot : this.inputSlots) {
                    class_1799 itemStack = slot.method_7677();
                    if (!itemStack.method_7960() && i > itemStack.method_7947()) {
                        i = itemStack.method_7947();
                    }
                }

                if (i != Integer.MAX_VALUE) {
                    i++;
                }

                return i;
            } else {
                return 1;
            }
        }

        private int fillInputSlot(class_1735 slot, class_6880<class_1792> item, int count) {
            class_1799 itemStack = slot.method_7677();
            int i = this.inventory.method_61494(item, itemStack);
            if (i == -1) {
                return -1;
            } else {
                class_1799 itemStackAtIndex = this.inventory.method_5438(i);
                class_1799 itemStack3;
                if (count < itemStackAtIndex.method_7947()) {
                    itemStack3 = this.inventory.method_5434(i, count);
                } else {
                    itemStack3 = this.inventory.method_5441(i);
                }

                int j = itemStack3.method_7947();
                if (itemStack.method_7960()) {
                    slot.method_7673(itemStack3);
                } else {
                    itemStack.method_7933(j);
                }

                return count - j;
            }
        }

        private boolean canReturnInputs() {
            List<class_1799> list = Lists.<class_1799>newArrayList();
            int i = this.getFreeInventorySlots();

            for (class_1735 slot : this.inputSlots) {
                class_1799 itemStack = slot.method_7677().method_7972();
                if (!itemStack.method_7960()) {
                    int j = this.inventory.method_7390(itemStack);
                    if (j == -1 && list.size() <= i) {
                        for (class_1799 itemStack2 : list) {
                            if (class_1799.method_7984(itemStack2, itemStack)
                                && itemStack2.method_7947() != itemStack2.method_7914()
                                && itemStack2.method_7947() + itemStack.method_7947() <= itemStack2.method_7914()) {
                                itemStack2.method_7933(itemStack.method_7947());
                                itemStack.method_7939(0);
                                break;
                            }
                        }

                        if (!itemStack.method_7960()) {
                            if (list.size() >= i) {
                                return false;
                            }

                            list.add(itemStack);
                        }
                    } else if (j == -1) {
                        return false;
                    }
                }
            }

            return true;
        }

        private int getFreeInventorySlots() {
            int i = 0;

            for (class_1799 itemStack : this.inventory.method_67533()) {
                if (itemStack.method_7960()) {
                    i++;
                }
            }

            return i;
        }
    }
}
