/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtaether.growthlogic;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKit;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionManipulationContext;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class ConberryLogic
extends GrowthLogicKit {
    public static final ConfigurationProperty<Integer> MINIMUM_TRUNK_BRANCHES = ConfigurationProperty.integer((String)"minimum_trunk_branches");
    public static final ConfigurationProperty<Integer> SPLIT_ENDS_ENERGY = ConfigurationProperty.integer((String)"split_ends_energy");

    public ConberryLogic(ResourceLocation registryName) {
        super(registryName);
    }

    protected GrowthLogicKitConfiguration createDefaultConfiguration() {
        return (GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)super.createDefaultConfiguration().with(MINIMUM_TRUNK_BRANCHES, (Object)2)).with(SPLIT_ENDS_ENERGY, (Object)3);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{MINIMUM_TRUNK_BRANCHES, SPLIT_ENDS_ENERGY});
    }

    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        int[] probMap = super.populateDirectionProbabilityMap(configuration, context);
        Level level = context.level();
        Direction fromDir = context.signal().dir.m_122424_();
        List<Direction> validDirs = this.getBranchesAround(level, context.pos(), fromDir);
        if (context.signal().isInTrunk() && validDirs.size() >= (Integer)configuration.get(MINIMUM_TRUNK_BRANCHES) || !context.signal().isInTrunk() && validDirs.size() >= 1 && context.signal().energy > (float)((Integer)configuration.get(SPLIT_ENDS_ENERGY)).intValue()) {
            int[] newProb = new int[6];
            validDirs.forEach(d -> {
                newProb[d.ordinal()] = 1;
            });
            probMap = newProb;
        }
        if (context.signal().isInTrunk()) {
            probMap[1] = 0;
            probMap[0] = 0;
        }
        probMap[Direction.DOWN.ordinal()] = 0;
        probMap[fromDir.ordinal()] = 0;
        return probMap;
    }

    private List<Direction> getBranchesAround(Level level, BlockPos pos, Direction fromDir) {
        LinkedList<Direction> validDirs = new LinkedList<Direction>();
        for (Direction dir : Direction.values()) {
            if (dir == fromDir || !TreeHelper.isBranch((BlockState)level.m_8055_(pos.m_121955_(dir.m_122436_())))) continue;
            validDirs.add(dir);
        }
        return validDirs;
    }
}

