/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtaether.init;

import com.ferreusveritas.dynamictrees.api.cell.CellKit;
import com.ferreusveritas.dynamictrees.api.registry.Registry;
import com.ferreusveritas.dynamictrees.api.registry.RegistryEvent;
import com.ferreusveritas.dynamictrees.api.registry.TypeRegistryEvent;
import com.ferreusveritas.dynamictrees.block.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.block.rooty.SoilProperties;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKit;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeature;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.CommonVoxelShapes;
import maxhyper.dtaether.DynamicTreesAether;
import maxhyper.dtaether.blocks.AltTintSoilProperties;
import maxhyper.dtaether.blocks.FieldsprootLeavesProperties;
import maxhyper.dtaether.blocks.ParticleLeavesProperties;
import maxhyper.dtaether.blocks.ScruffyParticleLeavesProperties;
import maxhyper.dtaether.blocks.SnowyScruffyLeavesProperties;
import maxhyper.dtaether.cells.DTAetherCellKits;
import maxhyper.dtaether.compat.CompatHandler;
import maxhyper.dtaether.genfeatures.DTAetherGenFeatures;
import maxhyper.dtaether.growthlogic.DTAetherGrowthLogicKits;
import maxhyper.dtaether.init.ReduxOnlyFunctions;
import maxhyper.dtaether.trees.ImbuedLogFamily;
import maxhyper.dtaether.trees.ModDependentSpecies;
import maxhyper.dtaether.world.DynamicCrystalIslandFeature;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DTAetherRegistries {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"dtaether");
    public static final RegistryObject<DynamicCrystalIslandFeature> DYNAMIC_CRYSTAL_ISLAND_FEATURE = FEATURES.register("crystal_island", DynamicCrystalIslandFeature::new);
    public static final VoxelShape CLOUDCAP_CAP = Block.m_49796_((double)5.5, (double)3.0, (double)5.5, (double)10.5, (double)10.0, (double)10.5);
    public static final VoxelShape CLOUDCAP = Shapes.m_83110_((VoxelShape)CommonVoxelShapes.MUSHROOM_STEM, (VoxelShape)CLOUDCAP_CAP);

    public static void setup(IEventBus modBus) {
        FEATURES.register(modBus);
        CompatHandler.setup();
    }

    public static void setupBlocks() {
        CommonVoxelShapes.SHAPES.put(DynamicTreesAether.location("cloudcap").toString(), CLOUDCAP);
        if (ModList.get().isLoaded("aether_redux")) {
            ReduxOnlyFunctions.setupConnectables();
        }
    }

    @SubscribeEvent
    public static void onGenFeatureRegistry(RegistryEvent<GenFeature> event) {
        DTAetherGenFeatures.register((Registry<GenFeature>)event.getRegistry());
    }

    @SubscribeEvent
    public static void onCellKitRegistry(RegistryEvent<CellKit> event) {
        DTAetherCellKits.register((Registry<CellKit>)event.getRegistry());
    }

    @SubscribeEvent
    public static void onGrowthLogicKitRegistry(RegistryEvent<GrowthLogicKit> event) {
        DTAetherGrowthLogicKits.register((Registry<GrowthLogicKit>)event.getRegistry());
    }

    @SubscribeEvent
    public static void registerSpeciesTypes(TypeRegistryEvent<Species> event) {
        event.registerType(DynamicTreesAether.location("mod_dependent"), ModDependentSpecies.TYPE);
    }

    @SubscribeEvent
    public static void registerFamilyTypes(TypeRegistryEvent<Family> event) {
        event.registerType(DynamicTreesAether.location("imbued_log"), ImbuedLogFamily.TYPE);
    }

    @SubscribeEvent
    public static void registerSoilPropertiesTypes(TypeRegistryEvent<SoilProperties> event) {
        event.registerType(DynamicTreesAether.location("alt_tint"), AltTintSoilProperties.TYPE);
    }

    @SubscribeEvent
    public static void registerLeavesPropertiesTypes(TypeRegistryEvent<LeavesProperties> event) {
        event.registerType(DynamicTreesAether.location("fieldsproot"), FieldsprootLeavesProperties.TYPE);
        event.registerType(DynamicTreesAether.location("particle"), ParticleLeavesProperties.TYPE);
        event.registerType(DynamicTreesAether.location("scruffy_particle"), ScruffyParticleLeavesProperties.TYPE);
        event.registerType(DynamicTreesAether.location("scruffy_snowy"), SnowyScruffyLeavesProperties.TYPE);
    }
}

