/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtaether.mushroomlogic;

import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictreesplus.block.mushroom.DynamicCapCenterBlock;
import com.ferreusveritas.dynamictreesplus.systems.mushroomlogic.MushroomShapeConfiguration;
import com.ferreusveritas.dynamictreesplus.systems.mushroomlogic.context.MushroomCapContext;
import com.ferreusveritas.dynamictreesplus.systems.mushroomlogic.shapekits.MushroomShapeKit;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class BallShape
extends MushroomShapeKit {
    public static final ConfigurationProperty<Float> HORIZONTAL_STRETCH = ConfigurationProperty.floatProperty((String)"chance_to_age");

    public BallShape(ResourceLocation registryName) {
        super(registryName);
    }

    @NotNull
    public MushroomShapeConfiguration getDefaultConfiguration() {
        return (MushroomShapeConfiguration)((MushroomShapeConfiguration)((MushroomShapeConfiguration)((MushroomShapeConfiguration)this.defaultConfiguration).with(CHANCE_TO_AGE, (Object)Float.valueOf(0.75f))).with(MAX_CAP_AGE, (Object)6)).with(HORIZONTAL_STRETCH, (Object)Float.valueOf(0.88f));
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{CHANCE_TO_AGE, MAX_CAP_AGE, HORIZONTAL_STRETCH});
    }

    public List<BlockPos> getShapeCluster(MushroomShapeConfiguration configuration, MushroomCapContext context) {
        return this.placeRing(configuration, context, ringAction.GET);
    }

    public int getMaxCapAge(MushroomShapeConfiguration configuration) {
        return (Integer)configuration.get(MAX_CAP_AGE);
    }

    public float getChanceToAge(MushroomShapeConfiguration configuration) {
        return ((Float)configuration.get(CHANCE_TO_AGE)).floatValue();
    }

    public void generateMushroomCap(MushroomShapeConfiguration configuration, MushroomCapContext context) {
        this.placeRing(configuration, context, ringAction.PLACE);
    }

    public void clearMushroomCap(MushroomShapeConfiguration configuration, MushroomCapContext context) {
        this.placeRing(configuration, context, ringAction.CLEAR);
    }

    private List<BlockPos> placeRing(MushroomShapeConfiguration configuration, MushroomCapContext context, ringAction action) {
        DynamicCapCenterBlock centerBlock = context.species().getCapProperties().getDynamicCapCenterBlock().orElse(null);
        LinkedList<BlockPos> ringPositions = new LinkedList<BlockPos>();
        if (centerBlock != null) {
            int age = context.age();
            float yOffset = age % 2 == 0 ? -0.5f : 0.0f;
            float semiRadius = (float)age / 2.0f - 0.5f;
            float horizontalStretch = ((Float)configuration.get(HORIZONTAL_STRETCH)).floatValue();
            int prevRad = 0;
            for (int i = 0; i < age; ++i) {
                int y = i - (int)Math.floor(semiRadius);
                int yDelta = Math.abs(y);
                int radius = Math.max((int)Math.ceil((double)horizontalStretch * Math.sqrt(Math.pow(semiRadius, 2.0) - Math.pow((float)y + yOffset, 2.0))), 1);
                BlockPos pos = context.pos().m_6625_(y);
                BlockState posState = context.level().m_8055_(pos);
                if (action == ringAction.CLEAR) {
                    for (j = 1; j <= radius; ++j) {
                        centerBlock.clearRing(context.level(), pos, j);
                    }
                } else if (action == ringAction.PLACE) {
                    for (j = 1; j <= radius; ++j) {
                        if (DynamicCapCenterBlock.canCapReplace((BlockState)posState)) {
                            context.level().m_7731_(pos, centerBlock.f_60439_.getDynamicCapState(Math.max(yDelta, 1)), 3);
                        }
                        if (centerBlock.placeRing(context.level(), pos, j, j + yDelta, radius != prevRad, false)) {
                            continue;
                        }
                        break;
                    }
                } else if (action == ringAction.GET) {
                    for (j = 1; j <= radius; ++j) {
                        ringPositions.addAll(centerBlock.getRing(context.level(), pos, j));
                        if (!centerBlock.f_60439_.isPartOfCap(posState)) continue;
                        ringPositions.add(pos);
                    }
                }
                prevRad = radius;
            }
            ringPositions.add(context.pos());
        }
        return ringPositions;
    }

    static enum ringAction {
        PLACE,
        CLEAR,
        GET;

    }
}

