/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtaether.trees;

import com.ferreusveritas.dynamictrees.api.data.BranchStateGenerator;
import com.ferreusveritas.dynamictrees.api.data.Generator;
import com.ferreusveritas.dynamictrees.api.registry.RegistryHandler;
import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.compat.waila.WailaOther;
import com.ferreusveritas.dynamictrees.data.provider.BranchLoaderBuilder;
import com.ferreusveritas.dynamictrees.data.provider.DTBlockStateProvider;
import com.ferreusveritas.dynamictrees.data.provider.DTLangProvider;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictrees.util.MutableLazyValue;
import com.ferreusveritas.dynamictrees.util.Optionals;
import com.ferreusveritas.dynamictrees.util.ResourceLocationUtils;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import maxhyper.dtaether.blocks.ImbuedBranchBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataProvider;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ImbuedLogFamily
extends Family {
    public static final TypedRegistry.EntryType<Family> TYPE = TypedRegistry.newType(ImbuedLogFamily::new);
    protected Supplier<BranchBlock> imbuedBranch;
    protected Block primitiveImbuedLog;
    protected Item imbuedDropItem;
    protected ResourceLocation imbuedBranchName;
    protected ResourceLocation stripLootLocation;
    protected final MutableLazyValue<Generator<DTBlockStateProvider, Family>> imbuedBranchStateGenerator = MutableLazyValue.supplied(ImbuedBranchStateGenerator::new);

    public ImbuedLogFamily(ResourceLocation name) {
        super(name);
    }

    public void setupBlocks() {
        super.setupBlocks();
        this.imbuedBranch = this.setupBranch(this.createImbuedBranch(this.getBranchName("imbued_")), true);
    }

    public void generateLangData(DTLangProvider provider) {
        super.generateLangData(provider);
    }

    public void setStripLootLocation(ResourceLocation stripLootLocation) {
        this.stripLootLocation = stripLootLocation;
    }

    public ResourceLocation getStripLootLocation() {
        return this.stripLootLocation;
    }

    protected Supplier<BranchBlock> createImbuedBranch(ResourceLocation name) {
        return RegistryHandler.addBlock((ResourceLocation)ResourceLocationUtils.suffix((ResourceLocation)name, (String)this.getBranchNameSuffix()), () -> this.createImbuedBranchBlock(name));
    }

    public boolean stripBranch(BlockState state, Level level, BlockPos pos, Player player, ItemStack heldItem) {
        if (this.hasStrippedBranch()) {
            BranchBlock branch;
            BranchBlock branchBlock = branch = state.m_60734_() instanceof ImbuedBranchBlock ? (BranchBlock)this.getImbuedBranch().orElse(null) : (BranchBlock)this.getBranch().orElse(null);
            if (branch != null && !branch.isStrippedBranch()) {
                branch.stripBranch(state, level, pos, player, heldItem);
                if (level.f_46443_) {
                    level.m_5594_(player, pos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    WailaOther.invalidateWailaPosition();
                }
            }
            return this.getBranch().isPresent();
        }
        return false;
    }

    protected BranchBlock createImbuedBranchBlock(ResourceLocation name) {
        ImbuedBranchBlock branch = new ImbuedBranchBlock(name, this.getProperties());
        if (this.isFireProof()) {
            branch.setFireSpreadSpeed(0).setFlammability(0);
        }
        return branch;
    }

    public void setImbuedBranchName(ResourceLocation imbuedBranchName) {
        this.imbuedBranchName = imbuedBranchName;
    }

    public Family setPrimitiveImbuedLog(Block primitiveLog) {
        this.primitiveImbuedLog = primitiveLog;
        return this;
    }

    public Family setImbuedDropItem(Item imbuedDropItem) {
        this.imbuedDropItem = imbuedDropItem;
        this.imbuedBranch.get().setPrimitiveLogDrops(new ItemStack[]{new ItemStack((ItemLike)imbuedDropItem), new ItemStack((ItemLike)this.getPrimitiveLog().orElse(Blocks.f_50016_))});
        return this;
    }

    public Optional<BranchBlock> getImbuedBranch() {
        return Optionals.ofBlock((Block)this.imbuedBranch.get());
    }

    public Optional<Block> getPrimitiveImbuedLog() {
        return Optionals.ofBlock((Block)this.primitiveImbuedLog);
    }

    public Optional<Item> getImbuedDropItem() {
        return Optionals.ofItem((Item)this.imbuedDropItem);
    }

    public void generateStateData(DTBlockStateProvider provider) {
        super.generateStateData(provider);
        ((Generator)this.imbuedBranchStateGenerator.get()).generate((DataProvider)provider, (Object)this);
    }

    public void addGoldenBranchTextures(BiConsumer<String, ResourceLocation> textureConsumer, ResourceLocation primitiveLogLocation, Block sourceBlock) {
        ResourceLocation bark = primitiveLogLocation;
        ResourceLocation rings = ResourceLocationUtils.suffix((ResourceLocation)primitiveLogLocation, (String)"_top");
        if (this.textureOverrides.containsKey("imbued_branch")) {
            bark = (ResourceLocation)this.textureOverrides.get("imbued_branch");
        }
        if (this.textureOverrides.containsKey("branch_top")) {
            rings = (ResourceLocation)this.textureOverrides.get("branch_top");
        }
        textureConsumer.accept("bark", bark);
        textureConsumer.accept("rings", rings);
    }

    public void addGeneratedBlockTags(Function<TagKey<Block>, IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block>> tagAppender) {
        super.addGeneratedBlockTags(tagAppender);
        this.getImbuedBranch().ifPresent(branch -> {
            this.tierTag(this.getDefaultBranchHarvestTier(), tagAppender).ifPresent(tagBuilder -> tagBuilder.m_255245_(branch));
            this.defaultBranchTags().forEach(tag -> {
                if (!this.isOnlyIfLoaded()) {
                    ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)tagAppender.apply((TagKey<Block>)tag)).m_255245_(branch);
                } else {
                    ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)tagAppender.apply((TagKey<Block>)tag)).m_176839_(BuiltInRegistries.f_256975_.m_7981_(branch));
                }
            });
        });
    }

    public static class ImbuedBranchStateGenerator
    extends BranchStateGenerator {
        @NotNull
        public Generator.Dependencies gatherDependencies(@NotNull Family input) {
            if (input instanceof ImbuedLogFamily) {
                ImbuedLogFamily castedInput = (ImbuedLogFamily)input;
                return new Generator.Dependencies().append(BRANCH, castedInput.getImbuedBranch()).append(PRIMITIVE_LOG, castedInput.getPrimitiveImbuedLog());
            }
            return super.gatherDependencies(input);
        }

        public void generate(DTBlockStateProvider provider, @NotNull Family input, Generator.Dependencies dependencies) {
            BranchBlock branch = (BranchBlock)dependencies.get(BRANCH);
            BranchLoaderBuilder builder = (BranchLoaderBuilder)((BlockModelBuilder)provider.models().getBuilder(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)branch)).m_135815_())).customLoader(branch.getFamily().getBranchLoaderConstructor());
            Block block = (Block)dependencies.get(PRIMITIVE_LOG);
            Objects.requireNonNull(builder);
            if (input instanceof ImbuedLogFamily) {
                ImbuedLogFamily goldenLogFamily = (ImbuedLogFamily)input;
                goldenLogFamily.addGoldenBranchTextures((arg_0, arg_1) -> ((BranchLoaderBuilder)builder).texture(arg_0, arg_1), provider.block(ForgeRegistries.BLOCKS.getKey((Object)block)), block);
                provider.simpleBlock((Block)branch, (ModelFile)builder.end());
            }
        }
    }
}

